/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import m.fixed_t;
import p.AbstractLevelLoader;
import p.Actions.ActionsSectors;
import p.MapUtils;
import p.divline_t;
import p.mobj_t;
import rr.SceneRenderer;
import rr.line_t;
import rr.node_t;
import rr.sector_t;
import rr.subsector_t;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsSight
extends ActionsSectors {
    public static final TraitFactory.ContextKey<Sight> KEY_SIGHT = ACTION_KEY_CHAIN.newKey(ActionsSight.class, Sight::new);

    default public boolean CheckSight(mobj_t t1, mobj_t t2) {
        AbstractLevelLoader ll = this.levelLoader();
        Sight sight = this.contextRequire(KEY_SIGHT);
        ActionsSectors.Spawn spawn = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        int s1 = t1.subsector.sector.id;
        int s2 = t2.subsector.sector.id;
        int pnum = s1 * ll.numsectors + s2;
        int bytenum = pnum >> 3;
        int bitnum = 1 << (pnum & 7);
        if (C2JUtils.eval(ll.rejectmatrix[bytenum] & bitnum)) {
            sight.sightcounts[0] = sight.sightcounts[0] + 1;
            return false;
        }
        sight.sightcounts[1] = sight.sightcounts[1] + 1;
        this.sceneRenderer().increaseValidCount(1);
        sight.sightzstart = t1.z + t1.height - (t1.height >> 2);
        spawn.topslope = t2.z + t2.height - sight.sightzstart;
        spawn.bottomslope = t2.z - sight.sightzstart;
        sight.strace.x = t1.x;
        sight.strace.y = t1.y;
        sight.t2x = t2.x;
        sight.t2y = t2.y;
        sight.strace.dx = t2.x - t1.x;
        sight.strace.dy = t2.y - t1.y;
        return this.CrossBSPNode(ll.numnodes - 1);
    }

    default public boolean CrossSubsector(int num) {
        SceneRenderer<?, ?> sr = this.sceneRenderer();
        AbstractLevelLoader ll = this.levelLoader();
        ActionsSectors.Spawn spawn = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        Sight sight = this.contextRequire(KEY_SIGHT);
        divline_t divl = new divline_t();
        subsector_t sub = ll.subsectors[num];
        int seg = sub.firstline;
        for (int count = sub.numlines; count > 0; --count) {
            line_t line = ll.segs[seg].linedef;
            if (line.validcount != sr.getValidCount()) {
                int s2;
                line.validcount = sr.getValidCount();
                int s1 = sight.strace.DivlineSide(line.v1x, line.v1y);
                if (s1 != (s2 = sight.strace.DivlineSide(line.v2x, line.v2y))) {
                    divl.x = line.v1x;
                    divl.y = line.v1y;
                    divl.dx = line.v2x - line.v1x;
                    divl.dy = line.v2y - line.v1y;
                    s1 = divl.DivlineSide(sight.strace.x, sight.strace.y);
                    if (s1 != (s2 = divl.DivlineSide(sight.t2x, sight.t2y))) {
                        if (!C2JUtils.flags(line.flags, 4)) {
                            return false;
                        }
                        sector_t front = ll.segs[seg].frontsector;
                        sector_t back = ll.segs[seg].backsector;
                        if (front.floorheight != back.floorheight || front.ceilingheight != back.ceilingheight) {
                            int slope;
                            int opentop;
                            int openbottom = front.floorheight > back.floorheight ? front.floorheight : back.floorheight;
                            if (openbottom >= (opentop = front.ceilingheight < back.ceilingheight ? front.ceilingheight : back.ceilingheight)) {
                                return false;
                            }
                            int frac = MapUtils.P_InterceptVector(sight.strace, divl);
                            if (front.floorheight != back.floorheight && (slope = fixed_t.FixedDiv(openbottom - sight.sightzstart, frac)) > spawn.bottomslope) {
                                spawn.bottomslope = slope;
                            }
                            if (front.ceilingheight != back.ceilingheight && (slope = fixed_t.FixedDiv(opentop - sight.sightzstart, frac)) < spawn.topslope) {
                                spawn.topslope = slope;
                            }
                            if (spawn.topslope <= spawn.bottomslope) {
                                return false;
                            }
                        }
                    }
                }
            }
            ++seg;
        }
        return true;
    }

    default public boolean CrossBSPNode(int bspnum) {
        AbstractLevelLoader ll = this.levelLoader();
        Sight sight = this.contextRequire(KEY_SIGHT);
        if (C2JUtils.eval(bspnum & Integer.MIN_VALUE)) {
            if (bspnum == -1) {
                return this.CrossSubsector(0);
            }
            return this.CrossSubsector(bspnum & Integer.MAX_VALUE);
        }
        node_t bsp = ll.nodes[bspnum];
        int side = bsp.DivlineSide(sight.strace.x, sight.strace.y);
        if (side == 2) {
            side = 0;
        }
        if (!this.CrossBSPNode(bsp.children[side])) {
            return false;
        }
        if (side == bsp.DivlineSide(sight.t2x, sight.t2y)) {
            return true;
        }
        return this.CrossBSPNode(bsp.children[side ^ 1]);
    }

    public static class Sight {
        int sightzstart;
        divline_t strace = new divline_t();
        int t2x;
        int t2y;
        int[] sightcounts = new int[2];
    }
}

