/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import doom.thinker_t;
import java.util.logging.Level;
import mochadoom.Loggers;
import p.AbstractLevelLoader;
import p.Actions.ActionTrait;
import p.ActiveStates;
import p.mobj_t;
import p.sd_e;
import p.sdt_e;
import p.slidedoor_t;
import p.slideframe_t;
import p.slidename_t;
import rr.TextureManager;
import rr.line_t;
import rr.sector_t;
import utils.GenericCopy;
import utils.TraitFactory;

public interface ActionsSlideDoors
extends ActionTrait {
    public static final TraitFactory.ContextKey<SlideDoors> KEY_SLIDEDOORS = ACTION_KEY_CHAIN.newKey(ActionsSlideDoors.class, SlideDoors::new);
    public static final int MAXSLIDEDOORS = 5;
    public static final int SNUMFRAMES = 4;
    public static final int SDOORWAIT = 105;
    public static final int SWAITTICS = 4;
    public static final slidename_t[] slideFrameNames = new slidename_t[]{new slidename_t("GDOORF1", "GDOORF2", "GDOORF3", "GDOORF4", "GDOORB1", "GDOORB2", "GDOORB3", "GDOORB4"), new slidename_t(), new slidename_t(), new slidename_t(), new slidename_t()};

    @Override
    public void RemoveThinker(thinker_t var1);

    default public void SlidingDoor(slidedoor_t door) {
        AbstractLevelLoader ll = this.levelLoader();
        SlideDoors sd = this.contextRequire(KEY_SLIDEDOORS);
        switch (door.status) {
            case sd_opening: {
                if (door.timer-- != 0) break;
                if (++door.frame == 4) {
                    ll.sides[door.line.sidenum[0]].midtexture = 0;
                    ll.sides[door.line.sidenum[1]].midtexture = 0;
                    door.line.flags = (short)(door.line.flags & 0xFE);
                    if (door.type == sdt_e.sdt_openOnly) {
                        door.frontsector.specialdata = null;
                        this.RemoveThinker(door);
                        break;
                    }
                    door.timer = 105;
                    door.status = sd_e.sd_waiting;
                    break;
                }
                door.timer = 4;
                ll.sides[door.line.sidenum[0]].midtexture = (short)sd.slideFrames[door.whichDoorIndex].frontFrames[door.frame];
                ll.sides[door.line.sidenum[1]].midtexture = (short)sd.slideFrames[door.whichDoorIndex].backFrames[door.frame];
                break;
            }
            case sd_waiting: {
                if (door.timer-- != 0) break;
                if (door.frontsector.thinglist != null || door.backsector.thinglist != null) {
                    door.timer = 105;
                    break;
                }
                door.status = sd_e.sd_closing;
                door.timer = 4;
                break;
            }
            case sd_closing: {
                if (door.timer-- != 0) break;
                if (--door.frame < 0) {
                    door.line.flags = (short)(door.line.flags | 1);
                    door.frontsector.specialdata = null;
                    this.RemoveThinker(door);
                    break;
                }
                door.timer = 4;
                ll.sides[door.line.sidenum[0]].midtexture = (short)sd.slideFrames[door.whichDoorIndex].frontFrames[door.frame];
                ll.sides[door.line.sidenum[1]].midtexture = (short)sd.slideFrames[door.whichDoorIndex].backFrames[door.frame];
            }
        }
    }

    default public void P_InitSlidingDoorFrames() {
        TextureManager tm = this.DOOM().textureManager;
        SlideDoors sd = this.contextRequire(KEY_SLIDEDOORS);
        if (!this.DOOM().isCommercial()) {
            return;
        }
        for (int i = 0; i < 5 && ActionsSlideDoors.slideFrameNames[i].frontFrame1 != null; ++i) {
            int f1 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].frontFrame1);
            int f2 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].frontFrame2);
            int f3 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].frontFrame3);
            int f4 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].frontFrame4);
            sd.slideFrames[i].frontFrames[0] = f1;
            sd.slideFrames[i].frontFrames[1] = f2;
            sd.slideFrames[i].frontFrames[2] = f3;
            sd.slideFrames[i].frontFrames[3] = f4;
            f1 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].backFrame1);
            f2 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].backFrame2);
            f3 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].backFrame3);
            f4 = tm.TextureNumForName(ActionsSlideDoors.slideFrameNames[i].backFrame4);
            sd.slideFrames[i].backFrames[0] = f1;
            sd.slideFrames[i].backFrames[1] = f2;
            sd.slideFrames[i].backFrames[2] = f3;
            sd.slideFrames[i].backFrames[3] = f4;
        }
    }

    default public int P_FindSlidingDoorType(line_t line) {
        AbstractLevelLoader ll = this.levelLoader();
        SlideDoors sd = this.contextRequire(KEY_SLIDEDOORS);
        for (int i = 0; i < 5; ++i) {
            short val = ll.sides[line.sidenum[0]].midtexture;
            if (val != sd.slideFrames[i].frontFrames[0]) continue;
            return i;
        }
        return -1;
    }

    default public void EV_SlidingDoor(line_t line, mobj_t thing) {
        if (!this.DOOM().isCommercial()) {
            return;
        }
        Loggers.getLogger(ActionsSlideDoors.class.getName()).log(Level.WARNING, "EV_SlidingDoor");
        sector_t sec = line.frontsector;
        slidedoor_t door = null;
        if (sec.specialdata != null) {
            if (thing.player == null) {
                return;
            }
            door = (slidedoor_t)sec.specialdata;
            if (door.type == sdt_e.sdt_openAndClose) {
                if (door.status == sd_e.sd_waiting) {
                    door.status = sd_e.sd_closing;
                }
            } else {
                return;
            }
        }
        if (door == null) {
            door = new slidedoor_t();
            this.AddThinker(door);
            sec.specialdata = door;
            door.type = sdt_e.sdt_openAndClose;
            door.status = sd_e.sd_opening;
            door.whichDoorIndex = this.P_FindSlidingDoorType(line);
            if (door.whichDoorIndex < 0) {
                this.doomSystem().Error("EV_SlidingDoor: Can't use texture for sliding door!");
            }
            door.frontsector = sec;
            door.backsector = line.backsector;
            door.thinkerFunction = ActiveStates.T_SlidingDoor;
            door.timer = 4;
            door.frame = 0;
            door.line = line;
        }
    }

    public static final class SlideDoors {
        slideframe_t[] slideFrames = (slideframe_t[])GenericCopy.malloc(slideframe_t::new, slideframe_t[]::new, 5);
    }
}

