/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Tables;
import data.mobjtype_t;
import data.sounds;
import doom.thinker_t;
import p.AbstractLevelLoader;
import p.Actions.ActionTrait;
import p.Actions.ActionsSectors;
import p.ActiveStates;
import p.mobj_t;
import rr.line_t;
import rr.sector_t;
import rr.subsector_t;
import s.ISoundOrigin;

public interface ActionsTeleportation
extends ActionsSectors {
    public void UnsetThingPosition(mobj_t var1);

    @Override
    default public int Teleport(line_t line, int side, mobj_t thing) {
        if ((thing.flags & 0x10000L) != 0L) {
            return 0;
        }
        if (side == 1) {
            return 0;
        }
        short tag = line.tag;
        for (int i = 0; i < this.levelLoader().numsectors; ++i) {
            if (this.levelLoader().sectors[i].tag != tag) continue;
            thinker_t thinker = this.getThinkerCap().next;
            while (thinker != this.getThinkerCap()) {
                if (thinker.thinkerFunction == ActiveStates.P_MobjThinker) {
                    mobj_t m = (mobj_t)thinker;
                    if (m.type == mobjtype_t.MT_TELEPORTMAN) {
                        sector_t sector = m.subsector.sector;
                        if (sector.id == i) {
                            int oldx = thing.x;
                            int oldy = thing.y;
                            int oldz = thing.z;
                            if (!this.TeleportMove(thing, m.x, m.y)) {
                                return 0;
                            }
                            thing.z = thing.floorz;
                            if (thing.player != null) {
                                thing.player.viewz = thing.z + thing.player.viewheight;
                                thing.player.lookdir = 0;
                            }
                            mobj_t fog = this.SpawnMobj(oldx, oldy, oldz, mobjtype_t.MT_TFOG);
                            this.StartSound((ISoundOrigin)fog, sounds.sfxenum_t.sfx_telept);
                            int an = Tables.toBAMIndex(m.angle);
                            fog = this.SpawnMobj(m.x + 20 * Tables.finecosine[an], m.y + 20 * Tables.finesine[an], thing.z, mobjtype_t.MT_TFOG);
                            this.StartSound((ISoundOrigin)fog, sounds.sfxenum_t.sfx_telept);
                            if (thing.player != null) {
                                thing.reactiontime = 18;
                            }
                            thing.angle = m.angle;
                            thing.momz = 0;
                            thing.momy = 0;
                            thing.momx = 0;
                            return 1;
                        }
                    }
                }
                thinker = thinker.next;
            }
        }
        return 0;
    }

    default public boolean TeleportMove(mobj_t thing, int x, int y) {
        ActionTrait.Spechits spechits = (ActionTrait.Spechits)this.contextRequire(KEY_SPECHITS);
        AbstractLevelLoader ll = this.levelLoader();
        ActionTrait.Movement ma = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        ma.tmthing = thing;
        ma.tmflags = thing.flags;
        ma.tmx = x;
        ma.tmy = y;
        ma.tmbbox[0] = y + ma.tmthing.radius;
        ma.tmbbox[1] = y - ma.tmthing.radius;
        ma.tmbbox[3] = x + ma.tmthing.radius;
        ma.tmbbox[2] = x - ma.tmthing.radius;
        subsector_t newsubsec = ll.PointInSubsector(x, y);
        ma.ceilingline = null;
        ma.tmfloorz = ma.tmdropoffz = newsubsec.sector.floorheight;
        ma.tmceilingz = newsubsec.sector.ceilingheight;
        this.sceneRenderer().increaseValidCount(1);
        spechits.numspechit = 0;
        int xl = ll.getSafeBlockX(ma.tmbbox[2] - ll.bmaporgx - 0x200000);
        int xh = ll.getSafeBlockX(ma.tmbbox[3] - ll.bmaporgx + 0x200000);
        int yl = ll.getSafeBlockY(ma.tmbbox[1] - ll.bmaporgy - 0x200000);
        int yh = ll.getSafeBlockY(ma.tmbbox[0] - ll.bmaporgy + 0x200000);
        for (int bx = xl; bx <= xh; ++bx) {
            for (int by = yl; by <= yh; ++by) {
                if (this.BlockThingsIterator(bx, by, this::StompThing)) continue;
                return false;
            }
        }
        this.UnsetThingPosition(thing);
        thing.floorz = ma.tmfloorz;
        thing.ceilingz = ma.tmceilingz;
        thing.x = x;
        thing.y = y;
        ll.SetThingPosition(thing);
        return true;
    }
}

