/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.mobjtype_t;
import data.sounds;
import defines.ammotype_t;
import defines.card_t;
import doom.DoomMain;
import doom.player_t;
import doom.weapontype_t;
import m.Settings;
import p.Actions.ActionTrait;
import p.mobj_t;
import utils.C2JUtils;

public interface ActionsThings
extends ActionTrait {
    public void DamageMobj(mobj_t var1, mobj_t var2, mobj_t var3, int var4);

    public void RemoveMobj(mobj_t var1);

    @Override
    default public boolean CheckThing(mobj_t thing) {
        ActionTrait.Movement movm = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if ((thing.flags & 7L) == 0L) {
            return true;
        }
        int blockdist = thing.radius + movm.tmthing.radius;
        if (Math.abs(thing.x - movm.tmx) >= blockdist || Math.abs(thing.y - movm.tmy) >= blockdist) {
            return true;
        }
        if (thing == movm.tmthing) {
            return true;
        }
        if ((movm.tmthing.flags & 0x1000000L) != 0L) {
            int damage = (this.P_Random() % 8 + 1) * movm.tmthing.info.damage;
            this.DamageMobj(thing, movm.tmthing, movm.tmthing, damage);
            movm.tmthing.flags &= 0xFFFFFFFFFEFFFFFFL;
            movm.tmthing.momz = 0;
            movm.tmthing.momy = 0;
            movm.tmthing.momx = 0;
            movm.tmthing.SetMobjState(movm.tmthing.info.spawnstate);
            return false;
        }
        if (C2JUtils.eval(movm.tmthing.flags & 0x10000L)) {
            if (movm.tmthing.z > thing.z + thing.height) {
                return true;
            }
            if (movm.tmthing.z + movm.tmthing.height < thing.z) {
                return true;
            }
            if (movm.tmthing.target != null && (movm.tmthing.target.type == thing.type || movm.tmthing.target.type == mobjtype_t.MT_KNIGHT && thing.type == mobjtype_t.MT_BRUISER || movm.tmthing.target.type == mobjtype_t.MT_BRUISER && thing.type == mobjtype_t.MT_KNIGHT)) {
                if (thing == movm.tmthing.target) {
                    return true;
                }
                if (thing.type != mobjtype_t.MT_PLAYER) {
                    return false;
                }
            }
            if (!C2JUtils.eval(thing.flags & 4L)) {
                return !C2JUtils.eval(thing.flags & 2L);
            }
            int damage = (this.P_Random() % 8 + 1) * movm.tmthing.info.damage;
            this.DamageMobj(thing, movm.tmthing, movm.tmthing.target, damage);
            return false;
        }
        if (C2JUtils.eval(thing.flags & 1L)) {
            boolean solid = C2JUtils.eval(thing.flags & 2L);
            if (C2JUtils.eval(movm.tmflags & 0x800L)) {
                this.TouchSpecialThing(thing, movm.tmthing);
            }
            return !solid;
        }
        return !C2JUtils.eval(thing.flags & 2L);
    }

    default public void TouchSpecialThing(mobj_t special, mobj_t toucher) {
        DoomMain<?, ?> DOOM = this.DOOM();
        int delta = special.z - toucher.z;
        if (delta > toucher.height || delta < -524288) {
            return;
        }
        sounds.sfxenum_t sound = sounds.sfxenum_t.sfx_itemup;
        player_t player = toucher.player;
        if (toucher.health <= 0) {
            return;
        }
        switch (special.mobj_sprite) {
            case SPR_ARM1: {
                if (!player.GiveArmor(1)) {
                    return;
                }
                player.message = "Picked up the armor.";
                break;
            }
            case SPR_ARM2: {
                if (!player.GiveArmor(2)) {
                    return;
                }
                player.message = "Picked up the MegaArmor!";
                break;
            }
            case SPR_BON1: {
                player.health[0] = player.health[0] + 1;
                if (player.health[0] > 200) {
                    player.health[0] = 200;
                }
                player.mo.health = player.health[0];
                player.message = "Picked up a health bonus.";
                break;
            }
            case SPR_BON2: {
                player.armorpoints[0] = player.armorpoints[0] + 1;
                if (player.armorpoints[0] > 200) {
                    player.armorpoints[0] = 200;
                }
                if (player.armortype == 0) {
                    player.armortype = 1;
                }
                player.message = "Picked up an armor bonus.";
                break;
            }
            case SPR_SOUL: {
                player.health[0] = player.health[0] + 100;
                if (player.health[0] > 200) {
                    player.health[0] = 200;
                }
                player.mo.health = player.health[0];
                player.message = "Supercharge!";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_MEGA: {
                if (!DOOM.isCommercial()) {
                    return;
                }
                player.health[0] = 200;
                player.mo.health = player.health[0];
                player.GiveArmor(2);
                player.message = "MegaSphere!";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_BKEY: {
                if (!player.cards[card_t.it_bluecard.ordinal()]) {
                    player.message = "Picked up a blue keycard.";
                }
                player.GiveCard(card_t.it_bluecard);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_YKEY: {
                if (!player.cards[card_t.it_yellowcard.ordinal()]) {
                    player.message = "Picked up a yellow keycard.";
                }
                player.GiveCard(card_t.it_yellowcard);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_RKEY: {
                if (!player.cards[card_t.it_redcard.ordinal()]) {
                    player.message = "Picked up a red keycard.";
                }
                player.GiveCard(card_t.it_redcard);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_BSKU: {
                if (!player.cards[card_t.it_blueskull.ordinal()]) {
                    player.message = "Picked up a blue skull key.";
                }
                player.GiveCard(card_t.it_blueskull);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_YSKU: {
                if (!player.cards[card_t.it_yellowskull.ordinal()]) {
                    player.message = "Picked up a yellow skull key.";
                }
                player.GiveCard(card_t.it_yellowskull);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_RSKU: {
                if (!player.cards[card_t.it_redskull.ordinal()]) {
                    player.message = "Picked up a red skull key.";
                }
                player.GiveCard(card_t.it_redskull);
                if (!DOOM.netgame) break;
                return;
            }
            case SPR_STIM: {
                if (!player.GiveBody(10)) {
                    return;
                }
                player.message = "Picked up a stimpack.";
                break;
            }
            case SPR_MEDI: {
                boolean need;
                boolean bl = need = player.health[0] < 25;
                if (!player.GiveBody(25)) {
                    return;
                }
                if (DOOM.CM.equals(Settings.fix_medi_need, Boolean.FALSE)) {
                    player.message = player.health[0] < 25 ? "Picked up a medikit that you REALLY need!" : "Picked up a medikit.";
                    break;
                }
                player.message = need ? "Picked up a medikit that you REALLY need!" : "Picked up a medikit.";
                break;
            }
            case SPR_PINV: {
                if (!player.GivePower(0)) {
                    return;
                }
                player.message = "Invulnerability!";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_PSTR: {
                if (!player.GivePower(1)) {
                    return;
                }
                player.message = "Berserk!";
                if (player.readyweapon != weapontype_t.wp_fist) {
                    player.pendingweapon = weapontype_t.wp_fist;
                }
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_PINS: {
                if (!player.GivePower(2)) {
                    return;
                }
                player.message = "Partial Invisibility";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_SUIT: {
                if (!player.GivePower(3)) {
                    return;
                }
                player.message = "Radiation Shielding Suit";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_PMAP: {
                if (!player.GivePower(4)) {
                    return;
                }
                player.message = "Computer Area Map";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_PVIS: {
                if (!player.GivePower(5)) {
                    return;
                }
                player.message = "Light Amplification Visor";
                sound = sounds.sfxenum_t.sfx_getpow;
                break;
            }
            case SPR_CLIP: {
                if ((special.flags & 0x20000L) != 0L ? !player.GiveAmmo(ammotype_t.am_clip, 0) : !player.GiveAmmo(ammotype_t.am_clip, 1)) {
                    return;
                }
                player.message = "Picked up a clip.";
                break;
            }
            case SPR_AMMO: {
                if (!player.GiveAmmo(ammotype_t.am_clip, 5)) {
                    return;
                }
                player.message = "Picked up a box of bullets.";
                break;
            }
            case SPR_ROCK: {
                if (!player.GiveAmmo(ammotype_t.am_misl, 1)) {
                    return;
                }
                player.message = "Picked up a rocket.";
                break;
            }
            case SPR_BROK: {
                if (!player.GiveAmmo(ammotype_t.am_misl, 5)) {
                    return;
                }
                player.message = "Picked up a box of rockets.";
                break;
            }
            case SPR_CELL: {
                if (!player.GiveAmmo(ammotype_t.am_cell, 1)) {
                    return;
                }
                player.message = "Picked up an energy cell.";
                break;
            }
            case SPR_CELP: {
                if (!player.GiveAmmo(ammotype_t.am_cell, 5)) {
                    return;
                }
                player.message = "Picked up an energy cell pack.";
                break;
            }
            case SPR_SHEL: {
                if (!player.GiveAmmo(ammotype_t.am_shell, 1)) {
                    return;
                }
                player.message = "Picked up 4 shotgun shells.";
                break;
            }
            case SPR_SBOX: {
                if (!player.GiveAmmo(ammotype_t.am_shell, 5)) {
                    return;
                }
                player.message = "Picked up a box of shotgun shells.";
                break;
            }
            case SPR_BPAK: {
                int i;
                if (!player.backpack) {
                    i = 0;
                    while (i < Defines.NUMAMMO) {
                        int n = i++;
                        player.maxammo[n] = player.maxammo[n] * 2;
                    }
                    player.backpack = true;
                }
                for (i = 0; i < Defines.NUMAMMO; ++i) {
                    player.GiveAmmo(ammotype_t.values()[i], 1);
                }
                player.message = "Picked up a backpack full of ammo!";
                break;
            }
            case SPR_BFUG: {
                if (!player.GiveWeapon(weapontype_t.wp_bfg, false)) {
                    return;
                }
                player.message = "You got the BFG9000!  Oh, yes.";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_MGUN: {
                if (!player.GiveWeapon(weapontype_t.wp_chaingun, (special.flags & 0x20000L) != 0L)) {
                    return;
                }
                player.message = "You got the chaingun!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_CSAW: {
                if (!player.GiveWeapon(weapontype_t.wp_chainsaw, false)) {
                    return;
                }
                player.message = "A chainsaw!  Find some meat!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_LAUN: {
                if (!player.GiveWeapon(weapontype_t.wp_missile, false)) {
                    return;
                }
                player.message = "You got the rocket launcher!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_PLAS: {
                if (!player.GiveWeapon(weapontype_t.wp_plasma, false)) {
                    return;
                }
                player.message = "You got the plasma gun!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_SHOT: {
                if (!player.GiveWeapon(weapontype_t.wp_shotgun, (special.flags & 0x20000L) != 0L)) {
                    return;
                }
                player.message = "You got the shotgun!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            case SPR_SGN2: {
                if (!player.GiveWeapon(weapontype_t.wp_supershotgun, (special.flags & 0x20000L) != 0L)) {
                    return;
                }
                player.message = "You got the super shotgun!";
                sound = sounds.sfxenum_t.sfx_wpnup;
                break;
            }
            default: {
                DOOM.doomSystem.Error("P_SpecialThing: Unknown gettable thing");
            }
        }
        if ((special.flags & 0x800000L) != 0L) {
            ++player.itemcount;
        }
        this.RemoveMobj(special);
        player.bonuscount += 6;
        if (player == DOOM.players[DOOM.consoleplayer]) {
            DOOM.doomSound.StartSound(null, sound);
        }
    }

    @Override
    default public boolean StompThing(mobj_t thing) {
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if ((thing.flags & 4L) == 0L) {
            return true;
        }
        int blockdist = thing.radius + mov.tmthing.radius;
        if (Math.abs(thing.x - mov.tmx) >= blockdist || Math.abs(thing.y - mov.tmy) >= blockdist) {
            return true;
        }
        if (thing == mov.tmthing) {
            return true;
        }
        if (mov.tmthing.player == null && this.MapNumber() != 30) {
            return false;
        }
        this.DamageMobj(thing, mov.tmthing, mov.tmthing, 10000);
        return true;
    }
}

