/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.info;
import data.mapthing_t;
import data.mobjtype_t;
import data.sounds;
import doom.CommandVariable;
import doom.DoomMain;
import doom.thinker_t;
import p.AbstractLevelLoader;
import p.Actions.ActionsSectors;
import p.ActiveStates;
import p.ThinkerList;
import p.UnifiedGameMap;
import p.mobj_t;
import rr.sector_t;
import rr.subsector_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsThinkers
extends ActionsSectors,
ThinkerList {
    @Override
    default public void RemoveThinker(thinker_t thinker) {
        thinker.thinkerFunction = ActiveStates.NOP;
    }

    default public void SpawnSpecials() {
        int i2;
        DoomMain<?, ?> D = this.DOOM();
        AbstractLevelLoader ll = this.levelLoader();
        UnifiedGameMap.Specials sp = this.getSpecials();
        sp.levelTimer = false;
        if (D.cVarManager.bool(CommandVariable.AVG) && this.IsDeathMatch()) {
            sp.levelTimer = true;
            sp.levelTimeCount = 42000;
        }
        if (this.IsDeathMatch()) {
            D.cVarManager.with(CommandVariable.TIMER, 0, i -> {
                sp.levelTimer = true;
                sp.levelTimeCount = i * 60 * 35;
            });
        }
        block16: for (i2 = 0; i2 < ll.numsectors; ++i2) {
            sector_t sector = ll.sectors[i2];
            if (!C2JUtils.eval(sector.special)) continue;
            switch (sector.special) {
                case 1: {
                    this.SpawnLightFlash(sector);
                    continue block16;
                }
                case 2: {
                    this.SpawnStrobeFlash(sector, 15, 0);
                    continue block16;
                }
                case 3: {
                    this.SpawnStrobeFlash(sector, 35, 0);
                    continue block16;
                }
                case 4: {
                    this.SpawnStrobeFlash(sector, 15, 0);
                    sector.special = (short)4;
                    continue block16;
                }
                case 8: {
                    this.SpawnGlowingLight(sector);
                    continue block16;
                }
                case 9: {
                    ++D.totalsecret;
                    continue block16;
                }
                case 10: {
                    this.SpawnDoorCloseIn30(sector);
                    continue block16;
                }
                case 12: {
                    this.SpawnStrobeFlash(sector, 35, 1);
                    continue block16;
                }
                case 13: {
                    this.SpawnStrobeFlash(sector, 15, 1);
                    continue block16;
                }
                case 14: {
                    this.SpawnDoorRaiseIn5Mins(sector, i2);
                    continue block16;
                }
                case 17: {
                    this.SpawnFireFlicker(sector);
                }
            }
        }
        sp.numlinespecials = 0;
        for (i2 = 0; i2 < ll.numlines; ++i2) {
            switch (ll.lines[i2].special) {
                case 48: {
                    if (sp.numlinespecials == sp.linespeciallist.length) {
                        sp.resizeLinesSpecialList();
                    }
                    sp.linespeciallist[sp.numlinespecials] = ll.lines[i2];
                    sp.numlinespecials = (short)(sp.numlinespecials + 1);
                }
            }
        }
        for (i2 = 0; i2 < this.getMaxCeilings(); ++i2) {
            this.getActiveCeilings()[i2] = null;
        }
        this.getSwitches().initButtonList();
    }

    default public void RespawnSpecials() {
        int i;
        ActionsSectors.RespawnQueue resp = (ActionsSectors.RespawnQueue)this.contextRequire(KEY_RESP_QUEUE);
        if (!this.DOOM().altdeath) {
            return;
        }
        if (resp.iquehead == resp.iquetail) {
            return;
        }
        if (this.LevelTime() - resp.itemrespawntime[resp.iquetail] < 1050) {
            return;
        }
        mapthing_t mthing = resp.itemrespawnque[resp.iquetail];
        int x = mthing.x << 16;
        int y = mthing.y << 16;
        subsector_t ss = this.levelLoader().PointInSubsector(x, y);
        mobj_t mo = this.SpawnMobj(x, y, ss.sector.floorheight, mobjtype_t.MT_IFOG);
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_itmbk);
        for (i = 0; i < mobjtype_t.NUMMOBJTYPES.ordinal() && mthing.type != info.mobjinfo[i].doomednum; ++i) {
        }
        int z = C2JUtils.eval(info.mobjinfo[i].flags & 0x100L) ? Defines.ONCEILINGZ : Defines.ONFLOORZ;
        mo = this.SpawnMobj(x, y, z, mobjtype_t.values()[i]);
        mo.spawnpoint = mthing;
        mo.angle = 0x20000000L * (long)(mthing.angle / 45);
        resp.iquetail = resp.iquetail + 1 & Defines.ITEMQUESIZE - 1;
    }

    default public void RunThinkers() {
        thinker_t thinker = this.getThinkerCap().next;
        while (thinker != this.getThinkerCap()) {
            if (thinker.thinkerFunction == ActiveStates.NOP) {
                thinker.next.prev = thinker.prev;
                thinker.prev.next = thinker.next;
            } else if (thinker.thinkerFunction.isParamType(ActiveStates.MobjConsumer.class)) {
                thinker.thinkerFunction.fun(ActiveStates.MobjConsumer.class).accept(this.DOOM().actions, (mobj_t)thinker);
            } else if (thinker.thinkerFunction.isParamType(ActiveStates.ThinkerConsumer.class)) {
                thinker.thinkerFunction.fun(ActiveStates.ThinkerConsumer.class).accept(this.DOOM().actions, thinker);
            }
            thinker = thinker.next;
        }
    }

    default public void Ticker() {
        if (this.IsPaused()) {
            return;
        }
        if (!this.IsNetGame() && this.IsMenuActive() && !this.IsDemoPlayback() && this.getPlayer((int)this.ConsolePlayerNumber()).viewz != 1) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.PlayerInGame(i)) continue;
            this.getPlayer(i).PlayerThink();
        }
        this.RunThinkers();
        this.getSpecials().UpdateSpecials();
        this.RespawnSpecials();
        ++this.DOOM().leveltime;
    }
}

