/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates.MonsterStates;

import data.mobjtype_t;
import data.sounds;
import defines.skill_t;
import defines.statenum_t;
import doom.thinker_t;
import p.Actions.ActiveStates.Sounds;
import p.ActiveStates;
import p.mobj_t;
import s.ISoundOrigin;
import utils.TraitFactory;

public interface HorrendousVisages
extends Sounds {
    public static final TraitFactory.ContextKey<Brain> KEY_BRAIN = ACTION_KEY_CHAIN.newKey(HorrendousVisages.class, Brain::new);

    default public void A_BrainAwake(mobj_t mo) {
        Brain brain = this.contextRequire(KEY_BRAIN);
        brain.numbraintargets = 0;
        brain.braintargeton = 0;
        thinker_t thinker = this.getThinkerCap().next;
        while (thinker != this.getThinkerCap()) {
            if (thinker.thinkerFunction == ActiveStates.P_MobjThinker) {
                mobj_t m = (mobj_t)thinker;
                if (m.type == mobjtype_t.MT_BOSSTARGET) {
                    brain.braintargets[brain.numbraintargets] = m;
                    ++brain.numbraintargets;
                }
            }
            thinker = thinker.next;
        }
        this.StartSound(null, sounds.sfxenum_t.sfx_bossit);
    }

    default public void A_BrainScream(mobj_t mo) {
        for (int x = mo.x - 0xC40000; x < mo.x + 0x1400000; x += 524288) {
            int y = mo.y - 0x1400000;
            int z = 128 + this.P_Random() * 2 * 65536;
            mobj_t th = this.getEnemies().SpawnMobj(x, y, z, mobjtype_t.MT_ROCKET);
            th.momz = this.P_Random() * 512;
            th.SetMobjState(statenum_t.S_BRAINEXPLODE1);
            th.mobj_tics -= (long)(this.P_Random() & 7);
            if (th.mobj_tics >= 1L) continue;
            th.mobj_tics = 1L;
        }
        this.StartSound(null, sounds.sfxenum_t.sfx_bosdth);
    }

    default public void A_BrainExplode(mobj_t mo) {
        int x = mo.x + (this.P_Random() - this.P_Random()) * 2048;
        int y = mo.y;
        int z = 128 + this.P_Random() * 2 * 65536;
        mobj_t th = this.getEnemies().SpawnMobj(x, y, z, mobjtype_t.MT_ROCKET);
        th.momz = this.P_Random() * 512;
        th.SetMobjState(statenum_t.S_BRAINEXPLODE1);
        th.mobj_tics -= (long)(this.P_Random() & 7);
        if (th.mobj_tics < 1L) {
            th.mobj_tics = 1L;
        }
    }

    default public void A_BrainDie(mobj_t mo) {
        this.DOOM().ExitLevel();
    }

    default public void A_BrainSpit(mobj_t mo) {
        Brain brain = this.contextRequire(KEY_BRAIN);
        brain.easy ^= 1;
        if (this.getGameSkill().ordinal() <= skill_t.sk_easy.ordinal() && brain.easy == 0) {
            return;
        }
        mobj_t targ = brain.braintargets[brain.braintargeton];
        if (brain.numbraintargets == 0) {
            this.A_BrainAwake(mo);
            return;
        }
        brain.braintargeton = (brain.braintargeton + 1) % brain.numbraintargets;
        mobj_t newmobj = this.getAttacks().SpawnMissile(mo, targ, mobjtype_t.MT_SPAWNSHOT);
        newmobj.target = targ;
        newmobj.reactiontime = (targ.y - mo.y) / newmobj.momy / newmobj.mobj_state.tics;
        this.StartSound(null, sounds.sfxenum_t.sfx_bospit);
    }

    @Override
    default public void A_SpawnFly(mobj_t mo) {
        if (--mo.reactiontime != 0) {
            return;
        }
        mobj_t targ = mo.target;
        mobj_t fog = this.getEnemies().SpawnMobj(targ.x, targ.y, targ.z, mobjtype_t.MT_SPAWNFIRE);
        this.StartSound((ISoundOrigin)fog, sounds.sfxenum_t.sfx_telept);
        int r = this.P_Random();
        mobjtype_t type = r < 50 ? mobjtype_t.MT_TROOP : (r < 90 ? mobjtype_t.MT_SERGEANT : (r < 120 ? mobjtype_t.MT_SHADOWS : (r < 130 ? mobjtype_t.MT_PAIN : (r < 160 ? mobjtype_t.MT_HEAD : (r < 162 ? mobjtype_t.MT_VILE : (r < 172 ? mobjtype_t.MT_UNDEAD : (r < 192 ? mobjtype_t.MT_BABY : (r < 222 ? mobjtype_t.MT_FATSO : (r < 246 ? mobjtype_t.MT_KNIGHT : mobjtype_t.MT_BRUISER)))))))));
        mobj_t newmobj = this.getEnemies().SpawnMobj(targ.x, targ.y, targ.z, type);
        if (this.getEnemies().LookForPlayers(newmobj, true)) {
            newmobj.SetMobjState(newmobj.info.seestate);
        }
        this.getAttacks().TeleportMove(newmobj, newmobj.x, newmobj.y);
        this.getEnemies().RemoveMobj(mo);
    }

    public static final class Brain {
        mobj_t[] braintargets = new mobj_t[32];
        int numbraintargets;
        int braintargeton;
        int easy = 0;
    }
}

