/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates.MonsterStates;

import data.Tables;
import data.info;
import data.mobjtype_t;
import doom.thinker_t;
import m.fixed_t;
import p.Actions.ActionTrait;
import p.ActiveStates;
import p.MapUtils;
import p.mobj_t;
import s.ISoundOrigin;

public interface PainsSouls
extends ActionTrait {
    public static final int SKULLSPEED = 0x140000;

    public void A_FaceTarget(mobj_t var1);

    public void A_Fall(mobj_t var1);

    default public void A_SkullAttack(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        mobj_t dest = actor.target;
        actor.flags |= 0x1000000L;
        this.StartSound((ISoundOrigin)actor, actor.info.attacksound);
        this.A_FaceTarget(actor);
        int an = Tables.toBAMIndex(actor.angle);
        actor.momx = fixed_t.FixedMul(0x140000, Tables.finecosine[an]);
        actor.momy = fixed_t.FixedMul(0x140000, Tables.finesine[an]);
        int dist = MapUtils.AproxDistance(dest.x - actor.x, dest.y - actor.y);
        if ((dist /= 0x140000) < 1) {
            dist = 1;
        }
        actor.momz = (dest.z + (dest.height >> 1) - actor.z) / dist;
    }

    default public void A_PainShootSkull(mobj_t actor, Long angle) {
        int count = 0;
        thinker_t currentthinker = this.getThinkerCap().next;
        while (currentthinker != this.getThinkerCap()) {
            if (currentthinker.thinkerFunction == ActiveStates.P_MobjThinker && ((mobj_t)currentthinker).type == mobjtype_t.MT_SKULL) {
                ++count;
            }
            currentthinker = currentthinker.next;
        }
        if (count > 20) {
            return;
        }
        int an = Tables.toBAMIndex(angle);
        int prestep = 262144 + 3 * (actor.info.radius + info.mobjinfo[mobjtype_t.MT_SKULL.ordinal()].radius) / 2;
        int x = actor.x + fixed_t.FixedMul(prestep, Tables.finecosine[an]);
        int y = actor.y + fixed_t.FixedMul(prestep, Tables.finesine[an]);
        int z = actor.z + 524288;
        mobj_t newmobj = this.getAttacks().SpawnMobj(x, y, z, mobjtype_t.MT_SKULL);
        if (!this.getAttacks().TryMove(newmobj, newmobj.x, newmobj.y)) {
            this.getAttacks().DamageMobj(newmobj, actor, actor, 10000);
            return;
        }
        newmobj.target = actor.target;
        this.A_SkullAttack(newmobj);
    }

    default public void A_PainAttack(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        this.A_PainShootSkull(actor, actor.angle);
    }

    default public void A_PainDie(mobj_t actor) {
        this.A_Fall(actor);
        this.A_PainShootSkull(actor, actor.angle + 0x40000000L);
        this.A_PainShootSkull(actor, actor.angle + 0x80000000L);
        this.A_PainShootSkull(actor, actor.angle + 0xC0000000L);
    }
}

