/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates.MonsterStates;

import data.Tables;
import data.mobjtype_t;
import data.sounds;
import m.fixed_t;
import p.Actions.ActionTrait;
import p.MapUtils;
import p.mobj_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface Skels
extends ActionTrait {
    public static final int TRACEANGLE = 0xC000000;

    default public void A_SkelMissile(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        actor.z += 0x100000;
        mobj_t mo = this.getAttacks().SpawnMissile(actor, actor.target, mobjtype_t.MT_TRACER);
        actor.z -= 0x100000;
        mo.x += mo.momx;
        mo.y += mo.momy;
        mo.tracer = actor.target;
    }

    default public void A_SkelWhoosh(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_skeswg);
    }

    default public void A_SkelFist(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        if (this.getEnemies().CheckMeleeRange(actor)) {
            int damage = (this.P_Random() % 10 + 1) * 6;
            this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_skepch);
            this.getAttacks().DamageMobj(actor.target, actor, actor, damage);
        }
    }

    default public void A_Tracer(mobj_t actor) {
        int slope;
        mobj_t dest;
        if (C2JUtils.eval(this.DOOM().gametic & 3)) {
            return;
        }
        this.getAttacks().SpawnPuff(actor.x, actor.y, actor.z);
        mobj_t th = this.getEnemies().SpawnMobj(actor.x - actor.momx, actor.y - actor.momy, actor.z, mobjtype_t.MT_SMOKE);
        th.momz = 65536;
        th.mobj_tics -= (long)(this.P_Random() & 3);
        if (th.mobj_tics < 1L) {
            th.mobj_tics = 1L;
        }
        if ((dest = actor.tracer) == null || dest.health <= 0) {
            return;
        }
        long exact = this.sceneRenderer().PointToAngle2(actor.x, actor.y, dest.x, dest.y) & 0xFFFFFFFFL;
        if (exact != actor.angle) {
            if (exact - actor.angle > 0x80000000L) {
                actor.angle -= 0xC000000L;
                actor.angle &= 0xFFFFFFFFL;
                if ((exact - actor.angle & 0xFFFFFFFFL) < 0x80000000L) {
                    actor.angle = exact;
                }
            } else {
                actor.angle += 0xC000000L;
                actor.angle &= 0xFFFFFFFFL;
                if ((exact - actor.angle & 0xFFFFFFFFL) > 0x80000000L) {
                    actor.angle = exact;
                }
            }
        }
        int exact2 = Tables.toBAMIndex(actor.angle);
        actor.momx = fixed_t.FixedMul(actor.info.speed, Tables.finecosine[exact2]);
        actor.momy = fixed_t.FixedMul(actor.info.speed, Tables.finesine[exact2]);
        int dist = MapUtils.AproxDistance(dest.x - actor.x, dest.y - actor.y);
        if ((dist /= actor.info.speed) < 1) {
            dist = 1;
        }
        actor.momz = (slope = (dest.z + 0x280000 - actor.z) / dist) < actor.momz ? (actor.momz -= 8192) : (actor.momz += 8192);
    }

    public void A_FaceTarget(mobj_t var1);
}

