/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates;

import data.Tables;
import data.info;
import data.sounds;
import defines.statenum_t;
import doom.items;
import doom.player_t;
import doom.weapontype_t;
import m.fixed_t;
import p.Actions.ActiveStates.Sounds;
import p.pspdef_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface Weapons
extends Sounds {
    default public void A_WeaponReady(player_t player, pspdef_t psp) {
        if (player.mo.mobj_state == info.states[statenum_t.S_PLAY_ATK1.ordinal()] || player.mo.mobj_state == info.states[statenum_t.S_PLAY_ATK2.ordinal()]) {
            player.mo.SetMobjState(statenum_t.S_PLAY);
        }
        if (player.readyweapon == weapontype_t.wp_chainsaw && psp.state == info.states[statenum_t.S_SAW.ordinal()]) {
            this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_sawidl);
        }
        if (player.pendingweapon != weapontype_t.wp_nochange || !C2JUtils.eval(player.health[0])) {
            statenum_t newstate = items.weaponinfo[player.readyweapon.ordinal()].downstate;
            player.SetPsprite(player_t.ps_weapon, newstate);
            return;
        }
        if (C2JUtils.eval(player.cmd.buttons & '\u0001')) {
            if (!player.attackdown || player.readyweapon != weapontype_t.wp_missile && player.readyweapon != weapontype_t.wp_bfg) {
                player.attackdown = true;
                this.getEnemies().FireWeapon(player);
                return;
            }
        } else {
            player.attackdown = false;
        }
        int angle = 128 * this.LevelTime() & 0x1FFF;
        psp.sx = 65536 + fixed_t.FixedMul(player.bob, Tables.finecosine[angle]);
        psp.sy = player_t.WEAPONTOP + fixed_t.FixedMul(player.bob, Tables.finesine[angle &= 0xFFF]);
    }

    default public void A_Raise(player_t player, pspdef_t psp) {
        psp.sy -= player_t.RAISESPEED;
        if (psp.sy > player_t.WEAPONTOP) {
            return;
        }
        psp.sy = player_t.WEAPONTOP;
        statenum_t newstate = items.weaponinfo[player.readyweapon.ordinal()].readystate;
        player.SetPsprite(player_t.ps_weapon, newstate);
    }

    @Override
    default public void A_ReFire(player_t player, pspdef_t psp) {
        if (C2JUtils.eval(player.cmd.buttons & '\u0001') && player.pendingweapon == weapontype_t.wp_nochange && C2JUtils.eval(player.health[0])) {
            ++player.refire;
            this.getEnemies().FireWeapon(player);
        } else {
            player.refire = 0;
            player.CheckAmmo();
        }
    }

    default public void A_GunFlash(player_t player, pspdef_t psp) {
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK2);
        player.SetPsprite(player_t.ps_flash, items.weaponinfo[player.readyweapon.ordinal()].flashstate);
    }

    default public void A_Light0(player_t player, pspdef_t psp) {
        player.extralight = 0;
    }

    default public void A_Light1(player_t player, pspdef_t psp) {
        player.extralight = 1;
    }

    default public void A_Light2(player_t player, pspdef_t psp) {
        player.extralight = 2;
    }

    default public void A_Lower(player_t player, pspdef_t psp) {
        psp.sy += player_t.LOWERSPEED;
        if (psp.sy < player_t.WEAPONBOTTOM) {
            return;
        }
        if (player.playerstate == 1) {
            psp.sy = player_t.WEAPONBOTTOM;
            return;
        }
        if (!C2JUtils.eval(player.health[0])) {
            player.SetPsprite(player_t.ps_weapon, statenum_t.S_NULL);
            return;
        }
        player.readyweapon = player.pendingweapon;
        player.BringUpWeapon();
    }

    default public void A_CheckReload(player_t player, pspdef_t psp) {
        player.CheckAmmo();
    }
}

