/*
 * Decompiled with CFR 0.152.
 */
package p;

import boom.DeepBSPNodesV4;
import boom.mapglvertex_t;
import boom.mapnode_v4_t;
import boom.mapnode_znod_t;
import boom.mapseg_v4_t;
import boom.mapseg_znod_t;
import boom.mapsubsector_v4_t;
import boom.mapsubsector_znod_t;
import data.maplinedef_t;
import data.mapnode_t;
import data.mapsector_t;
import data.mapseg_t;
import data.mapsidedef_t;
import data.mapsubsector_t;
import data.mapthing_t;
import data.mapvertex_t;
import defines.skill_t;
import defines.slopetype_t;
import doom.CommandVariable;
import doom.DoomMain;
import doom.DoomStatus;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.function.IntFunction;
import m.BBox;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.Resettable;
import p.mobj_t;
import rr.RendererState;
import rr.line_t;
import rr.node_t;
import rr.sector_t;
import rr.seg_t;
import rr.side_t;
import rr.subsector_t;
import rr.vertex_t;
import rr.z_vertex_t;
import s.degenmobj_t;
import utils.C2JUtils;
import utils.GenericCopy;
import w.CacheableDoomObject;
import w.CacheableDoomObjectContainer;
import w.DoomBuffer;
import w.wadfile_info_t;

public class BoomLevelLoader
extends AbstractLevelLoader {
    byte[] map_subsectors;
    public static final int gNd2 = 845434471;
    public static final int gNd3 = 862211687;
    public static final int gNd4 = 878988903;
    public static final int gNd5 = 895766119;
    public static final int ZNOD = 1146048090;
    public static final int ZGLN = 1313621850;
    public static final int GL_VERT_OFFSET = 4;
    int firstglvertex = 0;
    int nodesVersion = 0;
    boolean forceOldBsp = false;
    public static final int ML_GL_LABEL = 0;
    public static final int ML_GL_VERTS = 1;
    public static final int ML_GL_SEGS = 2;
    public static final int ML_GL_SSECT = 3;
    public static final int ML_GL_NODES = 4;
    private int rejectlump = -1;
    private int current_episode = -1;
    private int current_map = -1;
    private int current_nodesVersion = -1;
    private boolean samelevel = false;
    private static final int XNOD = 1481527108;
    private boolean no_overlapped_sprites;
    private static final String[] ml_labels = new String[]{"ML_LABEL", "ML_THINGS", "ML_LINEDEFS", "ML_SIDEDEFS", "ML_VERTEXES", "ML_SEGS", "ML_SSECTORS", "ML_NODES", "ML_SECTORS", "ML_REJECT", "ML_BLOCKMAP"};
    private static final boolean GL_DOOM = false;

    public BoomLevelLoader(DoomMain<?, ?> DM) {
        super(DM);
    }

    private <T> T[] malloc_IfSameLevel(T[] p, int numstuff, GenericCopy.ArraySupplier<T> supplier, IntFunction<T[]> generator) {
        if (!this.samelevel || p == null) {
            return GenericCopy.malloc(supplier, generator, numstuff);
        }
        return p;
    }

    private <T extends Resettable> T[] calloc_IfSameLevel(T[] p, int numstuff, GenericCopy.ArraySupplier<T> supplier, IntFunction<T[]> generator) {
        if (!this.samelevel) {
            return (Resettable[])GenericCopy.malloc(supplier, generator, numstuff);
        }
        C2JUtils.resetAll(p);
        return p;
    }

    private boolean P_CheckForZDoomNodes(int lumpnum, int gl_lumpnum) {
        byte[] data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lumpnum + 7, 0);
        int check = ByteBuffer.wrap(data).getInt();
        if (check == 1146048090) {
            this.DOOM.doomSystem.Error("P_CheckForZDoomNodes: ZDoom nodes not supported yet");
        }
        if ((check = ByteBuffer.wrap(data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lumpnum + 6, 0)).getInt()) == 1313621850) {
            this.DOOM.doomSystem.Error("P_CheckForZDoomNodes: ZDoom GL nodes not supported yet");
        }
        this.DOOM.wadLoader.UnlockLumpNum(lumpnum + 7);
        this.DOOM.wadLoader.UnlockLumpNum(lumpnum + 6);
        return false;
    }

    private boolean P_CheckForDeePBSPv4Nodes(int lumpnum, int gl_lumpnum) {
        boolean result = false;
        byte[] data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lumpnum + 7, 0);
        byte[] compare = Arrays.copyOfRange(data, 0, 7);
        if (Arrays.equals(compare, DeepBSPNodesV4.DeepBSPHeader)) {
            System.out.println("P_CheckForDeePBSPv4Nodes: DeePBSP v4 Extended nodes are detected\n");
            result = true;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lumpnum + 7);
        return result;
    }

    private boolean P_CheckForZDoomUncompressedNodes(int lumpnum, int gl_lumpnum) {
        boolean result = false;
        byte[] data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lumpnum + 7, 0);
        int wrapper = ByteBuffer.wrap(data).getInt();
        if (wrapper == 1481527108) {
            System.out.println("P_CheckForZDoomUncompressedNodes: ZDoom uncompressed normal nodes are detected\n");
            result = true;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lumpnum + 7);
        return result;
    }

    public void P_GetNodesVersion(int lumpnum, int gl_lumpnum) {
        int ver = -1;
        this.nodesVersion = 0;
        if (gl_lumpnum > lumpnum && !this.forceOldBsp && DoomStatus.compatibility_level >= 13) {
            byte[] data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(gl_lumpnum + 1, 0);
            int wrapper = ByteBuffer.wrap(data).getInt();
            if (wrapper == 845434471) {
                data = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(gl_lumpnum + 2, 0);
                wrapper = ByteBuffer.wrap(data).getInt();
                if (wrapper == 862211687) {
                    ver = 3;
                } else {
                    this.nodesVersion = 845434471;
                    System.out.println("P_GetNodesVersion: found version 2 nodes\n");
                }
            }
            if (wrapper == 878988903) {
                ver = 4;
            }
            if (wrapper == 895766119) {
                ver = 5;
            }
            if (this.nodesVersion == 0 && ver != -1) {
                System.out.printf("P_GetNodesVersion: found version %d nodes\n", ver);
                System.out.printf("P_GetNodesVersion: version %d nodes not supported\n", ver);
            }
        } else {
            this.nodesVersion = 0;
            System.out.println("P_GetNodesVersion: using normal BSP nodes\n");
            if (this.P_CheckForZDoomNodes(lumpnum, gl_lumpnum)) {
                this.DOOM.doomSystem.Error("P_GetNodesVersion: ZDoom nodes not supported yet");
            }
        }
    }

    private void P_LoadVertexes(int lump) {
        this.numvertexes = this.DOOM.wadLoader.LumpLength(lump) / mapvertex_t.sizeOf();
        this.vertexes = (vertex_t[])this.calloc_IfSameLevel(this.vertexes, this.numvertexes, vertex_t::new, vertex_t[]::new);
        mapvertex_t[] data = (mapvertex_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numvertexes, mapvertex_t::new, mapvertex_t[]::new);
        for (int i = 0; i < this.numvertexes; ++i) {
            this.vertexes[i].x = data[i].x << 16;
            this.vertexes[i].y = data[i].y << 16;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadVertexes2(int lump, int gllump) throws IOException {
        CacheableDoomObject[] ml;
        this.firstglvertex = this.DOOM.wadLoader.LumpLength(lump) / mapvertex_t.sizeOf();
        this.numvertexes = this.DOOM.wadLoader.LumpLength(lump) / mapvertex_t.sizeOf();
        if (gllump >= 0) {
            ByteBuffer gldata = this.DOOM.wadLoader.CacheLumpNumAsDoomBuffer(gllump).getBuffer();
            if (this.nodesVersion == 845434471) {
                this.numvertexes += (this.DOOM.wadLoader.LumpLength(gllump) - 4) / mapglvertex_t.sizeOf();
                this.vertexes = this.malloc_IfSameLevel(this.vertexes, this.numvertexes, vertex_t::new, vertex_t[]::new);
                CacheableDoomObject[] mgl = (mapglvertex_t[])GenericCopy.malloc(mapglvertex_t::new, mapglvertex_t[]::new, this.numvertexes - this.firstglvertex);
                gldata.rewind();
                gldata.position(4);
                CacheableDoomObjectContainer.unpack(gldata, mgl);
                int mgl_count = 0;
                for (int i = this.firstglvertex; i < this.numvertexes; ++i) {
                    this.vertexes[i].x = ((mapglvertex_t)mgl[mgl_count]).x;
                    this.vertexes[i].y = ((mapglvertex_t)mgl[mgl_count]).y;
                    ++mgl_count;
                }
            } else {
                this.numvertexes += this.DOOM.wadLoader.LumpLength(gllump) / mapvertex_t.sizeOf();
                this.vertexes = this.malloc_IfSameLevel(this.vertexes, this.numvertexes, vertex_t::new, vertex_t[]::new);
                ml = (mapvertex_t[])GenericCopy.malloc(mapvertex_t::new, mapvertex_t[]::new, this.numvertexes - this.firstglvertex);
                gldata.rewind();
                CacheableDoomObjectContainer.unpack(gldata, ml);
                int ml_count = 0;
                for (int i = this.firstglvertex; i < this.numvertexes; ++i) {
                    this.vertexes[i].x = ((mapvertex_t)ml[ml_count]).x;
                    this.vertexes[i].y = ((mapvertex_t)ml[ml_count]).y;
                    ++ml_count;
                }
            }
            this.DOOM.wadLoader.UnlockLumpNum(gllump);
        }
        ml = (mapvertex_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.firstglvertex, mapvertex_t::new, mapvertex_t[]::new);
        for (int i = 0; i < this.firstglvertex; ++i) {
            this.vertexes[i].x = ml[i].x;
            this.vertexes[i].y = ml[i].y;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    public int checkGLVertex(int num) {
        if ((num & 0x8000) != 0) {
            num = (num & Short.MAX_VALUE) + this.firstglvertex;
        }
        return num;
    }

    public static float GetDistance(int dx, int dy) {
        float fx = (float)dx / 65536.0f;
        float fy = (float)dy / 65536.0f;
        return (float)Math.sqrt(fx * fx + fy * fy);
    }

    public static float GetTexelDistance(int dx, int dy) {
        float fx = (float)dx / 65536.0f;
        float fy = (float)dy / 65536.0f;
        return (int)(0.5f + (float)Math.sqrt(fx * fx + fy * fy));
    }

    public static int GetOffset(vertex_t v1, vertex_t v2) {
        float a = (float)(v1.x - v2.x) / 65536.0f;
        float b = (float)(v1.y - v2.y) / 65536.0f;
        int r = (int)(Math.sqrt(a * a + b * b) * 65536.0);
        return r;
    }

    private void P_LoadSegs(int lump) {
        this.numsegs = this.DOOM.wadLoader.LumpLength(lump) / mapseg_t.sizeOf();
        this.segs = (seg_t[])this.calloc_IfSameLevel(this.segs, this.numsegs, seg_t::new, seg_t[]::new);
        mapseg_t[] data = (mapseg_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsegs, mapseg_t::new, mapseg_t[]::new);
        if (data == null || this.numsegs == 0) {
            this.DOOM.doomSystem.Error("P_LoadSegs: no segs in level");
        }
        for (int i = 0; i < this.numsegs; ++i) {
            line_t ldef;
            seg_t li = this.segs[i];
            mapseg_t ml = data[i];
            li.iSegID = i;
            char v1 = ml.v1;
            char v2 = ml.v2;
            li.miniseg = false;
            li.angle = ml.angle << 16;
            li.offset = ml.offset << 16;
            char linedef = ml.linedef;
            if (linedef >= this.numlines) {
                this.DOOM.doomSystem.Error("P_LoadSegs: seg %d references a non-existent linedef %d", i, linedef);
            }
            li.linedef = ldef = this.lines[linedef];
            char side = ml.side;
            if (side != '\u0000' && side != '\u0001') {
                System.err.printf("P_LoadSegs: seg %d contains wrong side index %d. Replaced with 1.\n", i, (int)side);
                side = '\u0001';
            }
            if (ldef.sidenum[side] >= (char)this.numsides) {
                this.DOOM.doomSystem.Error("P_LoadSegs: linedef %d for seg %d references a non-existent sidedef %d", linedef, i, Character.valueOf(ldef.sidenum[side]));
            }
            li.sidedef = this.sides[ldef.sidenum[side]];
            if (ldef.sidenum[side] != '\uffff') {
                li.frontsector = this.sides[ldef.sidenum[side]].sector;
            } else {
                li.frontsector = null;
                System.err.printf("P_LoadSegs: front of seg %i has no sidedef\n", i);
            }
            li.backsector = C2JUtils.flags(ldef.flags, 4) && ldef.sidenum[side ^ '\u0001'] != '\uffff' ? this.sides[ldef.sidenum[side ^ '\u0001']].sector : null;
            if (v1 >= this.numvertexes || v2 >= this.numvertexes) {
                String str = "P_LoadSegs: compatibility loss - seg %d references a non-existent vertex %d\n";
                if (this.DOOM.demorecording) {
                    this.DOOM.doomSystem.Error(str + "Demo recording on levels with invalid nodes is not allowed", i, Character.valueOf(v1 >= this.numvertexes ? v1 : v2));
                }
                if (v1 >= this.numvertexes) {
                    System.err.printf(str, i, Character.valueOf(v1));
                }
                if (v2 >= this.numvertexes) {
                    System.err.printf(str, i, Character.valueOf(v2));
                }
                if (li.sidedef == this.sides[li.linedef.sidenum[0]]) {
                    li.v1 = this.lines[ml.linedef].v1;
                    li.v2 = this.lines[ml.linedef].v2;
                } else {
                    li.v1 = this.lines[ml.linedef].v2;
                    li.v2 = this.lines[ml.linedef].v1;
                }
            } else {
                li.v1 = this.vertexes[v1];
                li.v2 = this.vertexes[v2];
            }
            li.assignVertexValues();
            li.length = BoomLevelLoader.GetDistance(li.v2x - li.v1x, li.v2y - li.v1y);
            li.offset = BoomLevelLoader.GetOffset(li.v1, ml.side != '\u0000' ? ldef.v2 : ldef.v1);
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadSegs_V4(int lump) {
        this.numsegs = this.DOOM.wadLoader.LumpLength(lump) / mapseg_v4_t.sizeOf();
        this.segs = (seg_t[])this.calloc_IfSameLevel(this.segs, this.numsegs, seg_t::new, seg_t[]::new);
        mapseg_v4_t[] data = (mapseg_v4_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsegs, mapseg_v4_t::new, mapseg_v4_t[]::new);
        if (data == null || this.numsegs == 0) {
            this.DOOM.doomSystem.Error("P_LoadSegs_V4: no segs in level");
        }
        for (int i = 0; i < this.numsegs; ++i) {
            line_t ldef;
            seg_t li = this.segs[i];
            mapseg_v4_t ml = data[i];
            li.iSegID = i;
            int v1 = ml.v1;
            int v2 = ml.v2;
            li.miniseg = false;
            li.angle = ml.angle << 16;
            li.offset = ml.offset << 16;
            char linedef = ml.linedef;
            if (C2JUtils.unsigned(linedef) >= C2JUtils.unsigned(this.numlines)) {
                this.DOOM.doomSystem.Error("P_LoadSegs_V4: seg %d references a non-existent linedef %d", i, C2JUtils.unsigned(linedef));
            }
            li.linedef = ldef = this.lines[linedef];
            char side = ml.side;
            if (side != '\u0000' && side != '\u0001') {
                System.err.printf("P_LoadSegs_V4: seg %d contains wrong side index %d. Replaced with 1.\n", i, (int)side);
                side = '\u0001';
            }
            if (C2JUtils.unsigned(ldef.sidenum[side]) >= C2JUtils.unsigned(this.numsides)) {
                this.DOOM.doomSystem.Error("P_LoadSegs_V4: linedef %d for seg %d references a non-existent sidedef %d", linedef, i, C2JUtils.unsigned(ldef.sidenum[side]));
            }
            li.sidedef = this.sides[ldef.sidenum[side]];
            if (ldef.sidenum[side] != '\uffff') {
                li.frontsector = this.sides[ldef.sidenum[side]].sector;
            } else {
                li.frontsector = null;
                System.err.printf("P_LoadSegs_V4: front of seg %i has no sidedef\n", i);
            }
            li.backsector = C2JUtils.flags(ldef.flags, 4) && ldef.sidenum[side ^ '\u0001'] != '\uffff' ? this.sides[ldef.sidenum[side ^ '\u0001']].sector : null;
            if (v1 >= this.numvertexes || v2 >= this.numvertexes) {
                String str = "P_LoadSegs_V4: compatibility loss - seg %d references a non-existent vertex %d\n";
                if (this.DOOM.demorecording) {
                    this.DOOM.doomSystem.Error(str + "Demo recording on levels with invalid nodes is not allowed", i, v1 >= this.numvertexes ? v1 : v2);
                }
                if (v1 >= this.numvertexes) {
                    System.err.printf(str, i, v1);
                }
                if (v2 >= this.numvertexes) {
                    System.err.printf(str, i, v2);
                }
                if (li.sidedef == this.sides[li.linedef.sidenum[0]]) {
                    li.v1 = this.lines[ml.linedef].v1;
                    li.v2 = this.lines[ml.linedef].v2;
                } else {
                    li.v1 = this.lines[ml.linedef].v2;
                    li.v2 = this.lines[ml.linedef].v1;
                }
            } else {
                li.v1 = this.vertexes[v1];
                li.v2 = this.vertexes[v2];
            }
            li.length = BoomLevelLoader.GetDistance(li.v2.x - li.v1.x, li.v2.y - li.v1.y);
            li.offset = BoomLevelLoader.GetOffset(li.v1, ml.side != '\u0000' ? ldef.v2 : ldef.v1);
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadSubsectors(int lump) {
        this.numsubsectors = this.DOOM.wadLoader.LumpLength(lump) / mapsubsector_t.sizeOf();
        this.subsectors = (subsector_t[])this.calloc_IfSameLevel(this.subsectors, this.numsubsectors, subsector_t::new, subsector_t[]::new);
        mapsubsector_t[] data = (mapsubsector_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsubsectors, mapsubsector_t::new, mapsubsector_t[]::new);
        if (data == null || this.numsubsectors == 0) {
            this.DOOM.doomSystem.Error("P_LoadSubsectors: no subsectors in level");
        }
        for (int i = 0; i < this.numsubsectors; ++i) {
            this.subsectors[i].numlines = data[i].numsegs;
            this.subsectors[i].firstline = data[i].firstseg;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadSubsectors_V4(int lump) {
        this.numsubsectors = this.DOOM.wadLoader.LumpLength(lump) / mapsubsector_v4_t.sizeOf();
        this.subsectors = (subsector_t[])this.calloc_IfSameLevel(this.subsectors, this.numsubsectors, subsector_t::new, subsector_t[]::new);
        mapsubsector_v4_t[] data = (mapsubsector_v4_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsubsectors, mapsubsector_v4_t::new, mapsubsector_v4_t[]::new);
        if (data == null || this.numsubsectors == 0) {
            this.DOOM.doomSystem.Error("P_LoadSubsectors_V4: no subsectors in level");
        }
        for (int i = 0; i < this.numsubsectors; ++i) {
            this.subsectors[i].numlines = data[i].numsegs;
            this.subsectors[i].firstline = data[i].firstseg;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadSectors(int lump) {
        this.numsectors = this.DOOM.wadLoader.LumpLength(lump) / mapsector_t.sizeOf();
        this.sectors = (sector_t[])this.calloc_IfSameLevel(this.sectors, this.numsectors, sector_t::new, sector_t[]::new);
        mapsector_t[] data = (mapsector_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsectors, mapsector_t::new, mapsector_t[]::new);
        int i = 0;
        while (i < this.numsectors) {
            sector_t ss = this.sectors[i];
            mapsector_t ms = data[i];
            ss.id = i++;
            ss.floorheight = ms.floorheight << 16;
            ss.ceilingheight = ms.ceilingheight << 16;
            ss.floorpic = (short)this.DOOM.textureManager.FlatNumForName(ms.floorpic);
            ss.ceilingpic = (short)this.DOOM.textureManager.FlatNumForName(ms.ceilingpic);
            ss.lightlevel = ms.lightlevel;
            ss.special = ms.special;
            ss.tag = ms.tag;
            ss.thinglist = null;
            ss.TL = this.DOOM.actions;
            ss.RND = this.DOOM.random;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadNodes(int lump) {
        this.numnodes = this.DOOM.wadLoader.LumpLength(lump) / mapnode_t.sizeOf();
        this.nodes = this.malloc_IfSameLevel(this.nodes, this.numnodes, node_t::new, node_t[]::new);
        mapnode_t[] data = (mapnode_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numnodes, mapnode_t::new, mapnode_t[]::new);
        if (data == null || this.numnodes == 0) {
            if (this.numsubsectors == 1) {
                System.out.print("P_LoadNodes: trivial map (no nodes, one subsector)\n");
            } else {
                this.DOOM.doomSystem.Error("P_LoadNodes: no nodes in level");
            }
        }
        for (int i = 0; i < this.numnodes; ++i) {
            node_t no = this.nodes[i];
            mapnode_t mn = data[i];
            no.x = mn.x << 16;
            no.y = mn.y << 16;
            no.dx = mn.dx << 16;
            no.dy = mn.dy << 16;
            for (int j = 0; j < 2; ++j) {
                no.children[j] = mn.children[j];
                if (no.children[j] == 65535) {
                    no.children[j] = -1;
                } else if (C2JUtils.flags(no.children[j], 32768)) {
                    int n = j;
                    no.children[n] = no.children[n] & 0xFFFF7FFF;
                    if (no.children[j] >= this.numsubsectors) {
                        System.err.printf("P_LoadNodes: BSP tree references invalid subsector %d.\n", no.children[j]);
                        no.children[j] = 0;
                    }
                    int n2 = j;
                    no.children[n2] = no.children[n2] | Integer.MIN_VALUE;
                }
                for (int k = 0; k < 4; ++k) {
                    no.bbox[j].set(k, mn.bbox[j][k] << 16);
                }
            }
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadNodes_V4(int lump) {
        this.numnodes = (this.DOOM.wadLoader.LumpLength(lump) - 8) / mapnode_v4_t.sizeOf();
        this.nodes = this.malloc_IfSameLevel(this.nodes, this.numnodes, node_t::new, node_t[]::new);
        DeepBSPNodesV4 data = this.DOOM.wadLoader.CacheLumpNum(lump, 0, DeepBSPNodesV4.class);
        if (data == null || this.numnodes == 0) {
            if (this.numsubsectors == 1) {
                System.out.print("P_LoadNodes_V4: trivial map (no nodes, one subsector)\n");
            } else {
                this.DOOM.doomSystem.Error("P_LoadNodes_V4: no nodes in level");
            }
        }
        for (int i = 0; i < this.numnodes; ++i) {
            node_t no = this.nodes[i];
            mapnode_v4_t mn = data.getNodes()[i];
            no.x = mn.x << 16;
            no.y = mn.y << 16;
            no.dx = mn.dx << 16;
            no.dy = mn.dy << 16;
            for (int j = 0; j < 2; ++j) {
                no.children[j] = mn.children[j];
                for (int k = 0; k < 4; ++k) {
                    no.bbox[j].bbox[k] = mn.bbox[j][k] << 16;
                }
            }
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadZSegs(ByteBuffer data) throws IOException {
        CacheableDoomObject[] nodes = (mapseg_znod_t[])GenericCopy.malloc(mapseg_znod_t::new, mapseg_znod_t[]::new, this.numsegs);
        CacheableDoomObjectContainer.unpack(data, nodes);
        for (int i = 0; i < this.numsegs; ++i) {
            line_t ldef;
            seg_t li = this.segs[i];
            CacheableDoomObject ml = nodes[i];
            int v1 = ((mapseg_znod_t)ml).v1;
            int v2 = ((mapseg_znod_t)ml).v2;
            li.iSegID = i;
            li.miniseg = false;
            char linedef = ((mapseg_znod_t)ml).linedef;
            if (C2JUtils.unsigned(linedef) >= C2JUtils.unsigned(this.numlines)) {
                this.DOOM.doomSystem.Error("P_LoadZSegs: seg %d references a non-existent linedef %d", i, C2JUtils.unsigned(linedef));
            }
            li.linedef = ldef = this.lines[linedef];
            char side = (char)((mapseg_znod_t)ml).side;
            if (side != '\u0000' && side != '\u0001') {
                System.err.printf("P_LoadZSegs: seg %d contains wrong side index %d. Replaced with 1.\n", i, Character.valueOf(side));
                side = '\u0001';
            }
            if (C2JUtils.unsigned(ldef.sidenum[side]) >= C2JUtils.unsigned(this.numsides)) {
                this.DOOM.doomSystem.Error("P_LoadZSegs: linedef %d for seg %d references a non-existent sidedef %d", linedef, i, C2JUtils.unsigned(ldef.sidenum[side]));
            }
            li.sidedef = this.sides[ldef.sidenum[side]];
            if (ldef.sidenum[side] != '\uffff') {
                li.frontsector = this.sides[ldef.sidenum[side]].sector;
            } else {
                li.frontsector = null;
                System.err.printf("P_LoadZSegs: front of seg %i has no sidedef\n", i);
            }
            li.backsector = C2JUtils.flags(ldef.flags, 4) && ldef.sidenum[side ^ '\u0001'] != '\uffff' ? this.sides[ldef.sidenum[side ^ '\u0001']].sector : null;
            li.v1 = this.vertexes[v1];
            li.v2 = this.vertexes[v2];
            li.length = BoomLevelLoader.GetDistance(li.v2.x - li.v1.x, li.v2.y - li.v1.y);
            li.offset = BoomLevelLoader.GetOffset(li.v1, side != '\u0000' ? ldef.v2 : ldef.v1);
            li.angle = RendererState.PointToAngle(this.segs[i].v1.x, this.segs[i].v1.y, this.segs[i].v2.x, this.segs[i].v2.y);
        }
    }

    private int CheckZNodesOverflow(int size, int count) {
        if ((size -= count) < 0) {
            this.DOOM.doomSystem.Error("P_LoadZNodes: incorrect nodes");
        }
        return size;
    }

    private void P_LoadZNodes(int lump, int glnodes) throws IOException {
        int numNodes;
        int numSubs;
        int i;
        vertex_t[] newvertarray = null;
        ByteBuffer data = this.DOOM.wadLoader.CacheLumpNumAsDoomBuffer(lump).getBuffer();
        data.order(ByteOrder.LITTLE_ENDIAN);
        int len = this.DOOM.wadLoader.LumpLength(lump);
        len = this.CheckZNodesOverflow(len, 4);
        int header = data.getInt();
        len = this.CheckZNodesOverflow(len, 4);
        int orgVerts = data.getInt();
        len = this.CheckZNodesOverflow(len, 4);
        int newVerts = data.getInt();
        if (!this.samelevel) {
            if (orgVerts + newVerts == this.numvertexes) {
                newvertarray = this.vertexes;
            } else {
                newvertarray = new vertex_t[orgVerts + newVerts];
                Arrays.setAll(newvertarray, ii -> new vertex_t());
                System.arraycopy(this.vertexes, 0, newvertarray, 0, orgVerts);
            }
            len = this.CheckZNodesOverflow(len, newVerts * vertex_t.sizeOf());
            z_vertex_t tmp = new z_vertex_t();
            for (i = 0; i < newVerts; ++i) {
                tmp.unpack(data);
                newvertarray[i + orgVerts].x = tmp.x;
                newvertarray[i + orgVerts].y = tmp.y;
            }
            if (this.vertexes != newvertarray) {
                for (i = 0; i < this.numlines; ++i) {
                    this.lines[i].v1 = newvertarray[C2JUtils.indexOf(this.vertexes, this.lines[i].v1)];
                    this.lines[i].v2 = newvertarray[C2JUtils.indexOf(this.vertexes, this.lines[i].v2)];
                }
                this.vertexes = newvertarray;
                this.numvertexes = orgVerts + newVerts;
            }
        } else {
            int size = newVerts * z_vertex_t.sizeOf();
            len = this.CheckZNodesOverflow(len, size);
            data.position(data.position() + size);
        }
        len = this.CheckZNodesOverflow(len, 4);
        this.numsubsectors = numSubs = data.getInt();
        if (this.numsubsectors <= 0) {
            this.DOOM.doomSystem.Error("P_LoadZNodes: no subsectors in level");
        }
        this.subsectors = (subsector_t[])this.calloc_IfSameLevel(this.subsectors, this.numsubsectors, subsector_t::new, subsector_t[]::new);
        len = this.CheckZNodesOverflow(len, numSubs * mapsubsector_znod_t.sizeOf());
        mapsubsector_znod_t mseg = new mapsubsector_znod_t();
        int currSeg = 0;
        for (i = 0; i < numSubs; ++i) {
            mseg.unpack(data);
            this.subsectors[i].firstline = currSeg;
            this.subsectors[i].numlines = (int)mseg.numsegs;
            currSeg = (int)((long)currSeg + mseg.numsegs);
        }
        len = this.CheckZNodesOverflow(len, 4);
        int numSegs = data.getInt();
        if (numSegs != currSeg) {
            this.DOOM.doomSystem.Error("P_LoadZNodes: Incorrect number of segs in nodes.");
        }
        this.numsegs = numSegs;
        this.segs = (seg_t[])this.calloc_IfSameLevel(this.segs, this.numsegs, seg_t::new, seg_t[]::new);
        if (glnodes == 0) {
            len = this.CheckZNodesOverflow(len, this.numsegs * mapseg_znod_t.sizeOf());
            this.P_LoadZSegs(data);
        } else {
            this.DOOM.doomSystem.Error("P_LoadZNodes: GL segs are not supported.");
        }
        len = this.CheckZNodesOverflow(len, 4);
        this.numnodes = numNodes = data.getInt();
        this.nodes = (node_t[])this.calloc_IfSameLevel(this.nodes, numNodes, node_t::new, node_t[]::new);
        len = this.CheckZNodesOverflow(len, numNodes * mapnode_znod_t.sizeOf());
        CacheableDoomObject[] znodes = (mapnode_znod_t[])GenericCopy.malloc(mapnode_znod_t::new, mapnode_znod_t[]::new, numNodes);
        CacheableDoomObjectContainer.unpack(data, znodes);
        for (int i2 = 0; i2 < numNodes; ++i2) {
            node_t no = this.nodes[i2];
            CacheableDoomObject mn = znodes[i2];
            no.x = ((mapnode_znod_t)mn).x << 16;
            no.y = ((mapnode_znod_t)mn).y << 16;
            no.dx = ((mapnode_znod_t)mn).dx << 16;
            no.dy = ((mapnode_znod_t)mn).dy << 16;
            for (int j = 0; j < 2; ++j) {
                no.children[j] = ((mapnode_znod_t)mn).children[j];
                for (int k = 0; k < 4; ++k) {
                    no.bbox[j].bbox[k] = ((mapnode_znod_t)mn).bbox[j][k] << 16;
                }
            }
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private int GETXY(mobj_t mobj) {
        return mobj.x + (mobj.y >> 16);
    }

    private int dicmp_sprite_by_pos(Object a, Object b) {
        mobj_t m1 = (mobj_t)a;
        mobj_t m2 = (mobj_t)b;
        int res = this.GETXY(m2) - this.GETXY(m1);
        this.no_overlapped_sprites = this.no_overlapped_sprites && res != 0;
        return res;
    }

    private void P_LoadThings(int lump) {
        int numthings = this.DOOM.wadLoader.LumpLength(lump) / mapthing_t.sizeOf();
        mapthing_t[] data = (mapthing_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, numthings, mapthing_t::new, mapthing_t[]::new);
        int mobjcount = 0;
        mobj_t[] mobjlist = new mobj_t[numthings];
        Arrays.setAll(mobjlist, j -> mobj_t.createOn(this.DOOM));
        if (data == null || numthings == 0) {
            this.DOOM.doomSystem.Error("P_LoadThings: no things in level");
        }
        for (int i = 0; i < numthings; ++i) {
            mobj_t mobj;
            mapthing_t mt = data[i];
            if (!this.P_IsDoomnumAllowed(mt.type) || (mobj = this.DOOM.actions.SpawnMapThing(mt)) == null || mobj.info.speed != 0) continue;
            mobjlist[mobjcount++] = mobj;
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    boolean P_IsDoomnumAllowed(int doomnum) {
        if (!this.DOOM.isCommercial()) {
            switch (doomnum) {
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 84: 
                case 88: 
                case 89: {
                    return false;
                }
            }
        }
        return true;
    }

    private void P_LoadLineDefs(int lump) {
        this.numlines = this.DOOM.wadLoader.LumpLength(lump) / maplinedef_t.sizeOf();
        this.lines = (line_t[])this.calloc_IfSameLevel(this.lines, this.numlines, line_t::new, line_t[]::new);
        maplinedef_t[] data = (maplinedef_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numlines, maplinedef_t::new, maplinedef_t[]::new);
        for (int i = 0; i < this.numlines; ++i) {
            maplinedef_t mld = data[i];
            line_t ld = this.lines[i];
            ld.id = i;
            ld.flags = mld.flags;
            ld.special = mld.special;
            ld.tag = mld.tag;
            vertex_t v1 = ld.v1 = this.vertexes[mld.v1];
            vertex_t v2 = ld.v2 = this.vertexes[mld.v2];
            ld.dx = v2.x - v1.x;
            ld.dy = v2.y - v1.y;
            ld.assignVertexValues();
            ld.tranlump = -1;
            slopetype_t slopetype_t2 = ld.dx == 0 ? slopetype_t.ST_VERTICAL : (ld.dy == 0 ? slopetype_t.ST_HORIZONTAL : (ld.slopetype = fixed_t.FixedDiv(ld.dy, ld.dx) > 0 ? slopetype_t.ST_POSITIVE : slopetype_t.ST_NEGATIVE));
            if (v1.x < v2.x) {
                ld.bbox[2] = v1.x;
                ld.bbox[3] = v2.x;
            } else {
                ld.bbox[2] = v2.x;
                ld.bbox[3] = v1.x;
            }
            if (v1.y < v2.y) {
                ld.bbox[1] = v1.y;
                ld.bbox[0] = v2.y;
            } else {
                ld.bbox[1] = v2.y;
                ld.bbox[0] = v1.y;
            }
            ld.soundorg = new degenmobj_t(ld.bbox[2] / 2 + ld.bbox[3] / 2, ld.bbox[0] / 2 + ld.bbox[1] / 2, 0);
            ld.sidenum[0] = mld.sidenum[0];
            ld.sidenum[1] = mld.sidenum[1];
            for (int j = 0; j < 2; ++j) {
                if (ld.sidenum[j] == '\uffff' || ld.sidenum[j] < this.numsides) continue;
                ld.sidenum[j] = 65535;
                System.err.printf("P_LoadLineDefs: linedef %d has out-of-range sidedef number\n", this.numlines - i - 1);
            }
            if (ld.sidenum[0] == '\uffff') {
                ld.sidenum[0] = '\u0000';
                System.err.printf("P_LoadLineDefs: linedef %d missing first sidedef\n", this.numlines - i - 1);
            }
            if (ld.sidenum[1] != '\uffff' || !C2JUtils.flags(ld.flags, 4)) continue;
            ld.flags = (short)(ld.flags & 0xFFFFFFFB);
            System.err.printf("P_LoadLineDefs: linedef %d has two-sided flag set, but no second sidedef\n", this.numlines - i - 1);
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadLineDefs2(int lump) {
        for (int i = 0; i < this.numlines; ++i) {
            line_t ld = this.lines[i];
            ld.frontsector = this.sides[ld.sidenum[0]].sector;
            ld.backsector = ld.sidenum[1] != '\uffff' ? this.sides[ld.sidenum[1]].sector : null;
            switch (ld.special) {
                default: 
            }
        }
    }

    private void P_LoadSideDefs(int lump) {
        this.numsides = this.DOOM.wadLoader.LumpLength(lump) / mapsidedef_t.sizeOf();
        this.sides = (side_t[])this.calloc_IfSameLevel(this.sides, this.numsides, side_t::new, side_t[]::new);
    }

    private void P_LoadSideDefs2(int lump) {
        mapsidedef_t[] data = (mapsidedef_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsides, mapsidedef_t::new, mapsidedef_t[]::new);
        block4: for (int i = 0; i < this.numsides; ++i) {
            sector_t sec;
            mapsidedef_t msd = data[i];
            side_t sd = this.sides[i];
            sd.textureoffset = msd.textureoffset << 16;
            sd.rowoffset = msd.rowoffset << 16;
            char sector_num = (char)msd.sector;
            if (sector_num >= this.numsectors) {
                System.err.printf("P_LoadSideDefs2: sidedef %i has out-of-range sector num %u\n", i, Character.valueOf(sector_num));
                sector_num = '\u0000';
            }
            sd.sector = sec = this.sectors[sector_num];
            switch (sd.special) {
                case 242: {
                    continue block4;
                }
                case 260: {
                    if (msd.midtexture.compareToIgnoreCase("TRANMAP") == 0) {
                        sd.special = this.DOOM.wadLoader.CheckNumForName(msd.midtexture);
                        if (sd.special < 0 || this.DOOM.wadLoader.LumpLength(sd.special) != 65536) {
                            sd.special = 0;
                            sd.midtexture = (short)this.DOOM.textureManager.TextureNumForName(msd.midtexture);
                        } else {
                            ++sd.special;
                            sd.midtexture = 0;
                        }
                    } else {
                        sd.special = 0;
                        sd.midtexture = (short)0;
                    }
                    sd.toptexture = (short)this.DOOM.textureManager.TextureNumForName(msd.toptexture);
                    sd.bottomtexture = (short)this.DOOM.textureManager.TextureNumForName(msd.bottomtexture);
                    continue block4;
                }
                default: {
                    sd.midtexture = (short)this.DOOM.textureManager.CheckTextureNumForName(msd.midtexture);
                    sd.toptexture = (short)this.DOOM.textureManager.CheckTextureNumForName(msd.toptexture);
                    sd.bottomtexture = (short)this.DOOM.textureManager.CheckTextureNumForName(msd.bottomtexture);
                }
            }
        }
        this.DOOM.wadLoader.UnlockLumpNum(lump);
    }

    private void P_LoadBlockMap(int lump) throws IOException {
        int count = 0;
        if (this.DOOM.cVarManager.bool(CommandVariable.BLOCKMAP) || this.DOOM.wadLoader.LumpLength(lump) < 8 || (count = this.DOOM.wadLoader.LumpLength(lump) / 2) >= 65536) {
            this.CreateBlockMap();
        } else {
            DoomBuffer data = this.DOOM.wadLoader.CacheLumpNum(lump, 50, DoomBuffer.class);
            count = this.DOOM.wadLoader.LumpLength(lump) / 2;
            char[] wadblockmaplump = new char[count];
            data.setOrder(ByteOrder.LITTLE_ENDIAN);
            data.rewind();
            data.readCharArray(wadblockmaplump, count);
            if (!this.samelevel) {
                this.blockmaplump = new int[count];
            }
            this.blockmaplump[0] = wadblockmaplump[0];
            this.blockmaplump[1] = wadblockmaplump[1];
            this.blockmaplump[2] = wadblockmaplump[2] & 0xFFFF;
            this.blockmaplump[3] = wadblockmaplump[3] & 0xFFFF;
            for (int i = 4; i < count; ++i) {
                short t = (short)wadblockmaplump[i];
                this.blockmaplump[i] = (int)(t == -1 ? -1L : (long)(t & 0xFFFF));
            }
            this.DOOM.wadLoader.UnlockLumpNum(lump);
            this.bmaporgx = this.blockmaplump[0] << 16;
            this.bmaporgy = this.blockmaplump[1] << 16;
            this.bmapwidth = this.blockmaplump[2];
            this.bmapheight = this.blockmaplump[3];
            if (!this.VerifyBlockMap(count)) {
                System.err.printf("P_LoadBlockMap: erroneous BLOCKMAP lump may cause crashes.\n", new Object[0]);
                System.err.printf("P_LoadBlockMap: use \"-blockmap\" command line switch for rebuilding\n", new Object[0]);
            }
        }
        if (count == 0) {
            count = this.blockmaplump.length - 4;
        }
        if (this.blocklinks != null && this.samelevel) {
            for (int i = 0; i < this.bmapwidth * this.bmapheight; ++i) {
                this.blocklinks[i] = null;
            }
        } else {
            this.blocklinks = new mobj_t[this.bmapwidth * this.bmapheight];
        }
        this.blockmap = new int[this.blockmaplump.length - 4];
        count = this.bmapwidth * this.bmapheight;
        for (int i = 0; i < this.blockmaplump.length - 4; ++i) {
            this.blockmaplump[i] = i < count ? this.blockmaplump[i + 4] - 4 : this.blockmaplump[i + 4];
        }
        if (this.bmapwidth > 255) {
            this.blockmapxneg = this.bmapwidth - 512;
        }
        if (this.bmapheight > 255) {
            this.blockmapyneg = this.bmapheight - 512;
        }
        this.blockmap = this.blockmaplump;
    }

    private void P_LoadReject(int lumpnum, int totallines) {
        if (this.rejectlump != -1) {
            this.DOOM.wadLoader.UnlockLumpNum(this.rejectlump);
        }
        this.rejectlump = lumpnum + 9;
        this.rejectmatrix = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(this.rejectlump, 0);
    }

    private int P_GroupLines() {
        sector_t sector;
        line_t li;
        int i;
        int total = this.numlines;
        for (i = 0; i < this.numsubsectors; ++i) {
            int seg = this.subsectors[i].firstline;
            this.subsectors[i].sector = null;
            for (int j = 0; j < this.subsectors[i].numlines; ++j) {
                if (this.segs[seg].sidedef != null) {
                    this.subsectors[i].sector = this.segs[seg].sidedef.sector;
                    break;
                }
                ++seg;
            }
            if (this.subsectors[i].sector != null) continue;
            this.DOOM.doomSystem.Error("P_GroupLines: Subsector a part of no sector!\n");
        }
        for (i = 0; i < this.numlines; ++i) {
            li = this.lines[i];
            ++li.frontsector.linecount;
            if (li.backsector == null || li.backsector == li.frontsector) continue;
            ++li.backsector.linecount;
            ++total;
        }
        for (i = 0; i < this.numsectors; ++i) {
            sector = this.sectors[i];
            sector.lines = (line_t[])GenericCopy.malloc(line_t::new, line_t[]::new, sector.linecount);
            sector.linecount = 0;
            BBox.ClearBox(sector.blockbox);
        }
        for (i = 0; i < this.numlines; ++i) {
            li = this.lines[i];
            this.AddLineToSector(li, li.frontsector);
            if (li.backsector == null || li.backsector == li.frontsector) continue;
            this.AddLineToSector(li, li.backsector);
        }
        for (i = 0; i < this.numsectors; ++i) {
            sector = this.sectors[i];
            int[] bbox = sector.blockbox;
            sector.soundorg = new degenmobj_t((bbox[3] + bbox[2]) / 2, (bbox[0] + bbox[1]) / 2);
            int block = this.getSafeBlockY(bbox[0] - this.bmaporgy + 0x200000);
            sector.blockbox[0] = block = block >= this.bmapheight ? this.bmapheight - 1 : block;
            block = this.getSafeBlockY(bbox[1] - this.bmaporgy - 0x200000);
            sector.blockbox[1] = block = block < 0 ? 0 : block;
            block = this.getSafeBlockX(bbox[3] - this.bmaporgx + 0x200000);
            sector.blockbox[3] = block = block >= this.bmapwidth ? this.bmapwidth - 1 : block;
            block = this.getSafeBlockX(bbox[2] - this.bmaporgx - 0x200000);
            sector.blockbox[2] = block = block < 0 ? 0 : block;
        }
        return total;
    }

    private void P_RemoveSlimeTrails() {
        boolean[] hit = new boolean[this.numvertexes];
        for (int i = 0; i < this.numsegs; ++i) {
            if (this.segs[i].miniseg) {
                return;
            }
            line_t l = this.segs[i].linedef;
            if (l.dx != 0 && l.dy != 0) {
                vertex_t v = this.segs[i].v1;
                do {
                    int index;
                    if (hit[index = C2JUtils.indexOf(this.vertexes, v)]) continue;
                    hit[index] = true;
                    if (v == l.v1 || v == l.v2) continue;
                    long dx2 = (l.dx >> 16) * (l.dx >> 16);
                    long dy2 = (l.dy >> 16) * (l.dy >> 16);
                    long dxy = (l.dx >> 16) * (l.dy >> 16);
                    long s = dx2 + dy2;
                    int x0 = v.x;
                    int y0 = v.y;
                    int x1 = l.v1.x;
                    int y1 = l.v1.y;
                    v.x = (int)((dx2 * (long)x0 + dy2 * (long)x1 + dxy * (long)(y0 - y1)) / s);
                    v.y = (int)((dy2 * (long)y0 + dx2 * (long)y1 + dxy * (long)(x0 - x1)) / s);
                } while (v != this.segs[i].v2 && (v = this.segs[i].v2) != null);
            }
            l.assignVertexValues();
        }
    }

    boolean P_CheckLumpsForSameSource(int lump1, int lump2) {
        int wad2_index;
        if (C2JUtils.unsigned(lump1) >= C2JUtils.unsigned(this.DOOM.wadLoader.NumLumps()) || C2JUtils.unsigned(lump2) >= C2JUtils.unsigned(this.DOOM.wadLoader.NumLumps())) {
            return false;
        }
        wadfile_info_t wad1 = this.DOOM.wadLoader.GetLumpInfo((int)lump1).wadfile;
        wadfile_info_t wad2 = this.DOOM.wadLoader.GetLumpInfo((int)lump2).wadfile;
        if (wad1 == null || wad2 == null) {
            return false;
        }
        int wad1_index = this.DOOM.wadLoader.GetWadfileIndex(wad1);
        if (wad1_index != (wad2_index = this.DOOM.wadLoader.GetWadfileIndex(wad2))) {
            return false;
        }
        if (wad1_index < 0 || wad1_index >= this.DOOM.wadLoader.GetNumWadfiles()) {
            return false;
        }
        return wad2_index >= 0 && wad2_index < this.DOOM.wadLoader.GetNumWadfiles();
    }

    void P_CheckLevelWadStructure(String mapname) {
        int i;
        if (mapname == null) {
            this.DOOM.doomSystem.Error("P_SetupLevel: Wrong map name");
            throw new NullPointerException();
        }
        int lumpnum = this.DOOM.wadLoader.CheckNumForName(mapname.toUpperCase());
        if (lumpnum < 0) {
            this.DOOM.doomSystem.Error("P_SetupLevel: There is no %s map.", mapname);
        }
        for (i = 2; i <= 8; ++i) {
            if (this.P_CheckLumpsForSameSource(lumpnum, lumpnum + i)) continue;
            this.DOOM.doomSystem.Error("P_SetupLevel: Level wad structure is incomplete. There is no %s lump. (%s)", ml_labels[i], this.DOOM.wadLoader.GetNameForLump(lumpnum));
        }
        i = lumpnum + 10 + 1;
        if (this.P_CheckLumpsForSameSource(lumpnum, i) && this.DOOM.wadLoader.GetLumpInfo((int)i).name.compareToIgnoreCase("BEHAVIOR") == 0) {
            this.DOOM.doomSystem.Error("P_SetupLevel: %s: Hexen format not supported", mapname);
        }
    }

    @Override
    public void SetupLevel(int episode, int map, int playermask, skill_t skill) throws IOException {
        String gl_lumpname;
        String lumpname;
        int i2;
        this.DOOM.totallive = 0;
        this.DOOM.wminfo.maxfrags = 0;
        this.DOOM.totalsecret = 0;
        this.DOOM.totalitems = 0;
        this.DOOM.totalkills = 0;
        this.DOOM.totallive = 0;
        this.DOOM.wminfo.partime = 180;
        for (i2 = 0; i2 < 4; ++i2) {
            this.DOOM.players[i2].itemcount = 0;
            this.DOOM.players[i2].secretcount = 0;
            this.DOOM.players[i2].killcount = 0;
        }
        this.DOOM.players[this.DOOM.consoleplayer].viewz = 1;
        this.DOOM.doomSound.Start();
        if (this.rejectlump != -1) {
            this.DOOM.wadLoader.UnlockLumpNum(this.rejectlump);
            this.rejectlump = -1;
        }
        this.DOOM.actions.InitThinkers();
        if (this.DOOM.isCommercial()) {
            lumpname = String.format("map%02d", map);
            gl_lumpname = String.format("gl_map%02d", map);
        } else {
            lumpname = String.format("E%dM%d", episode, map);
            gl_lumpname = String.format("GL_E%dM%d", episode, map);
        }
        int lumpnum = this.DOOM.wadLoader.GetNumForName(lumpname);
        int gl_lumpnum = this.DOOM.wadLoader.CheckNumForName(gl_lumpname);
        this.P_CheckLevelWadStructure(lumpname);
        this.DOOM.leveltime = 0;
        this.DOOM.totallive = 0;
        this.P_GetNodesVersion(lumpnum, gl_lumpnum);
        this.samelevel = map == this.current_map && episode == this.current_episode && this.nodesVersion == this.current_nodesVersion;
        this.current_episode = episode;
        this.current_map = map;
        this.current_nodesVersion = this.nodesVersion;
        if (!this.samelevel) {
            // empty if block
        }
        if (this.nodesVersion > 0) {
            this.P_LoadVertexes2(lumpnum + 4, gl_lumpnum + 1);
        } else {
            this.P_LoadVertexes(lumpnum + 4);
        }
        this.P_LoadSectors(lumpnum + 8);
        this.P_LoadSideDefs(lumpnum + 3);
        this.P_LoadLineDefs(lumpnum + 2);
        this.P_LoadSideDefs2(lumpnum + 3);
        this.P_LoadLineDefs2(lumpnum + 2);
        if (!this.samelevel) {
            this.P_LoadBlockMap(lumpnum + 10);
        } else if (this.blocklinks != null && this.blocklinks.length == this.bmapwidth * this.bmapheight) {
            for (i2 = 0; i2 < this.bmapwidth * this.bmapheight; ++i2) {
                this.blocklinks[i2] = null;
            }
        } else {
            this.blocklinks = new mobj_t[this.bmapwidth * this.bmapheight];
            Arrays.setAll(this.blocklinks, i -> mobj_t.createOn(this.DOOM));
        }
        if (this.nodesVersion > 0) {
            this.P_LoadSubsectors(gl_lumpnum + 3);
            this.P_LoadNodes(gl_lumpnum + 4);
        } else if (this.P_CheckForZDoomUncompressedNodes(lumpnum, gl_lumpnum)) {
            this.P_LoadZNodes(lumpnum + 7, 0);
        } else if (this.P_CheckForDeePBSPv4Nodes(lumpnum, gl_lumpnum)) {
            this.P_LoadSubsectors_V4(lumpnum + 6);
            this.P_LoadNodes_V4(lumpnum + 7);
            this.P_LoadSegs_V4(lumpnum + 5);
        } else {
            this.P_LoadSubsectors(lumpnum + 6);
            this.P_LoadNodes(lumpnum + 7);
            this.P_LoadSegs(lumpnum + 5);
        }
        this.P_GroupLines();
        super.LoadReject(lumpnum + 9);
        this.P_RemoveSlimeTrails();
        this.DOOM.bodyqueslot = 0;
        for (i2 = 0; i2 < this.playerstarts.length; ++i2) {
            this.DOOM.playerstarts[i2] = null;
        }
        this.deathmatch_p = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            this.DOOM.players[i2].mo = null;
        }
        this.P_LoadThings(lumpnum + 1);
        if (this.DOOM.deathmatch) {
            for (i2 = 0; i2 < 4; ++i2) {
                if (!this.DOOM.playeringame[i2]) continue;
                this.DOOM.players[i2].mo = null;
                this.DOOM.DeathMatchSpawnPlayer(i2);
            }
        } else {
            for (i2 = 0; i2 < 4; ++i2) {
                if (!this.DOOM.playeringame[i2] || C2JUtils.eval(this.DOOM.players[i2].mo)) continue;
                this.DOOM.doomSystem.Error("P_SetupLevel: missing player %d start\n", i2 + 1);
            }
        }
        if (!this.DOOM.isShareware()) {
            // empty if block
        }
        this.DOOM.actions.ClearRespawnQueue();
        this.DOOM.actions.SpawnSpecials();
        if (this.DOOM.precache) {
            this.DOOM.textureManager.PrecacheLevel();
            this.DOOM.sceneRenderer.PreCacheThinkers();
        }
    }

    class glseg_t {
        char v1;
        char v2;
        char linedef;
        short side;
        short partner;

        glseg_t() {
        }
    }
}

