/*
 * Decompiled with CFR 0.152.
 */
package p;

import data.sounds;
import doom.DoomMain;
import doom.thinker_t;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import m.Settings;
import mochadoom.Engine;
import mochadoom.Loggers;
import p.ActionFunctions;
import p.ThinkerList;
import p.anim_t;
import p.animdef_t;
import p.button_t;
import p.bwhere_e;
import p.switchlist_t;
import rr.ISpriteManager;
import rr.line_t;
import s.ISoundOrigin;
import utils.C2JUtils;
import utils.GenericCopy;

public abstract class UnifiedGameMap
implements ThinkerList {
    private static final Logger LOGGER = Loggers.getLogger(UnifiedGameMap.class.getName());
    final DoomMain<?, ?> DOOM;
    public ActionFunctions A;
    Specials SPECS;
    Switches SW;
    int ptflags;
    public boolean sight_debug;
    private final animdef_t[] animdefs = new animdef_t[]{new animdef_t(false, "NUKAGE3", "NUKAGE1", 8), new animdef_t(false, "FWATER4", "FWATER1", 8), new animdef_t(false, "SWATER4", "SWATER1", 8), new animdef_t(false, "LAVA4", "LAVA1", 8), new animdef_t(false, "BLOOD3", "BLOOD1", 8), new animdef_t(false, "RROCK08", "RROCK05", 8), new animdef_t(false, "SLIME04", "SLIME01", 8), new animdef_t(false, "SLIME08", "SLIME05", 8), new animdef_t(false, "SLIME12", "SLIME09", 8), new animdef_t(true, "BLODGR4", "BLODGR1", 8), new animdef_t(true, "SLADRIP3", "SLADRIP1", 8), new animdef_t(true, "BLODRIP4", "BLODRIP1", 8), new animdef_t(true, "FIREWALL", "FIREWALA", 8), new animdef_t(true, "GSTFONT3", "GSTFONT1", 8), new animdef_t(true, "FIRELAVA", "FIRELAV3", 8), new animdef_t(true, "FIREMAG3", "FIREMAG1", 8), new animdef_t(true, "FIREBLU2", "FIREBLU1", 8), new animdef_t(true, "ROCKRED3", "ROCKRED1", 8), new animdef_t(true, "BFALL4", "BFALL1", 8), new animdef_t(true, "SFALL4", "SFALL1", 8), new animdef_t(true, "WFALL4", "WFALL1", 8), new animdef_t(true, "DBRAIN4", "DBRAIN1", 8)};
    public thinker_t thinkercap;
    protected thinker_t currentthinker;

    public UnifiedGameMap(DoomMain<?, ?> DOOM) {
        this.SW = new Switches();
        this.SPECS = new Specials();
        this.thinkercap = new thinker_t();
        this.DOOM = DOOM;
    }

    @Override
    public void InitThinkers() {
        thinker_t next = this.thinkercap.next;
        thinker_t prev = this.thinkercap.prev;
        if (next != null && next != this.thinkercap) {
            next.prev = null;
        }
        if (prev != null && prev != this.thinkercap) {
            prev.next = null;
        }
        this.thinkercap.next = this.thinkercap;
        this.thinkercap.prev = this.thinkercap;
    }

    @Override
    public void AddThinker(thinker_t thinker) {
        this.thinkercap.prev.next = thinker;
        thinker.next = this.thinkercap;
        thinker.prev = this.thinkercap.prev;
        this.thinkercap.prev = thinker;
    }

    @Override
    public thinker_t getRandomThinker() {
        int pick = (int)(Math.random() * 128.0);
        thinker_t th = this.getThinkerCap();
        for (int i = 0; i < pick; ++i) {
            th = th.next;
        }
        return th;
    }

    public void Init() {
        this.SW.InitSwitchList();
        this.SPECS.InitPicAnims();
        this.DOOM.spriteManager.InitSprites(ISpriteManager.doomsprnames);
    }

    @Override
    public thinker_t getThinkerCap() {
        return this.thinkercap;
    }

    public class Switches {
        switchlist_t[] alphSwitchList = new switchlist_t[]{new switchlist_t("SW1BRCOM", "SW2BRCOM", 1), new switchlist_t("SW1BRN1", "SW2BRN1", 1), new switchlist_t("SW1BRN2", "SW2BRN2", 1), new switchlist_t("SW1BRNGN", "SW2BRNGN", 1), new switchlist_t("SW1BROWN", "SW2BROWN", 1), new switchlist_t("SW1COMM", "SW2COMM", 1), new switchlist_t("SW1COMP", "SW2COMP", 1), new switchlist_t("SW1DIRT", "SW2DIRT", 1), new switchlist_t("SW1EXIT", "SW2EXIT", 1), new switchlist_t("SW1GRAY", "SW2GRAY", 1), new switchlist_t("SW1GRAY1", "SW2GRAY1", 1), new switchlist_t("SW1METAL", "SW2METAL", 1), new switchlist_t("SW1PIPE", "SW2PIPE", 1), new switchlist_t("SW1SLAD", "SW2SLAD", 1), new switchlist_t("SW1STARG", "SW2STARG", 1), new switchlist_t("SW1STON1", "SW2STON1", 1), new switchlist_t("SW1STON2", "SW2STON2", 1), new switchlist_t("SW1STONE", "SW2STONE", 1), new switchlist_t("SW1STRTN", "SW2STRTN", 1), new switchlist_t("SW1BLUE", "SW2BLUE", 2), new switchlist_t("SW1CMT", "SW2CMT", 2), new switchlist_t("SW1GARG", "SW2GARG", 2), new switchlist_t("SW1GSTON", "SW2GSTON", 2), new switchlist_t("SW1HOT", "SW2HOT", 2), new switchlist_t("SW1LION", "SW2LION", 2), new switchlist_t("SW1SATYR", "SW2SATYR", 2), new switchlist_t("SW1SKIN", "SW2SKIN", 2), new switchlist_t("SW1VINE", "SW2VINE", 2), new switchlist_t("SW1WOOD", "SW2WOOD", 2), new switchlist_t("SW1PANEL", "SW2PANEL", 3), new switchlist_t("SW1ROCK", "SW2ROCK", 3), new switchlist_t("SW1MET2", "SW2MET2", 3), new switchlist_t("SW1WDMET", "SW2WDMET", 3), new switchlist_t("SW1BRIK", "SW2BRIK", 3), new switchlist_t("SW1MOD1", "SW2MOD1", 3), new switchlist_t("SW1ZIM", "SW2ZIM", 3), new switchlist_t("SW1STON6", "SW2STON6", 3), new switchlist_t("SW1TEK", "SW2TEK", 3), new switchlist_t("SW1MARB", "SW2MARB", 3), new switchlist_t("SW1SKULL", "SW2SKULL", 3), new switchlist_t("\u0000", "\u0000", 0)};
        int[] switchlist = new int[50];
        int numswitches;
        button_t[] buttonlist;

        private Switches() {
            this.initButtonList();
        }

        public void doButtons() {
            for (button_t buttonlist1 : this.buttonlist) {
                if (!C2JUtils.eval(buttonlist1.btimer)) continue;
                --buttonlist1.btimer;
                if (C2JUtils.eval(buttonlist1.btimer)) continue;
                switch (buttonlist1.where) {
                    case top: {
                        UnifiedGameMap.this.DOOM.levelLoader.sides[buttonlist1.line.sidenum[0]].toptexture = (short)buttonlist1.btexture;
                        break;
                    }
                    case middle: {
                        UnifiedGameMap.this.DOOM.levelLoader.sides[buttonlist1.line.sidenum[0]].midtexture = (short)buttonlist1.btexture;
                        break;
                    }
                    case bottom: {
                        UnifiedGameMap.this.DOOM.levelLoader.sides[buttonlist1.line.sidenum[0]].bottomtexture = (short)buttonlist1.btexture;
                    }
                }
                UnifiedGameMap.this.DOOM.doomSound.StartSound((ISoundOrigin)buttonlist1.soundorg, sounds.sfxenum_t.sfx_swtchn);
                buttonlist1.reset();
            }
        }

        public void InitSwitchList() {
            short episode = 1;
            if (UnifiedGameMap.this.DOOM.isRegistered()) {
                episode = 2;
            } else if (UnifiedGameMap.this.DOOM.isCommercial()) {
                episode = 3;
            }
            int index = 0;
            for (int i = 0; i < 50; ++i) {
                if (index >= this.switchlist.length) {
                    this.switchlist = Arrays.copyOf(this.switchlist, this.switchlist.length > 0 ? this.switchlist.length * 2 : 8);
                }
                if (this.alphSwitchList[i].episode == 0) {
                    this.numswitches = index / 2;
                    this.switchlist[index] = -1;
                    break;
                }
                if (this.alphSwitchList[i].episode > episode) continue;
                this.switchlist[index++] = UnifiedGameMap.this.DOOM.textureManager.TextureNumForName(this.alphSwitchList[i].name1);
                this.switchlist[index++] = UnifiedGameMap.this.DOOM.textureManager.TextureNumForName(this.alphSwitchList[i].name2);
            }
        }

        public final void StartButton(line_t line, bwhere_e w, int texture, int time) {
            for (button_t buttonlist1 : this.buttonlist) {
                if (buttonlist1.btimer == 0 || buttonlist1.line != line) continue;
                return;
            }
            for (button_t buttonlist1 : this.buttonlist) {
                if (buttonlist1.btimer != 0) continue;
                buttonlist1.line = line;
                buttonlist1.where = w;
                buttonlist1.btexture = texture;
                buttonlist1.btimer = time;
                buttonlist1.soundorg = line.soundorg;
                return;
            }
            if (Engine.getConfig().equals(Settings.extend_button_slots_limit, Boolean.TRUE)) {
                this.buttonlist = C2JUtils.resize(this.buttonlist[0], this.buttonlist, this.buttonlist.length * 2);
                this.StartButton(line, w, texture, time);
            } else {
                LOGGER.log(Level.SEVERE, "P_StartButton: no button slots left!");
                System.exit(1);
            }
        }

        public void ChangeSwitchTexture(line_t line, boolean useAgain) {
            if (!useAgain) {
                line.special = 0;
            }
            short texTop = UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].toptexture;
            short texMid = UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].midtexture;
            short texBot = UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].bottomtexture;
            int sound = sounds.sfxenum_t.sfx_swtchn.ordinal();
            if (line.special == 11) {
                sound = sounds.sfxenum_t.sfx_swtchx.ordinal();
            }
            for (int i = 0; i < this.numswitches * 2; ++i) {
                if (this.switchlist[i] == texTop) {
                    UnifiedGameMap.this.DOOM.doomSound.StartSound((ISoundOrigin)this.buttonlist[0].soundorg, sound);
                    UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].toptexture = (short)this.switchlist[i ^ 1];
                    if (useAgain) {
                        this.StartButton(line, bwhere_e.top, this.switchlist[i], 35);
                    }
                    return;
                }
                if (this.switchlist[i] == texMid) {
                    UnifiedGameMap.this.DOOM.doomSound.StartSound((ISoundOrigin)this.buttonlist[0].soundorg, sound);
                    UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].midtexture = (short)this.switchlist[i ^ 1];
                    if (useAgain) {
                        this.StartButton(line, bwhere_e.middle, this.switchlist[i], 35);
                    }
                    return;
                }
                if (this.switchlist[i] != texBot) continue;
                UnifiedGameMap.this.DOOM.doomSound.StartSound((ISoundOrigin)this.buttonlist[0].soundorg, sound);
                UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].bottomtexture = (short)this.switchlist[i ^ 1];
                if (useAgain) {
                    this.StartButton(line, bwhere_e.bottom, this.switchlist[i], 35);
                }
                return;
            }
        }

        public final void initButtonList() {
            this.buttonlist = (button_t[])GenericCopy.malloc(button_t::new, button_t[]::new, 16);
        }
    }

    public class Specials {
        public static final int OK = 0;
        public static final int CRUSHED = 1;
        public static final int PASTDEST = 2;
        public line_t[] linespeciallist = new line_t[64];
        public short numlinespecials;
        public anim_t[] anims = new anim_t[32];
        public int lastanim;
        public boolean levelTimer;
        public int levelTimeCount;

        private Specials() {
        }

        public void UpdateSpecials() {
            if (this.levelTimer) {
                --this.levelTimeCount;
                if (this.levelTimeCount == 0) {
                    UnifiedGameMap.this.DOOM.ExitLevel();
                }
            }
            for (int j = 0; j < this.lastanim; ++j) {
                anim_t anim = this.anims[j];
                for (int i = anim.basepic; i < anim.basepic + anim.numpics; ++i) {
                    int pic = anim.basepic + (UnifiedGameMap.this.DOOM.leveltime / anim.speed + i) % anim.numpics;
                    if (anim.istexture) {
                        UnifiedGameMap.this.DOOM.textureManager.setTextureTranslation(i, pic);
                        continue;
                    }
                    UnifiedGameMap.this.DOOM.textureManager.setFlatTranslation(i, pic);
                }
            }
            for (int i = 0; i < this.numlinespecials; ++i) {
                line_t line = this.linespeciallist[i];
                switch (line.special) {
                    case 48: {
                        UnifiedGameMap.this.DOOM.levelLoader.sides[line.sidenum[0]].textureoffset += 65536;
                    }
                }
            }
            UnifiedGameMap.this.SW.doButtons();
        }

        public void InitPicAnims() {
            Arrays.setAll(this.anims, i -> new anim_t());
            this.lastanim = 0;
            for (int i2 = 0; i2 < UnifiedGameMap.this.animdefs.length - 1; ++i2) {
                anim_t lstanim = this.anims[this.lastanim];
                if (((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].istexture) {
                    if (UnifiedGameMap.this.DOOM.textureManager.CheckTextureNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].startname) == -1) continue;
                    lstanim.picnum = UnifiedGameMap.this.DOOM.textureManager.TextureNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].endname);
                    lstanim.basepic = UnifiedGameMap.this.DOOM.textureManager.TextureNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].startname);
                } else {
                    if (UnifiedGameMap.this.DOOM.wadLoader.CheckNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].startname) == -1) continue;
                    LOGGER.log(Level.FINER, UnifiedGameMap.this.animdefs[i2]::toString);
                    lstanim.picnum = UnifiedGameMap.this.DOOM.textureManager.FlatNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].endname);
                    lstanim.basepic = UnifiedGameMap.this.DOOM.textureManager.FlatNumForName(((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].startname);
                }
                lstanim.istexture = ((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].istexture;
                lstanim.numpics = lstanim.picnum - lstanim.basepic + 1;
                if (lstanim.numpics < 2) {
                    UnifiedGameMap.this.DOOM.doomSystem.Error("P_InitPicAnims: bad cycle from %s to %s", ((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].startname, ((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].endname);
                }
                lstanim.speed = ((UnifiedGameMap)UnifiedGameMap.this).animdefs[i2].speed;
                ++this.lastanim;
            }
        }

        public final void resizeLinesSpecialList() {
            this.linespeciallist = C2JUtils.resize(this.linespeciallist[0], this.linespeciallist, this.linespeciallist.length * 2);
        }
    }
}

