/*
 * Decompiled with CFR 0.152.
 */
package rr;

import doom.player_t;
import i.IDoomSystem;
import m.fixed_t;
import p.pspdef_t;
import rr.BSPVars;
import rr.IMaskedDrawer;
import rr.ISpriteManager;
import rr.IVisSpriteManagement;
import rr.SceneRenderer;
import rr.SegVars;
import rr.TextureManager;
import rr.ViewVars;
import rr.column_t;
import rr.drawfuns.ColFuncs;
import rr.drawfuns.ColVars;
import rr.drawfuns.ColumnFunction;
import rr.drawseg_t;
import rr.patch_t;
import rr.sector_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import rr.vissprite_t;
import v.scale.VideoScale;
import v.tables.LightsAndColors;
import w.IWadLoader;

public abstract class AbstractThings<T, V>
implements IMaskedDrawer<T, V> {
    private static final boolean RANGECHECK = false;
    protected short[] maskedtexturecol;
    protected int pmaskedtexturecol = 0;
    protected int[] spritewidth;
    protected int[] spriteoffset;
    protected int[] spritetopoffset;
    protected int pspritescale;
    protected int pspriteiscale;
    protected int pspritexscale;
    protected int pspriteyscale;
    protected int skyscale;
    protected int rw_scalestep;
    protected int spryscale;
    protected int sprtopscreen;
    protected short[] mfloorclip;
    protected int p_mfloorclip;
    protected short[] mceilingclip;
    protected int p_mceilingclip;
    protected sector_t frontsector;
    protected sector_t backsector;
    protected ColVars<T, V> maskedcvars;
    protected ColumnFunction<T, V> colfunc;
    protected ColFuncs<T, V> colfuncs;
    protected ColFuncs<T, V> colfuncshi;
    protected ColFuncs<T, V> colfuncslow;
    protected final VideoScale vs;
    protected final LightsAndColors<V> colormaps;
    protected final ViewVars view;
    protected final SegVars seg_vars;
    protected final TextureManager<T> TexMan;
    protected final IDoomSystem I;
    protected final ISpriteManager SM;
    protected final BSPVars MyBSP;
    protected final IVisSpriteManagement<V> VIS;
    protected final IWadLoader W;
    protected final vissprite_t<V> avis;
    protected int[] PSpriteSY = new int[]{0, 327680, 983040, 983040, 983040, 983040, 983040, 983040, 983040};
    protected short[] clipbot;
    protected short[] cliptop;

    public AbstractThings(VideoScale vs, SceneRenderer<T, V> R) {
        this.colfuncshi = R.getColFuncsHi();
        this.colfuncslow = R.getColFuncsLow();
        this.colormaps = R.getColorMap();
        this.view = R.getView();
        this.seg_vars = R.getSegVars();
        this.TexMan = R.getTextureManager();
        this.I = R.getDoomSystem();
        this.SM = R.getSpriteManager();
        this.MyBSP = R.getBSPVars();
        this.VIS = R.getVisSpriteManager();
        this.W = R.getWadLoader();
        this.avis = new vissprite_t();
        this.maskedcvars = R.getMaskedDCVars();
        this.vs = vs;
        this.clipbot = new short[vs.getScreenWidth()];
        this.cliptop = new short[vs.getScreenWidth()];
    }

    @Override
    public void cacheSpriteManager(ISpriteManager SM) {
        this.spritewidth = SM.getSpriteWidth();
        this.spriteoffset = SM.getSpriteOffset();
        this.spritetopoffset = SM.getSpriteTopOffset();
    }

    protected void DrawVisSprite(vissprite_t<V> vis) {
        patch_t patch = this.W.CachePatchNum(vis.patch + this.SM.getFirstSpriteLump());
        this.maskedcvars.dc_colormap = vis.colormap;
        if (this.maskedcvars.dc_colormap == null) {
            this.colfunc = this.colfuncs.fuzz;
        } else if ((vis.mobjflags & 0xC000000L) != 0L) {
            this.colfunc = this.colfuncs.trans;
            this.maskedcvars.dc_translation = this.colormaps.getTranslationTable(vis.mobjflags);
        }
        this.maskedcvars.dc_iscale = Math.abs(vis.xiscale) >> this.view.detailshift;
        this.maskedcvars.dc_texturemid = vis.texturemid;
        int frac = vis.startfrac;
        this.spryscale = vis.scale;
        this.sprtopscreen = this.view.centeryfrac - fixed_t.FixedMul(this.maskedcvars.dc_texturemid, this.spryscale);
        this.maskedcvars.dc_texheight = 0;
        this.maskedcvars.dc_x = vis.x1;
        while (this.maskedcvars.dc_x <= vis.x2) {
            int texturecolumn = frac >> 16;
            column_t column = patch.columns[texturecolumn];
            this.DrawMaskedColumn(column);
            ++this.maskedcvars.dc_x;
            frac += vis.xiscale;
        }
        this.colfunc = this.colfuncs.masked;
    }

    protected void RenderMaskedSegRange(drawseg_t ds, int x1, int x2) {
        this.MyBSP.curline = ds.curline;
        this.frontsector = this.MyBSP.curline.frontsector;
        this.backsector = this.MyBSP.curline.backsector;
        int texnum = this.TexMan.getTextureTranslation(this.MyBSP.curline.sidedef.midtexture);
        int lightnum = (this.frontsector.lightlevel >> this.colormaps.lightSegShift()) + this.colormaps.extralight;
        if (this.MyBSP.curline.v1y == this.MyBSP.curline.v2y) {
            --lightnum;
        } else if (this.MyBSP.curline.v1x == this.MyBSP.curline.v2x) {
            ++lightnum;
        }
        this.colormaps.walllights = lightnum >= this.colormaps.lightLevels() ? this.colormaps.scalelight[this.colormaps.lightLevels() - 1] : (lightnum < 0 ? this.colormaps.scalelight[0] : this.colormaps.scalelight[lightnum]);
        this.maskedtexturecol = ds.getMaskedTextureColList();
        this.pmaskedtexturecol = ds.getMaskedTextureColPointer();
        this.rw_scalestep = ds.scalestep;
        this.spryscale = ds.scale1 + (x1 - ds.x1) * this.rw_scalestep;
        this.mfloorclip = ds.getSprBottomClipList();
        this.p_mfloorclip = ds.getSprBottomClipPointer();
        this.mceilingclip = ds.getSprTopClipList();
        this.p_mceilingclip = ds.getSprTopClipPointer();
        if ((this.MyBSP.curline.linedef.flags & 0x10) != 0) {
            this.maskedcvars.dc_texturemid = this.frontsector.floorheight > this.backsector.floorheight ? this.frontsector.floorheight : this.backsector.floorheight;
            this.maskedcvars.dc_texturemid = this.maskedcvars.dc_texturemid + this.TexMan.getTextureheight(texnum) - this.view.z;
        } else {
            this.maskedcvars.dc_texturemid = this.frontsector.ceilingheight < this.backsector.ceilingheight ? this.frontsector.ceilingheight : this.backsector.ceilingheight;
            this.maskedcvars.dc_texturemid -= this.view.z;
        }
        this.maskedcvars.dc_texturemid += this.MyBSP.curline.sidedef.rowoffset;
        if (this.colormaps.fixedcolormap != null) {
            this.maskedcvars.dc_colormap = this.colormaps.fixedcolormap;
        }
        this.maskedcvars.dc_texheight = this.TexMan.getTextureheight(texnum) >> 16;
        this.maskedcvars.dc_x = x1;
        while (this.maskedcvars.dc_x <= x2) {
            if (this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x] != Short.MAX_VALUE) {
                if (this.colormaps.fixedcolormap == null) {
                    int index = this.spryscale >>> this.colormaps.lightScaleShift();
                    if (index >= this.colormaps.maxLightScale()) {
                        index = this.colormaps.maxLightScale() - 1;
                    }
                    this.maskedcvars.dc_colormap = this.colormaps.walllights[index];
                }
                this.sprtopscreen = this.view.centeryfrac - fixed_t.FixedMul(this.maskedcvars.dc_texturemid, this.spryscale);
                this.maskedcvars.dc_iscale = (int)(0xFFFFFFFFL / (long)this.spryscale);
                column_t data = this.TexMan.GetColumnStruct(texnum, this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x]);
                this.DrawMaskedColumn(data);
                this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x] = Short.MAX_VALUE;
            }
            this.spryscale += this.rw_scalestep;
            ++this.maskedcvars.dc_x;
        }
    }

    protected void DrawPSprite(pspdef_t psp) {
        spritedef_t sprdef = this.SM.getSprite(psp.state.sprite.ordinal());
        spriteframe_t sprframe = sprdef.spriteframes[psp.state.frame & Short.MAX_VALUE];
        int lump = sprframe.lump[0];
        boolean flip = sprframe.flip[0] != 0;
        int tx = fixed_t.FixedMul(psp.sx, this.view.BOBADJUST) - this.view.WEAPONADJUST;
        int x1 = this.view.centerxfrac + fixed_t.FixedMul(tx -= this.spriteoffset[lump], this.pspritescale) >> 16;
        if (x1 > this.view.width) {
            return;
        }
        int x2 = (this.view.centerxfrac + fixed_t.FixedMul(tx += this.spritewidth[lump], this.pspritescale) >> 16) - 1;
        if (x2 < 0) {
            return;
        }
        vissprite_t<V> vis = this.avis;
        vis.mobjflags = 0L;
        vis.texturemid = (100 + this.view.lookdir << 16) + 32768 - (psp.sy - this.spritetopoffset[lump]);
        vis.x1 = x1 < 0 ? 0 : x1;
        vis.x2 = x2 >= this.view.width ? this.view.width - 1 : x2;
        vis.scale = this.pspritescale << this.view.detailshift;
        if (flip) {
            vis.xiscale = -this.pspriteiscale;
            vis.startfrac = this.spritewidth[lump] - 1;
        } else {
            vis.xiscale = this.pspriteiscale;
            vis.startfrac = 0;
        }
        if (vis.x1 > x1) {
            vis.startfrac += vis.xiscale * (vis.x1 - x1);
        }
        vis.patch = lump;
        vis.colormap = this.view.player.powers[2] > 128 || (this.view.player.powers[2] & 8) != 0 ? null : (this.colormaps.fixedcolormap != null ? this.colormaps.fixedcolormap : ((psp.state.frame & 0x8000) != 0 ? this.colormaps.colormaps[0] : this.colormaps.spritelights[this.colormaps.maxLightScale() - 1]));
        this.DrawVisSprite(vis);
    }

    protected final void DrawPlayerSprites() {
        int lightnum = (this.view.player.mo.subsector.sector.lightlevel >> this.colormaps.lightSegShift()) + this.colormaps.extralight;
        this.colormaps.spritelights = lightnum < 0 ? this.colormaps.scalelight[0] : (lightnum >= this.colormaps.lightLevels() ? this.colormaps.scalelight[this.colormaps.lightLevels() - 1] : this.colormaps.scalelight[lightnum]);
        this.mfloorclip = this.view.screenheightarray;
        this.p_mfloorclip = 0;
        this.mceilingclip = this.view.negonearray;
        this.p_mceilingclip = 0;
        for (int i = 0; i < player_t.NUMPSPRITES; ++i) {
            pspdef_t psp = this.view.player.psprites[i];
            if (psp.state == null || psp.state.id == 0) continue;
            this.DrawPSprite(psp);
        }
    }

    protected final void DrawSprite(vissprite_t<V> spr) {
        int x;
        for (x = spr.x1; x <= spr.x2; ++x) {
            this.cliptop[x] = -2;
            this.clipbot[x] = -2;
        }
        for (int ds = this.seg_vars.ds_p - 1; ds >= 0; --ds) {
            int scale;
            int lowscale;
            int r2;
            drawseg_t dss = this.seg_vars.drawsegs[ds];
            if (dss.x1 > spr.x2 || dss.x2 < spr.x1 || dss.silhouette == 0 && dss.nullMaskedTextureCol()) continue;
            int r1 = dss.x1 < spr.x1 ? spr.x1 : dss.x1;
            int n = r2 = dss.x2 > spr.x2 ? spr.x2 : dss.x2;
            if (dss.scale1 > dss.scale2) {
                lowscale = dss.scale2;
                scale = dss.scale1;
            } else {
                lowscale = dss.scale1;
                scale = dss.scale2;
            }
            if (scale < spr.scale || lowscale < spr.scale && dss.curline.PointOnSegSide(spr.gx, spr.gy) == 0) {
                if (dss.nullMaskedTextureCol()) continue;
                this.RenderMaskedSegRange(dss, r1, r2);
                continue;
            }
            int silhouette = dss.silhouette;
            if (spr.gz >= dss.bsilheight) {
                silhouette &= 0xFFFFFFFE;
            }
            if (spr.gzt <= dss.tsilheight) {
                silhouette &= 0xFFFFFFFD;
            }
            if (silhouette == 1) {
                for (x = r1; x <= r2; ++x) {
                    if (this.clipbot[x] != -2) continue;
                    this.clipbot[x] = dss.getSprBottomClip(x);
                }
                continue;
            }
            if (silhouette == 2) {
                for (x = r1; x <= r2; ++x) {
                    if (this.cliptop[x] != -2) continue;
                    this.cliptop[x] = dss.getSprTopClip(x);
                }
                continue;
            }
            if (silhouette != 3) continue;
            for (x = r1; x <= r2; ++x) {
                if (this.clipbot[x] == -2) {
                    this.clipbot[x] = dss.getSprBottomClip(x);
                }
                if (this.cliptop[x] != -2) continue;
                this.cliptop[x] = dss.getSprTopClip(x);
            }
        }
        for (x = spr.x1; x <= spr.x2; ++x) {
            if (this.clipbot[x] == -2) {
                this.clipbot[x] = (short)this.view.height;
            }
            if (this.cliptop[x] != -2) continue;
            this.cliptop[x] = -1;
        }
        this.mfloorclip = this.clipbot;
        this.p_mfloorclip = 0;
        this.mceilingclip = this.cliptop;
        this.p_mceilingclip = 0;
        this.DrawVisSprite(spr);
    }

    @Override
    public void DrawMasked() {
        this.VIS.SortVisSprites();
        this.colfunc = this.colfuncs.masked;
        vissprite_t<V>[] vissprites = this.VIS.getVisSprites();
        int numvissprites = this.VIS.getNumVisSprites();
        for (int i = 0; i < numvissprites; ++i) {
            this.DrawSprite(vissprites[i]);
        }
        for (int ds = this.seg_vars.ds_p - 1; ds >= 0; --ds) {
            drawseg_t dss = this.seg_vars.drawsegs[ds];
            if (dss.nullMaskedTextureCol()) continue;
            this.RenderMaskedSegRange(dss, dss.x1, dss.x2);
        }
        this.colfunc = this.colfuncs.player;
        this.DrawPlayerSprites();
        this.colfunc = this.colfuncs.masked;
    }

    protected final void DrawMaskedColumn(column_t column) {
        int basetexturemid = this.maskedcvars.dc_texturemid;
        this.maskedcvars.dc_source = column.data;
        for (int i = 0; i < column.posts; ++i) {
            this.maskedcvars.dc_source_ofs = column.postofs[i];
            int topscreen = this.sprtopscreen + this.spryscale * column.postdeltas[i];
            int bottomscreen = topscreen + this.spryscale * column.postlen[i];
            this.maskedcvars.dc_yl = topscreen + 65536 - 1 >> 16;
            this.maskedcvars.dc_yh = bottomscreen - 1 >> 16;
            if (this.maskedcvars.dc_yh >= this.mfloorclip[this.p_mfloorclip + this.maskedcvars.dc_x]) {
                this.maskedcvars.dc_yh = this.mfloorclip[this.p_mfloorclip + this.maskedcvars.dc_x] - 1;
            }
            if (this.maskedcvars.dc_yl <= this.mceilingclip[this.p_mceilingclip + this.maskedcvars.dc_x]) {
                this.maskedcvars.dc_yl = this.mceilingclip[this.p_mceilingclip + this.maskedcvars.dc_x] + 1;
            }
            if (this.maskedcvars.dc_yl > this.maskedcvars.dc_yh || this.maskedcvars.dc_yh >= this.maskedcvars.viewheight) continue;
            this.maskedcvars.dc_texturemid = basetexturemid - (column.postdeltas[i] << 16);
            this.maskedcvars.dc_texheight = 0;
            this.completeColumn();
        }
        this.maskedcvars.dc_texturemid = basetexturemid;
    }

    @Override
    public void setPspriteIscale(int i) {
        this.pspriteiscale = i;
    }

    @Override
    public void setPspriteScale(int i) {
        this.pspritescale = i;
    }

    @Override
    public void setDetail(int detailshift) {
        switch (detailshift) {
            case 0: {
                this.colfuncs = this.colfuncshi;
                break;
            }
            case 1: {
                this.colfuncs = this.colfuncslow;
            }
        }
    }
}

