/*
 * Decompiled with CFR 0.152.
 */
package rr;

import data.Tables;
import doom.DoomMain;
import i.IDoomSystem;
import m.fixed_t;
import rr.RendererState;
import rr.SceneRenderer;
import rr.SegVars;
import rr.TextureManager;
import rr.ViewVars;
import rr.Visplanes;
import rr.drawfuns.SpanVars;
import rr.visplane_t;
import v.scale.VideoScale;
import v.tables.LightsAndColors;

public abstract class PlaneDrawer<T, V>
implements RendererState.IPlaneDrawer {
    private static final boolean DEBUG2 = false;
    protected final boolean RANGECHECK = false;
    protected int[] spanstart;
    protected int[] spanstop;
    protected V[] planezlight;
    protected int planeheight;
    protected int[] distscale;
    protected int[] cacheddistance;
    protected int[] cachedxstep;
    protected int[] cachedystep;
    protected final ViewVars view;
    protected final SegVars seg_vars;
    protected final SpanVars<T, V> dsvars;
    protected Visplanes vpvars;
    protected final LightsAndColors<V> colormap;
    protected final TextureManager<T> TexMan;
    protected final IDoomSystem I;
    protected final VideoScale vs;

    protected PlaneDrawer(DoomMain<T, V> DOOM, SceneRenderer<T, V> R) {
        this.view = R.getView();
        this.vpvars = R.getVPVars();
        this.dsvars = R.getDSVars();
        this.seg_vars = R.getSegVars();
        this.colormap = R.getColorMap();
        this.TexMan = R.getTextureManager();
        this.I = R.getDoomSystem();
        this.vs = DOOM.vs;
        this.spanstart = new int[this.vs.getScreenHeight()];
        this.spanstop = new int[this.vs.getScreenHeight()];
        this.distscale = new int[this.vs.getScreenWidth()];
        this.cacheddistance = new int[this.vs.getScreenHeight()];
        this.cachedxstep = new int[this.vs.getScreenHeight()];
        this.cachedystep = new int[this.vs.getScreenHeight()];
        visplane_t.setVideoScale(this.vs);
        this.vpvars.initVisplanes();
    }

    @Override
    public void MapPlane(int y, int x1, int x2) {
        int distance;
        if (this.planeheight != this.vpvars.cachedheight[y]) {
            this.vpvars.cachedheight[y] = this.planeheight;
            distance = this.cacheddistance[y] = fixed_t.FixedMul(this.planeheight, this.vpvars.yslope[y]);
            this.dsvars.ds_xstep = this.cachedxstep[y] = fixed_t.FixedMul(distance, this.vpvars.basexscale);
            this.dsvars.ds_ystep = this.cachedystep[y] = fixed_t.FixedMul(distance, this.vpvars.baseyscale);
        } else {
            distance = this.cacheddistance[y];
            this.dsvars.ds_xstep = this.cachedxstep[y];
            this.dsvars.ds_ystep = this.cachedystep[y];
        }
        int length = fixed_t.FixedMul(distance, this.distscale[x1]);
        int angle = (int)((this.view.angle + this.view.xtoviewangle[x1] & 0xFFFFFFFFL) >>> 19);
        this.dsvars.ds_xfrac = this.view.x + fixed_t.FixedMul(Tables.finecosine[angle], length);
        this.dsvars.ds_yfrac = -this.view.y - fixed_t.FixedMul(Tables.finesine[angle], length);
        if (this.colormap.fixedcolormap != null) {
            this.dsvars.ds_colormap = this.colormap.fixedcolormap;
        } else {
            int index = distance >>> this.colormap.lightZShift();
            if (index >= this.colormap.maxLightZ()) {
                index = this.colormap.maxLightZ() - 1;
            }
            this.dsvars.ds_colormap = this.planezlight[index];
        }
        this.dsvars.ds_y = y;
        this.dsvars.ds_x1 = x1;
        this.dsvars.ds_x2 = x2;
        this.dsvars.spanfunc.invoke();
    }

    protected final void rangeCheck(int x1, int x2, int y) {
        if (x2 < x1 || x1 < 0 || x2 >= this.view.width || y > this.view.height) {
            this.I.Error("%s: %d, %d at %d", this.getClass().getName(), x1, x2, y);
        }
    }

    protected void MakeSpans(int x, int t1, int b1, int t2, int b2) {
        while (t1 < t2 && t1 <= b1) {
            this.MapPlane(t1, this.spanstart[t1], x - 1);
            ++t1;
        }
        while (b1 > b2 && b1 >= t1) {
            this.MapPlane(b1, this.spanstart[b1], x - 1);
            --b1;
        }
        while (t2 < t1 && t2 <= b2) {
            this.spanstart[t2] = x;
            ++t2;
        }
        while (b2 > b1 && b2 >= t2) {
            this.spanstart[b2] = x;
            --b2;
        }
    }

    @Override
    public void InitPlanes() {
    }

    protected final void rangeCheckErrors() {
        if (this.seg_vars.ds_p > this.seg_vars.MAXDRAWSEGS) {
            this.I.Error("R_DrawPlanes: drawsegs overflow (%d)", this.seg_vars.ds_p);
        }
        if (this.vpvars.lastvisplane > this.vpvars.MAXVISPLANES) {
            this.I.Error(" R_DrawPlanes: visplane overflow (%d)", this.vpvars.lastvisplane);
        }
        if (this.vpvars.lastopening > this.vpvars.MAXOPENINGS) {
            this.I.Error("R_DrawPlanes: opening overflow (%d)", this.vpvars.lastopening);
        }
    }

    @Override
    public void DrawPlanes() {
    }

    @Override
    public void sync() {
    }

    @Override
    public int[] getDistScale() {
        return this.distscale;
    }
}

