/*
 * Decompiled with CFR 0.152.
 */
package rr;

import doom.DoomMain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rr.ISpriteManager;
import rr.patch_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import utils.C2JUtils;
import utils.GenericCopy;
import w.lumpinfo_t;

public class SpriteManager<T, V>
implements ISpriteManager {
    public static final int MAX_SPRITE_FRAMES = 29;
    private final DoomMain<T, V> DOOM;
    protected spriteframe_t[] sprtemp = (spriteframe_t[])GenericCopy.malloc(spriteframe_t::new, spriteframe_t[]::new, 29);
    protected int maxframe;
    protected String spritename;
    protected int firstspritelump;
    protected int lastspritelump;
    protected int numspritelumps;
    protected spritedef_t[] sprites;
    protected int numsprites;
    protected int[] spritewidth;
    protected int[] spriteoffset;
    protected int[] spritetopoffset;

    public SpriteManager(DoomMain<T, V> DOOM) {
        this.DOOM = DOOM;
    }

    protected final void InitSpriteDefs(String[] namelist) {
        int i;
        int numentries = this.lastspritelump - this.firstspritelump + 1;
        if (numentries == 0 || namelist == null) {
            return;
        }
        this.numsprites = i = namelist.length;
        this.sprites = (spritedef_t[])GenericCopy.malloc(spritedef_t::new, spritedef_t[]::new, this.numsprites);
        HashMap hash = new HashMap(numentries);
        for (i = numentries - 1; i >= 0; --i) {
            int hashcode = this.SpriteNameHash(this.DOOM.wadLoader.GetLumpInfo((int)(i + this.firstspritelump)).name);
            if (!hash.containsKey(hashcode)) {
                hash.put(hashcode, new ArrayList());
            }
            ((List)hash.get(hashcode)).add(i);
        }
        for (i = 0; i < this.numsprites; ++i) {
            String spritename = namelist[i];
            List list = (List)hash.get(this.SpriteNameHash(spritename));
            if (list == null || list.isEmpty()) continue;
            for (spriteframe_t sprtemp1 : this.sprtemp) {
                C2JUtils.memset(sprtemp1.flip, (byte)-1, sprtemp1.flip.length);
                C2JUtils.memset(sprtemp1.lump, -1, sprtemp1.lump.length);
                sprtemp1.rotate = -1;
            }
            this.maxframe = -1;
            list.forEach(j -> {
                lumpinfo_t lump = this.DOOM.wadLoader.GetLumpInfo(j + this.firstspritelump);
                if (lump.name.substring(0, 4).equalsIgnoreCase(spritename.substring(0, 4))) {
                    int frame = lump.name.charAt(4) - 65;
                    int rotation = lump.name.charAt(5) - 48;
                    if (this.sprtemp[frame].rotate != -1) {
                        // empty if block
                    }
                    this.InstallSpriteLump(j + this.firstspritelump, frame, rotation, false);
                    if (lump.name.length() >= 7) {
                        frame = lump.name.charAt(6) - 65;
                        rotation = lump.name.charAt(7) - 48;
                        this.InstallSpriteLump(j + this.firstspritelump, frame, rotation, true);
                    }
                }
            });
            this.sprites[i].numframes = ++this.maxframe;
            if (this.maxframe == 0) continue;
            block8: for (int frame = 0; frame < this.maxframe; ++frame) {
                switch (this.sprtemp[frame].rotate) {
                    case -1: {
                        this.DOOM.doomSystem.Error("R_InitSprites: No patches found for %s frame %c", namelist[i], frame + 65);
                        continue block8;
                    }
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        for (int rotation = 0; rotation < 8; ++rotation) {
                            if (this.sprtemp[frame].lump[rotation] != -1) continue;
                            this.DOOM.doomSystem.Error("R_InitSprites: Sprite %s frame %c is missing rotations", namelist[i], frame + 65);
                        }
                        continue block8;
                    }
                }
            }
            this.sprites[i].copy(this.sprtemp, this.maxframe);
        }
    }

    @Override
    public void InitSpriteLumps() {
        this.firstspritelump = this.DOOM.wadLoader.GetNumForName("S_START") + 1;
        this.lastspritelump = this.DOOM.wadLoader.GetNumForName("S_END") - 1;
        this.numspritelumps = this.lastspritelump - this.firstspritelump + 1;
        this.spritewidth = new int[this.numspritelumps];
        this.spriteoffset = new int[this.numspritelumps];
        this.spritetopoffset = new int[this.numspritelumps];
        for (int i = 0; i < this.numspritelumps; ++i) {
            if ((i & 0x3F) == 0) {
                System.out.print(".");
            }
            patch_t patch = this.DOOM.wadLoader.CacheLumpNum(this.firstspritelump + i, 101, patch_t.class);
            this.spritewidth[i] = patch.width << 16;
            this.spriteoffset[i] = patch.leftoffset << 16;
            this.spritetopoffset[i] = patch.topoffset << 16;
        }
    }

    public final void InstallSpriteLump(int lump, int frame, int rotation, boolean flipped) {
        if (frame >= 29 || rotation > 8) {
            this.DOOM.doomSystem.Error("R_InstallSpriteLump: Bad frame characters in lump %d", lump);
        }
        if (frame > this.maxframe) {
            this.maxframe = frame;
        }
        if (rotation == 0) {
            for (int r = 0; r < 8; ++r) {
                if (this.sprtemp[frame].lump[r] != -1) continue;
                this.sprtemp[frame].lump[r] = lump - this.firstspritelump;
                this.sprtemp[frame].flip[r] = (byte)(flipped ? 1 : 0);
                this.sprtemp[frame].rotate = 0;
            }
            return;
        }
        if (this.sprtemp[frame].lump[--rotation] == -1) {
            this.sprtemp[frame].lump[rotation] = lump - this.firstspritelump;
            this.sprtemp[frame].flip[rotation] = (byte)(flipped ? 1 : 0);
            this.sprtemp[frame].rotate = 1;
        }
    }

    @Override
    public void InitSprites(String[] namelist) {
        this.InitSpriteDefs(namelist);
    }

    protected final int SpriteNameHash(String ss) {
        return ss.substring(0, 4).hashCode();
    }

    @Override
    public final int getFirstSpriteLump() {
        return this.firstspritelump;
    }

    @Override
    public final int getNumSprites() {
        return this.numsprites;
    }

    @Override
    public final spritedef_t[] getSprites() {
        return this.sprites;
    }

    @Override
    public final spritedef_t getSprite(int index) {
        return this.sprites[index];
    }

    @Override
    public final int[] getSpriteWidth() {
        return this.spritewidth;
    }

    @Override
    public final int[] getSpriteOffset() {
        return this.spriteoffset;
    }

    @Override
    public final int[] getSpriteTopOffset() {
        return this.spritetopoffset;
    }

    @Override
    public final int getSpriteWidth(int index) {
        return this.spritewidth[index];
    }

    @Override
    public final int getSpriteOffset(int index) {
        return this.spriteoffset[index];
    }

    @Override
    public final int getSpriteTopOffset(int index) {
        return this.spritetopoffset[index];
    }
}

