/*
 * Decompiled with CFR 0.152.
 */
package rr;

import doom.DoomMain;
import java.io.IOException;
import rr.RendererState;
import rr.SceneRenderer;
import rr.drawfuns.R_DrawColumnBoom;
import rr.drawfuns.R_DrawColumnBoomLow;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.drawfuns.R_DrawFuzzColumn;
import rr.drawfuns.R_DrawFuzzColumnLow;
import rr.drawfuns.R_DrawSpan;
import rr.drawfuns.R_DrawSpanLow;
import rr.drawfuns.R_DrawTLColumn;
import rr.drawfuns.R_DrawTranslatedColumn;
import rr.drawfuns.R_DrawTranslatedColumnLow;

public abstract class UnifiedRenderer<T, V>
extends RendererState<T, V> {
    public UnifiedRenderer(DoomMain<T, V> DOOM) {
        super(DOOM);
        this.MySegs = new Segs(this);
    }

    public static final class TrueColor
    extends UnifiedRenderer<byte[], int[]> {
        public TrueColor(DoomMain<byte[], int[]> DOOM) {
            super(DOOM);
            int LIGHTLEVELS = this.colormaps.lightLevels();
            int MAXLIGHTSCALE = this.colormaps.maxLightScale();
            int MAXLIGHTZ = this.colormaps.maxLightZ();
            this.colormaps.scalelight = (V[][])new int[LIGHTLEVELS][MAXLIGHTSCALE][];
            this.colormaps.scalelightfixed = (V[])new int[MAXLIGHTSCALE][];
            this.colormaps.zlight = (V[][])new int[LIGHTLEVELS][MAXLIGHTZ][];
            this.completeInit();
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS32 Colormaps: " + ((int[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpan.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }

    public static final class Indexed
    extends UnifiedRenderer<byte[], byte[]> {
        public Indexed(DoomMain<byte[], byte[]> DOOM) {
            super(DOOM);
            int LIGHTLEVELS = this.colormaps.lightLevels();
            int MAXLIGHTSCALE = this.colormaps.maxLightScale();
            int MAXLIGHTZ = this.colormaps.maxLightZ();
            this.colormaps.scalelight = (V[][])new byte[LIGHTLEVELS][MAXLIGHTSCALE][];
            this.colormaps.scalelightfixed = (V[])new byte[MAXLIGHTSCALE][];
            this.colormaps.zlight = (V[][])new byte[LIGHTLEVELS][MAXLIGHTZ][];
            this.completeInit();
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpan.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }

    public static final class HiColor
    extends UnifiedRenderer<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DOOM) {
            super(DOOM);
            int LIGHTLEVELS = this.colormaps.lightLevels();
            int MAXLIGHTSCALE = this.colormaps.maxLightScale();
            int MAXLIGHTZ = this.colormaps.maxLightZ();
            this.colormaps.scalelight = (V[][])new short[LIGHTLEVELS][MAXLIGHTSCALE][];
            this.colormaps.scalelightfixed = (V[])new short[MAXLIGHTSCALE][];
            this.colormaps.zlight = (V[][])new short[LIGHTLEVELS][MAXLIGHTZ][];
            this.completeInit();
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS15 Colormaps: " + ((short[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpan.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTLColumn = new R_DrawTLColumn(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }

    protected final class Segs
    extends RendererState.SegDrawer {
        public Segs(SceneRenderer<?, ?> R) {
            super(UnifiedRenderer.this, R);
        }

        @Override
        protected final void CompleteColumn() {
            UnifiedRenderer.this.colfunc.main.invoke();
        }
    }
}

