/*
 * Decompiled with CFR 0.152.
 */
package rr;

import data.Tables;
import java.util.Arrays;
import m.fixed_t;
import rr.TextureManager;
import rr.ViewVars;
import rr.visplane_t;
import utils.C2JUtils;
import v.scale.VideoScale;

public class Visplanes {
    private static final boolean DEBUG2 = false;
    protected final ViewVars view;
    protected final TextureManager<?> TexMan;
    protected final VideoScale vs;
    public int[] cachedheight;
    public int[] BLANKCACHEDHEIGHT;
    public int basexscale;
    public int baseyscale;
    protected int[] yslope;
    public int MAXVISPLANES = 128;
    public int MAXOPENINGS;
    public int lastvisplane;
    public int floorplane;
    public int ceilingplane;
    public visplane_t[] visplanes = new visplane_t[this.MAXVISPLANES];
    public short[] openings;
    public int lastopening;
    protected int skyscale;

    public Visplanes(VideoScale vs, ViewVars view, TextureManager<?> TexMan) {
        this.vs = vs;
        this.view = view;
        this.TexMan = TexMan;
        this.MAXOPENINGS = vs.getScreenWidth() * 64;
        this.openings = new short[this.MAXOPENINGS];
        this.BLANKCACHEDHEIGHT = new int[vs.getScreenHeight()];
        this.yslope = new int[vs.getScreenHeight()];
    }

    public void initVisplanes() {
        this.cachedheight = new int[this.vs.getScreenHeight()];
        Arrays.setAll(this.visplanes, j -> new visplane_t());
    }

    public int getBaseXScale() {
        return this.basexscale;
    }

    public int getBaseYScale() {
        return this.baseyscale;
    }

    public int getSkyScale() {
        return this.skyscale;
    }

    public void setSkyScale(int i) {
        this.skyscale = i;
    }

    public int getLength() {
        return this.visplanes.length;
    }

    public visplane_t allocate() {
        if (this.lastvisplane == this.visplanes.length) {
            this.resizeVisplanes();
        }
        return this.visplanes[this.lastvisplane++];
    }

    public final void resizeVisplanes() {
        this.visplanes = C2JUtils.resize(this.visplanes[0], this.visplanes, this.visplanes.length * 2);
    }

    public final int FindPlane(int height, int picnum, int lightlevel) {
        int check = 0;
        visplane_t chk = null;
        if (picnum == this.TexMan.getSkyFlatNum()) {
            height = 0;
            lightlevel = 0;
        }
        chk = this.visplanes[0];
        for (check = 0; check < this.lastvisplane; ++check) {
            chk = this.visplanes[check];
            if (height == chk.height && picnum == chk.picnum && lightlevel == chk.lightlevel) break;
        }
        if (check < this.lastvisplane) {
            return check;
        }
        chk = this.allocate();
        chk.height = height;
        chk.picnum = picnum;
        chk.lightlevel = lightlevel;
        chk.minx = this.vs.getScreenWidth();
        chk.maxx = -1;
        chk.clearTop();
        return check;
    }

    public void ClearPlanes() {
        this.lastvisplane = 0;
        this.lastopening = 0;
        System.arraycopy(this.BLANKCACHEDHEIGHT, 0, this.cachedheight, 0, this.BLANKCACHEDHEIGHT.length);
        int angle = Tables.toBAMIndex(this.view.angle - 0x40000000L);
        this.basexscale = fixed_t.FixedDiv(Tables.finecosine[angle], this.view.centerxfrac);
        this.baseyscale = -fixed_t.FixedDiv(Tables.finesine[angle], this.view.centerxfrac);
    }

    public int CheckPlane(int index, int start, int stop) {
        int x;
        int unionh;
        int intrh;
        int unionl;
        int intrl;
        visplane_t pl = this.visplanes[index];
        if (start < pl.minx) {
            intrl = pl.minx;
            unionl = start;
        } else {
            unionl = pl.minx;
            intrl = start;
        }
        if (stop > pl.maxx) {
            intrh = pl.maxx;
            unionh = stop;
        } else {
            unionh = pl.maxx;
            intrh = stop;
        }
        for (x = intrl; x <= intrh && pl.getTop(x) == '\uffff'; ++x) {
        }
        if (x > intrh) {
            pl.minx = unionl;
            pl.maxx = unionh;
            return index;
        }
        visplane_t last = this.allocate();
        last.height = pl.height;
        last.picnum = pl.picnum;
        last.lightlevel = pl.lightlevel;
        pl = last;
        pl.minx = start;
        pl.maxx = stop;
        pl.clearTop();
        return this.lastvisplane - 1;
    }
}

