/*
 * Decompiled with CFR 0.152.
 */
package rr.drawfuns;

import i.IDoomSystem;
import rr.drawfuns.ColVars;
import rr.drawfuns.ColumnFunction;
import v.tables.BlurryTable;

public abstract class DoomColumnFunction<T, V>
implements ColumnFunction<T, V> {
    protected final boolean RANGECHECK = false;
    protected final int SCREENWIDTH;
    protected final int SCREENHEIGHT;
    protected ColVars<T, V> dcvars;
    protected final V screen;
    protected final IDoomSystem I;
    protected final int[] ylookup;
    protected final int[] columnofs;
    protected BlurryTable blurryTable;
    protected int flags;

    public DoomColumnFunction(int sCREENWIDTH, int sCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<T, V> dcvars, V screen, IDoomSystem I) {
        this.SCREENWIDTH = sCREENWIDTH;
        this.SCREENHEIGHT = sCREENHEIGHT;
        this.ylookup = ylookup;
        this.columnofs = columnofs;
        this.dcvars = dcvars;
        this.screen = screen;
        this.I = I;
        this.blurryTable = null;
    }

    public DoomColumnFunction(int sCREENWIDTH, int sCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<T, V> dcvars, V screen, IDoomSystem I, BlurryTable BLURRY_MAP) {
        this.SCREENWIDTH = sCREENWIDTH;
        this.SCREENHEIGHT = sCREENHEIGHT;
        this.ylookup = ylookup;
        this.columnofs = columnofs;
        this.dcvars = dcvars;
        this.screen = screen;
        this.I = I;
        this.blurryTable = BLURRY_MAP;
    }

    protected final void performRangeCheck() {
        if (this.dcvars.dc_x >= this.SCREENWIDTH || this.dcvars.dc_yl < 0 || this.dcvars.dc_yh >= this.SCREENHEIGHT) {
            this.I.Error("R_DrawColumn: %d to %d at %d", this.dcvars.dc_yl, this.dcvars.dc_yh, this.dcvars.dc_x);
        }
    }

    protected final int computeScreenDest() {
        return this.ylookup[this.dcvars.dc_yl] + this.columnofs[this.dcvars.dc_x];
    }

    protected final int blockyDest1() {
        return this.ylookup[this.dcvars.dc_yl] + this.columnofs[this.dcvars.dc_x << 1];
    }

    protected final int blockyDest2() {
        return this.ylookup[this.dcvars.dc_yl] + this.columnofs[(this.dcvars.dc_x << 1) + 1];
    }

    @Override
    public final void invoke(ColVars<T, V> dcvars) {
        this.dcvars = dcvars;
        this.invoke();
    }

    @Override
    public final int getFlags() {
        return this.flags;
    }
}

