/*
 * Decompiled with CFR 0.152.
 */
package rr.drawfuns;

import i.IDoomSystem;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;

public abstract class R_DrawTranslatedColumn<T, V>
extends DoomColumnFunction<T, V> {
    public R_DrawTranslatedColumn(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<T, V> dcvars, V screen, IDoomSystem I) {
        super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        this.flags = 2;
    }

    public static final class TrueColor
    extends R_DrawTranslatedColumn<byte[], int[]> {
        public TrueColor(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], int[]> dcvars, int[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            byte[] dc_source = (byte[])this.dcvars.dc_source;
            int[] dc_colormap = (int[])this.dcvars.dc_colormap;
            byte[] dc_translation = (byte[])this.dcvars.dc_translation;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl;
            if (count < 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            int frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep;
            if (count >= 4) {
                do {
                    ((int[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while ((count -= 4) > 4);
            }
            if (count > 0) {
                do {
                    ((int[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while (count-- != 0);
            }
        }
    }

    public static final class Indexed
    extends R_DrawTranslatedColumn<byte[], byte[]> {
        public Indexed(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], byte[]> dcvars, byte[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            byte[] dc_source = (byte[])this.dcvars.dc_source;
            byte[] dc_colormap = (byte[])this.dcvars.dc_colormap;
            byte[] dc_translation = (byte[])this.dcvars.dc_translation;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl;
            if (count < 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            int frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep;
            if (count >= 4) {
                do {
                    ((byte[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while ((count -= 4) > 4);
            }
            if (count > 0) {
                do {
                    ((byte[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while (count-- != 0);
            }
        }
    }

    public static final class HiColor
    extends R_DrawTranslatedColumn<byte[], short[]> {
        public HiColor(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], short[]> dcvars, short[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            byte[] dc_source = (byte[])this.dcvars.dc_source;
            short[] dc_colormap = (short[])this.dcvars.dc_colormap;
            byte[] dc_translation = (byte[])this.dcvars.dc_translation;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl;
            if (count < 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            int frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep;
            if (count >= 4) {
                do {
                    ((short[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + ((frac += fracstep) >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while ((count -= 4) > 4);
            }
            if (count > 0) {
                do {
                    ((short[])this.screen)[dest] = dc_colormap[0xFF & dc_translation[0xFF & dc_source[dc_source_ofs + (frac >> 16)]]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                } while (count-- != 0);
            }
        }
    }
}

