/*
 * Decompiled with CFR 0.152.
 */
package rr;

import m.BBox;
import m.ISyncLogger;
import m.Settings;
import m.fixed_t;
import mochadoom.Engine;
import p.Resettable;
import utils.C2JUtils;

public class node_t
implements Resettable {
    public int x;
    public int y;
    public int dx;
    public int dy;
    public BBox[] bbox;
    public int[] children;
    private static final boolean OLDDEMO = Engine.getConfig().equals(Settings.line_of_sight, (Object)Settings.LOS.Vanilla);

    public node_t() {
        this.bbox = new BBox[]{new BBox(), new BBox()};
        this.children = new int[2];
    }

    public node_t(int x, int y, int dx, int dy, BBox[] bbox, int[] children) {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.bbox = bbox;
        this.children = children;
    }

    public static int PointOnSide(int x, int y, node_t node) {
        if (node.dx == 0) {
            if (x <= node.x) {
                return node.dy > 0 ? 1 : 0;
            }
            return node.dy < 0 ? 1 : 0;
        }
        if (node.dy == 0) {
            if (y <= node.y) {
                return node.dx < 0 ? 1 : 0;
            }
            return node.dx > 0 ? 1 : 0;
        }
        int dx = x - node.x;
        int dy = y - node.y;
        if (((node.dy ^ node.dx ^ dx ^ dy) & Integer.MIN_VALUE) != 0) {
            if (((node.dy ^ dx) & Integer.MIN_VALUE) != 0) {
                return 1;
            }
            return 0;
        }
        int left = fixed_t.FixedMul(node.dy >> 16, dx);
        int right = fixed_t.FixedMul(dy, node.dx >> 16);
        if (right < left) {
            return 0;
        }
        return 1;
    }

    public int PointOnSide(int x, int y) {
        if (this.dx == 0) {
            if (x <= this.x) {
                return this.dy > 0 ? 1 : 0;
            }
            return this.dy < 0 ? 1 : 0;
        }
        if (this.dy == 0) {
            if (y <= this.y) {
                return this.dx < 0 ? 1 : 0;
            }
            return this.dx > 0 ? 1 : 0;
        }
        int lDx = x - this.x;
        int lDy = y - this.y;
        if (((this.dy ^ this.dx ^ lDx ^ lDy) & Integer.MIN_VALUE) != 0) {
            if (((this.dy ^ lDx) & Integer.MIN_VALUE) != 0) {
                return 1;
            }
            return 0;
        }
        int left = fixed_t.FixedMul(this.dy >> 16, lDx);
        int right = fixed_t.FixedMul(lDy, this.dx >> 16);
        if (right < left) {
            return 0;
        }
        return 1;
    }

    public int DivlineSide(int x, int y) {
        int left;
        int right;
        int n = this.dx == 0 ? (x == this.x ? 2 : (x <= this.x ? C2JUtils.eval(this.dy > 0) : C2JUtils.eval(this.dy < 0))) : (this.dy == 0 ? ((OLDDEMO ? x : y) == this.y ? 2 : (y <= this.y ? C2JUtils.eval(this.dx < 0) : C2JUtils.eval(this.dx > 0))) : (this.dy == 0 ? (y == this.y ? 2 : (y <= this.y ? C2JUtils.eval(this.dx < 0) : C2JUtils.eval(this.dx > 0))) : ((right = (y - this.y >> 16) * (this.dx >> 16)) < (left = (x - this.x >> 16) * (this.dy >> 16)) ? 0 : (right == left ? 2 : 1))));
        return n;
    }

    public int DivlineSide(int x, int y, ISyncLogger SL, boolean sync) {
        int result = this.DivlineSide(x, y);
        if (sync) {
            SL.sync("DLS %d\n", result);
        }
        return result;
    }

    @Override
    public void reset() {
        this.dy = 0;
        this.dx = 0;
        this.y = 0;
        this.x = 0;
        for (int i = 0; i < 2; ++i) {
            this.bbox[i].ClearBox();
        }
        C2JUtils.memset(this.children, 0, this.children.length);
    }
}

