/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import m.fixed_t;
import p.pspdef_t;
import rr.AbstractThings;
import rr.IDetailAware;
import rr.SceneRenderer;
import rr.column_t;
import rr.drawfuns.ColFuncs;
import rr.drawfuns.ColVars;
import rr.drawfuns.R_DrawColumnBoom;
import rr.drawfuns.R_DrawColumnBoomLow;
import rr.drawfuns.R_DrawFuzzColumn;
import rr.drawfuns.R_DrawFuzzColumnLow;
import rr.drawfuns.R_DrawTranslatedColumn;
import rr.drawfuns.R_DrawTranslatedColumnLow;
import rr.drawseg_t;
import rr.patch_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import rr.vissprite_t;
import v.scale.VideoScale;
import v.tables.BlurryTable;

public abstract class MaskedWorker<T, V>
extends AbstractThings<T, V>
implements Runnable,
IDetailAware {
    private static final boolean DEBUG = false;
    private static final boolean RANGECHECK = false;
    protected final CyclicBarrier barrier;
    protected final int id;
    protected final int numthreads;
    protected int startx;
    protected int endx;

    public MaskedWorker(VideoScale vs, SceneRenderer<T, V> R, int id, int numthreads, CyclicBarrier barrier) {
        super(vs, R);
        this.colfuncshi = new ColFuncs();
        this.colfuncslow = new ColFuncs();
        this.maskedcvars = new ColVars();
        this.id = id;
        this.numthreads = numthreads;
        this.barrier = barrier;
    }

    @Override
    public final void completeColumn() {
    }

    @Override
    protected final void DrawVisSprite(vissprite_t<V> vis) {
        int bias = this.startx - vis.x1;
        if (bias < 0) {
            bias = 0;
        }
        int x1 = Math.max(this.startx, vis.x1);
        int x2 = Math.min(this.endx, vis.x2);
        patch_t patch = this.W.CachePatchNum(vis.patch + this.SM.getFirstSpriteLump());
        this.maskedcvars.dc_colormap = vis.colormap;
        if (this.maskedcvars.dc_colormap == null) {
            this.colfunc = this.colfuncs.fuzz;
        } else if ((vis.mobjflags & 0xC000000L) != 0L) {
            this.colfunc = this.colfuncs.trans;
            byte[] translation = this.colormaps.getTranslationTable(vis.mobjflags);
            this.maskedcvars.dc_translation = translation;
        }
        this.maskedcvars.dc_iscale = Math.abs(vis.xiscale) >> this.view.detailshift;
        this.maskedcvars.dc_texturemid = vis.texturemid;
        int frac = vis.startfrac + vis.xiscale * bias;
        this.spryscale = vis.scale;
        this.sprtopscreen = this.view.centeryfrac - fixed_t.FixedMul(this.maskedcvars.dc_texturemid, this.spryscale);
        this.maskedcvars.dc_texheight = 0;
        this.maskedcvars.dc_x = x1;
        while (this.maskedcvars.dc_x <= x2) {
            column_t column;
            int texturecolumn = frac >> 16;
            if (texturecolumn < 0 || texturecolumn >= patch.width) {
                this.I.Error("R_DrawSpriteRange: bad texturecolumn %d vs %d %d %d", texturecolumn, patch.width, x1, x2);
            }
            if ((column = patch.columns[texturecolumn]) == null) {
                System.err.printf("Null column for texturecolumn %d\n", texturecolumn, x1, x2);
            } else {
                this.DrawMaskedColumn(column);
            }
            ++this.maskedcvars.dc_x;
            frac += vis.xiscale;
        }
        this.colfunc = this.colfuncs.masked;
    }

    @Override
    protected final void RenderMaskedSegRange(drawseg_t ds, int x1, int x2) {
        if (ds.x1 > this.endx || ds.x2 < this.startx) {
            return;
        }
        x1 = Math.max(this.startx, x1);
        x2 = Math.min(this.endx, x2);
        int bias = this.startx - ds.x1;
        if (bias < 0) {
            bias = 0;
        }
        this.MyBSP.curline = ds.curline;
        this.frontsector = this.MyBSP.curline.frontsector;
        this.backsector = this.MyBSP.curline.backsector;
        int texnum = this.TexMan.getTextureTranslation(this.MyBSP.curline.sidedef.midtexture);
        int lightnum = (this.frontsector.lightlevel >> this.colormaps.lightSegShift()) + this.colormaps.extralight;
        if (this.MyBSP.curline.v1y == this.MyBSP.curline.v2y) {
            --lightnum;
        } else if (this.MyBSP.curline.v1x == this.MyBSP.curline.v2x) {
            ++lightnum;
        }
        this.colormaps.walllights = lightnum >= this.colormaps.lightLevels() ? this.colormaps.scalelight[this.colormaps.lightLevels() - 1] : (lightnum < 0 ? this.colormaps.scalelight[0] : this.colormaps.scalelight[lightnum]);
        this.maskedtexturecol = ds.getMaskedTextureColList();
        this.pmaskedtexturecol = ds.getMaskedTextureColPointer();
        this.rw_scalestep = ds.scalestep;
        this.spryscale = ds.scale1 + (x1 - ds.x1) * this.rw_scalestep;
        this.mfloorclip = ds.getSprBottomClipList();
        this.p_mfloorclip = ds.getSprBottomClipPointer();
        this.mceilingclip = ds.getSprTopClipList();
        this.p_mceilingclip = ds.getSprTopClipPointer();
        if ((this.MyBSP.curline.linedef.flags & 0x10) != 0) {
            this.maskedcvars.dc_texturemid = this.frontsector.floorheight > this.backsector.floorheight ? this.frontsector.floorheight : this.backsector.floorheight;
            this.maskedcvars.dc_texturemid = this.maskedcvars.dc_texturemid + this.TexMan.getTextureheight(texnum) - this.view.z;
        } else {
            this.maskedcvars.dc_texturemid = this.frontsector.ceilingheight < this.backsector.ceilingheight ? this.frontsector.ceilingheight : this.backsector.ceilingheight;
            this.maskedcvars.dc_texturemid -= this.view.z;
        }
        this.maskedcvars.dc_texturemid += this.MyBSP.curline.sidedef.rowoffset;
        if (this.colormaps.fixedcolormap != null) {
            this.maskedcvars.dc_colormap = this.colormaps.fixedcolormap;
        }
        this.maskedcvars.dc_texheight = this.TexMan.getTextureheight(texnum) >> 16;
        this.maskedcvars.dc_x = x1;
        while (this.maskedcvars.dc_x <= x2) {
            if (this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x] != Short.MAX_VALUE) {
                if (this.colormaps.fixedcolormap == null) {
                    int index = this.spryscale >>> this.colormaps.lightScaleShift();
                    if (index >= this.colormaps.maxLightScale()) {
                        index = this.colormaps.maxLightScale() - 1;
                    }
                    this.maskedcvars.dc_colormap = this.colormaps.walllights[index];
                }
                this.sprtopscreen = this.view.centeryfrac - fixed_t.FixedMul(this.maskedcvars.dc_texturemid, this.spryscale);
                this.maskedcvars.dc_iscale = (int)(0xFFFFFFFFL / (long)this.spryscale);
                column_t data = this.TexMan.GetSmpColumn(texnum, this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x], this.id);
                this.DrawMaskedColumn(data);
                this.maskedtexturecol[this.pmaskedtexturecol + this.maskedcvars.dc_x] = Short.MAX_VALUE;
            }
            this.spryscale += this.rw_scalestep;
            ++this.maskedcvars.dc_x;
        }
    }

    @Override
    protected final void DrawPSprite(pspdef_t psp) {
        spritedef_t sprdef = this.SM.getSprite(psp.state.sprite.ordinal());
        spriteframe_t sprframe = sprdef.spriteframes[psp.state.frame & Short.MAX_VALUE];
        int lump = sprframe.lump[0];
        boolean flip = sprframe.flip[0] != 0;
        int tx = fixed_t.FixedMul(psp.sx, this.view.BOBADJUST) - this.view.WEAPONADJUST;
        int x1 = this.view.centerxfrac + fixed_t.FixedMul(tx -= this.spriteoffset[lump], this.pspritescale) >> 16;
        if (x1 > this.endx) {
            return;
        }
        int x2 = (this.view.centerxfrac + fixed_t.FixedMul(tx += this.spritewidth[lump], this.pspritescale) >> 16) - 1;
        if (x2 < this.startx) {
            return;
        }
        vissprite_t vis = this.avis;
        vis.mobjflags = 0L;
        vis.texturemid = (100 + this.view.lookdir << 16) + 32768 - (psp.sy - this.spritetopoffset[lump]);
        vis.x1 = x1 < this.startx ? this.startx : x1;
        vis.x2 = x2 >= this.endx ? this.endx - 1 : x2;
        vis.scale = this.pspritescale << this.view.detailshift;
        if (flip) {
            vis.xiscale = -this.pspriteiscale;
            vis.startfrac = this.spritewidth[lump] - 1;
        } else {
            vis.xiscale = this.pspriteiscale;
            vis.startfrac = 0;
        }
        if (vis.x1 > x1) {
            vis.startfrac += vis.xiscale * (vis.x1 - x1);
        }
        vis.patch = lump;
        vis.colormap = this.view.player.powers[2] > 128 || (this.view.player.powers[2] & 8) != 0 ? null : (this.colormaps.fixedcolormap != null ? this.colormaps.fixedcolormap : ((psp.state.frame & 0x8000) != 0 ? this.colormaps.colormaps[0] : this.colormaps.spritelights[this.colormaps.maxLightScale() - 1]));
        this.DrawVisSprite(vis);
    }

    @Override
    public void run() {
        this.colfunc = this.colfuncs.masked;
        this.maskedcvars.viewheight = this.view.height;
        this.maskedcvars.centery = this.view.centery;
        this.startx = this.id * this.view.width / this.numthreads;
        this.endx = (this.id + 1) * this.view.width / this.numthreads;
        vissprite_t<V>[] vissprites = this.VIS.getVisSprites();
        int numvissprites = this.VIS.getNumVisSprites();
        for (int i = 0; i < numvissprites; ++i) {
            this.DrawSprite(vissprites[i]);
        }
        for (int ds = this.seg_vars.ds_p - 1; ds >= 0; --ds) {
            drawseg_t dss = this.seg_vars.drawsegs[ds];
            if (dss.x1 > this.endx || dss.x2 < this.startx || dss.nullMaskedTextureCol()) continue;
            this.RenderMaskedSegRange(dss, dss.x1, dss.x2);
        }
        this.colfunc = this.colfuncs.player;
        this.DrawPlayerSprites();
        this.colfunc = this.colfuncs.masked;
        try {
            this.barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public static final class TrueColor
    extends MaskedWorker<byte[], int[]> {
        public TrueColor(VideoScale vs, SceneRenderer<byte[], int[]> R, int id, int[] ylookup, int[] columnofs, int numthreads, int[] screen, CyclicBarrier barrier, BlurryTable BLURRY_MAP) {
            super(vs, R, id, numthreads, barrier);
            this.colfuncshi.main = this.colfuncshi.masked = new R_DrawColumnBoom.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.base = this.colfuncshi.masked;
            this.colfuncslow.masked = new R_DrawColumnBoomLow.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.fuzz = new R_DrawFuzzColumn.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncslow.fuzz = new R_DrawFuzzColumnLow.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncshi.trans = new R_DrawTranslatedColumn.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncslow.trans = new R_DrawTranslatedColumnLow.TrueColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncs = this.colfuncshi;
        }
    }

    public static final class Indexed
    extends MaskedWorker<byte[], byte[]> {
        public Indexed(VideoScale vs, SceneRenderer<byte[], byte[]> R, int id, int[] ylookup, int[] columnofs, int numthreads, byte[] screen, CyclicBarrier barrier, BlurryTable BLURRY_MAP) {
            super(vs, R, id, numthreads, barrier);
            this.colfuncshi.main = this.colfuncshi.masked = new R_DrawColumnBoom.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.base = this.colfuncshi.masked;
            this.colfuncslow.masked = new R_DrawColumnBoomLow.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.fuzz = new R_DrawFuzzColumn.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncslow.fuzz = new R_DrawFuzzColumnLow.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncshi.trans = new R_DrawTranslatedColumn.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncslow.trans = new R_DrawTranslatedColumnLow.Indexed(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncs = this.colfuncshi;
        }
    }

    public static final class HiColor
    extends MaskedWorker<byte[], short[]> {
        public HiColor(VideoScale vs, SceneRenderer<byte[], short[]> R, int id, int[] ylookup, int[] columnofs, int numthreads, short[] screen, CyclicBarrier barrier, BlurryTable BLURRY_MAP) {
            super(vs, R, id, numthreads, barrier);
            this.colfuncshi.main = this.colfuncshi.masked = new R_DrawColumnBoom.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.base = this.colfuncshi.masked;
            this.colfuncslow.masked = new R_DrawColumnBoomLow.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncshi.fuzz = new R_DrawFuzzColumn.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncslow.fuzz = new R_DrawFuzzColumnLow.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I, BLURRY_MAP);
            this.colfuncshi.trans = new R_DrawTranslatedColumn.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncslow.trans = new R_DrawTranslatedColumnLow.HiColor(vs.getScreenWidth(), vs.getScreenHeight(), ylookup, columnofs, this.maskedcvars, screen, this.I);
            this.colfuncs = this.colfuncshi;
        }
    }
}

