/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import doom.DoomMain;
import doom.player_t;
import java.io.IOException;
import rr.SimpleThings;
import rr.drawfuns.ColVars;
import rr.drawfuns.R_DrawColumnBoom;
import rr.drawfuns.R_DrawColumnBoomLow;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.drawfuns.R_DrawFuzzColumn;
import rr.drawfuns.R_DrawFuzzColumnLow;
import rr.drawfuns.R_DrawSpanLow;
import rr.drawfuns.R_DrawSpanUnrolled;
import rr.drawfuns.R_DrawTLColumn;
import rr.drawfuns.R_DrawTranslatedColumn;
import rr.drawfuns.R_DrawTranslatedColumnLow;
import rr.parallel.AbstractParallelRenderer;
import rr.parallel.MaskedWorker;
import rr.parallel.RenderWallExecutor;

public abstract class ParallelRenderer<T, V>
extends AbstractParallelRenderer<T, V> {
    public ParallelRenderer(DoomMain<T, V> DM, int wallthread, int floorthreads, int nummaskedthreads) {
        super(DM, wallthread, floorthreads, nummaskedthreads);
        AbstractParallelRenderer.ParallelSegs tmp = new AbstractParallelRenderer.ParallelSegs(this);
        this.MySegs = tmp;
        this.RWIs = tmp;
        this.MyThings = new SimpleThings(DM.vs, this);
    }

    public ParallelRenderer(DoomMain<T, V> DM) {
        this(DM, 1, 1, 2);
    }

    @Override
    public void RenderPlayerView(player_t player) {
        this.SetupFrame(player);
        this.MyBSP.ClearClipSegs();
        this.seg_vars.ClearDrawSegs();
        this.vp_vars.ClearPlanes();
        this.MySegs.ClearClips();
        this.VIS.ClearSprites();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyBSP.RenderBSPNode(this.DOOM.levelLoader.numnodes - 1);
        this.MySegs.CompleteRendering();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyPlanes.DrawPlanes();
        this.DOOM.gameNetworking.NetUpdate();
        this.MySegs.sync();
        this.MyPlanes.sync();
        this.MyThings.DrawMasked();
        this.DOOM.gameNetworking.NetUpdate();
    }

    @Override
    protected void InitParallelStuff() {
        if (this.RWIs != null) {
            ColVars<T, V>[] RWI2 = this.RWIs.getRWI();
            RenderWallExecutor<T, V>[] RWIExec = this.InitRWIExecutors(this.NUMWALLTHREADS, RWI2);
            this.RWIs.setExecutors(RWIExec);
            for (int i = 0; i < this.NUMWALLTHREADS; ++i) {
                this.detailaware.add(RWIExec[i]);
            }
        }
        this.TexMan.setSMPVars(this.NUMMASKEDTHREADS);
    }

    protected abstract void InitMaskedWorkers();

    public static final class TrueColor
    extends ParallelRenderer<byte[], int[]> {
        public TrueColor(DoomMain<byte[], int[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new int[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new int[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new int[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS15 Colormaps: " + ((int[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void InitMaskedWorkers() {
            this.maskedworkers = new MaskedWorker[this.NUMMASKEDTHREADS];
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.TrueColor(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (int[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        public RenderWallExecutor<byte[], int[]>[] InitRWIExecutors(int num, ColVars<byte[], int[]>[] RWI2) {
            RenderWallExecutor.TrueColor[] tmp = new RenderWallExecutor.TrueColor[num];
            for (int i = 0; i < num; ++i) {
                tmp[i] = new RenderWallExecutor.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.columnofs, this.ylookup, (int[])this.screen, RWI2, this.drawsegsbarrier);
            }
            return tmp;
        }
    }

    public static final class HiColor
    extends ParallelRenderer<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new short[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new short[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new short[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void InitMaskedWorkers() {
            this.maskedworkers = new MaskedWorker[this.NUMMASKEDTHREADS];
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.HiColor(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (short[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS15 Colormaps: " + ((short[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTLColumn = new R_DrawTLColumn(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }

        @Override
        public RenderWallExecutor<byte[], short[]>[] InitRWIExecutors(int num, ColVars<byte[], short[]>[] RWI2) {
            RenderWallExecutor.HiColor[] tmp = new RenderWallExecutor.HiColor[num];
            for (int i = 0; i < num; ++i) {
                tmp[i] = new RenderWallExecutor.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.columnofs, this.ylookup, (short[])this.screen, RWI2, this.drawsegsbarrier);
            }
            return tmp;
        }
    }

    public static final class Indexed
    extends ParallelRenderer<byte[], byte[]> {
        public Indexed(DoomMain<byte[], byte[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new byte[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new byte[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new byte[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }

        @Override
        protected void completeInit() {
            super.completeInit();
            this.InitMaskedWorkers();
        }

        @Override
        protected void InitMaskedWorkers() {
            this.maskedworkers = new MaskedWorker[this.NUMMASKEDTHREADS];
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.Indexed(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (byte[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        public RenderWallExecutor<byte[], byte[]>[] InitRWIExecutors(int num, ColVars<byte[], byte[]>[] RWI2) {
            RenderWallExecutor.Indexed[] tmp = new RenderWallExecutor.Indexed[num];
            for (int i = 0; i < num; ++i) {
                tmp[i] = new RenderWallExecutor.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.columnofs, this.ylookup, (byte[])this.screen, RWI2, this.drawsegsbarrier);
            }
            return tmp;
        }
    }
}

