/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import doom.DoomMain;
import doom.player_t;
import java.io.IOException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import rr.drawfuns.R_DrawColumnBoom;
import rr.drawfuns.R_DrawColumnBoomLow;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.drawfuns.R_DrawFuzzColumn;
import rr.drawfuns.R_DrawFuzzColumnLow;
import rr.drawfuns.R_DrawSpanLow;
import rr.drawfuns.R_DrawSpanUnrolled;
import rr.drawfuns.R_DrawTLColumn;
import rr.drawfuns.R_DrawTranslatedColumn;
import rr.drawfuns.R_DrawTranslatedColumnLow;
import rr.parallel.AbstractParallelRenderer;
import rr.parallel.MaskedWorker;
import rr.parallel.ParallelThings2;
import rr.parallel.RenderSegExecutor;
import rr.parallel.RenderSegInstruction;
import rr.parallel.VisplaneWorker2;
import utils.GenericCopy;

public abstract class ParallelRenderer2<T, V>
extends AbstractParallelRenderer<T, V> {
    public ParallelRenderer2(DoomMain<T, V> DOOM, int wallthread, int floorthreads, int nummaskedthreads) {
        super(DOOM, wallthread, floorthreads, nummaskedthreads);
        System.out.println("Parallel Renderer 2 (Seg-based)");
        this.MySegs = new AbstractParallelRenderer.ParallelSegs2(this);
        this.MyPlanes = new AbstractParallelRenderer.ParallelPlanes<T, V>(DOOM, this);
        this.MyThings = new ParallelThings2(DOOM.vs, this);
        this.maskedworkers = new MaskedWorker[this.NUMMASKEDTHREADS];
        ((ParallelThings2)this.MyThings).maskedworkers = this.maskedworkers;
        this.InitMaskedWorkers();
        ((AbstractParallelRenderer.ParallelSegs2)this.MySegs).RSI = (RenderSegInstruction[])GenericCopy.malloc(RenderSegInstruction::new, RenderSegInstruction[]::new, 96);
    }

    @Override
    protected void InitParallelStuff() {
        ((AbstractParallelRenderer.ParallelSegs2)this.MySegs).RSIExec = new RenderSegExecutor[this.NUMWALLTHREADS];
        this.tp = Executors.newFixedThreadPool(this.NUMWALLTHREADS + this.NUMFLOORTHREADS);
        this.visplanebarrier = new CyclicBarrier(this.NUMFLOORTHREADS + this.NUMWALLTHREADS + 1);
        this.vpw = new VisplaneWorker2[this.NUMFLOORTHREADS];
        this.InitRSISubsystem();
        this.maskedbarrier = new CyclicBarrier(this.NUMMASKEDTHREADS + 1);
        this.TexMan.setSMPVars(this.NUMMASKEDTHREADS);
    }

    @Override
    public void RenderPlayerView(player_t player) {
        this.SetupFrame(player);
        this.MyBSP.ClearClipSegs();
        this.seg_vars.ClearDrawSegs();
        this.vp_vars.ClearPlanes();
        this.MySegs.ClearClips();
        this.VIS.ClearSprites();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyBSP.RenderBSPNode(this.DOOM.levelLoader.numnodes - 1);
        ((AbstractParallelRenderer.ParallelSegs2)this.MySegs).RenderRSIPipeline();
        this.MySegs.CompleteRendering();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyPlanes.DrawPlanes();
        try {
            this.visplanebarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            e.printStackTrace();
        }
        this.DOOM.gameNetworking.NetUpdate();
        this.MySegs.sync();
        this.MyPlanes.sync();
        this.MyThings.DrawMasked();
    }

    protected abstract void InitRSISubsystem();

    protected abstract void InitMaskedWorkers();

    public static final class TrueColor
    extends ParallelRenderer2<byte[], int[]> {
        public TrueColor(DoomMain<byte[], int[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new int[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new int[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new int[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void InitRSISubsystem() {
            int i;
            AbstractParallelRenderer.ParallelSegs2 parallelSegs = (AbstractParallelRenderer.ParallelSegs2)this.MySegs;
            for (i = 0; i < this.NUMWALLTHREADS; ++i) {
                parallelSegs.RSIExec[i] = new RenderSegExecutor.TrueColor(this.DOOM, i, (int[])this.screen, this.TexMan, parallelSegs.RSI, this.MySegs.getBLANKCEILINGCLIP(), this.MySegs.getBLANKFLOORCLIP(), this.MySegs.getCeilingClip(), this.MySegs.getFloorClip(), this.columnofs, this.view.xtoviewangle, this.ylookup, this.vp_vars.visplanes, this.visplanebarrier, this.colormaps);
                parallelSegs.RSIExec[i].setScreenRange(i * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS), (i + 1) * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS));
                this.detailaware.add(parallelSegs.RSIExec[i]);
            }
            for (i = 0; i < this.NUMFLOORTHREADS; ++i) {
                VisplaneWorker2.TrueColor w = new VisplaneWorker2.TrueColor(this.DOOM, this, i, this.columnofs, this.ylookup, (int[])this.screen, this.visplanebarrier, this.NUMFLOORTHREADS);
                this.vpw[i] = w;
                this.detailaware.add(w);
            }
        }

        @Override
        protected void InitMaskedWorkers() {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.TrueColor(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (int[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS15 Colormaps: " + ((int[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.TrueColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (int[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }

    public static final class HiColor
    extends ParallelRenderer2<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new short[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new short[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new short[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void InitRSISubsystem() {
            int i;
            AbstractParallelRenderer.ParallelSegs2 parallelSegs = (AbstractParallelRenderer.ParallelSegs2)this.MySegs;
            for (i = 0; i < this.NUMWALLTHREADS; ++i) {
                parallelSegs.RSIExec[i] = new RenderSegExecutor.HiColor(this.DOOM, i, (short[])this.screen, this.TexMan, parallelSegs.RSI, this.MySegs.getBLANKCEILINGCLIP(), this.MySegs.getBLANKFLOORCLIP(), this.MySegs.getCeilingClip(), this.MySegs.getFloorClip(), this.columnofs, this.view.xtoviewangle, this.ylookup, this.vp_vars.visplanes, this.visplanebarrier, this.colormaps);
                parallelSegs.RSIExec[i].setScreenRange(i * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS), (i + 1) * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS));
                this.detailaware.add(parallelSegs.RSIExec[i]);
            }
            for (i = 0; i < this.NUMFLOORTHREADS; ++i) {
                VisplaneWorker2.HiColor w = new VisplaneWorker2.HiColor(this.DOOM, this, i, this.columnofs, this.ylookup, (short[])this.screen, this.visplanebarrier, this.NUMFLOORTHREADS);
                this.vpw[i] = w;
                this.detailaware.add(w);
            }
        }

        @Override
        protected void InitMaskedWorkers() {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.HiColor(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (short[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            System.out.println("COLORS15 Colormaps: " + ((short[][])this.colormaps.colormaps).length);
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawTLColumn = new R_DrawTLColumn(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.HiColor(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (short[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }

    public static final class Indexed
    extends ParallelRenderer2<byte[], byte[]> {
        public Indexed(DoomMain<byte[], byte[]> DM, int wallthread, int floorthreads, int nummaskedthreads) {
            super(DM, wallthread, floorthreads, nummaskedthreads);
            this.colormaps.scalelight = (V[][])new byte[this.colormaps.lightLevels()][this.colormaps.maxLightScale()][];
            this.colormaps.scalelightfixed = (V[])new byte[this.colormaps.maxLightScale()][];
            this.colormaps.zlight = (V[][])new byte[this.colormaps.lightLevels()][this.colormaps.maxLightZ()][];
            this.completeInit();
        }

        @Override
        protected void InitRSISubsystem() {
            int i;
            AbstractParallelRenderer.ParallelSegs2 parallelSegs = (AbstractParallelRenderer.ParallelSegs2)this.MySegs;
            for (i = 0; i < this.NUMWALLTHREADS; ++i) {
                parallelSegs.RSIExec[i] = new RenderSegExecutor.Indexed(this.DOOM, i, (byte[])this.screen, this.TexMan, parallelSegs.RSI, this.MySegs.getBLANKCEILINGCLIP(), this.MySegs.getBLANKFLOORCLIP(), this.MySegs.getCeilingClip(), this.MySegs.getFloorClip(), this.columnofs, this.view.xtoviewangle, this.ylookup, this.vp_vars.visplanes, this.visplanebarrier, this.colormaps);
                parallelSegs.RSIExec[i].setScreenRange(i * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS), (i + 1) * (this.DOOM.vs.getScreenWidth() / this.NUMWALLTHREADS));
                this.detailaware.add(parallelSegs.RSIExec[i]);
            }
            for (i = 0; i < this.NUMFLOORTHREADS; ++i) {
                VisplaneWorker2.Indexed w = new VisplaneWorker2.Indexed(this.DOOM, this, i, this.columnofs, this.ylookup, (byte[])this.screen, this.visplanebarrier, this.NUMFLOORTHREADS);
                this.vpw[i] = w;
                this.detailaware.add(w);
            }
        }

        @Override
        protected void InitMaskedWorkers() {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.maskedworkers[i] = new MaskedWorker.Indexed(this.DOOM.vs, this, i, this.ylookup, this.columnofs, this.NUMMASKEDTHREADS, (byte[])this.screen, this.maskedbarrier, this.BLURRY_MAP);
                this.detailaware.add(this.maskedworkers[i]);
                this.maskedworkers[i].cacheSpriteManager(this.DOOM.spriteManager);
            }
        }

        @Override
        protected void InitColormaps() throws IOException {
            this.colormaps.colormaps = this.DOOM.graphicSystem.getColorMap();
            this.BLURRY_MAP = this.DOOM.graphicSystem.getBlurryTable();
        }

        @Override
        protected void R_InitDrawingFunctions() {
            this.DrawSpan = new R_DrawSpanUnrolled.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawSpanLow = new R_DrawSpanLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dsvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumn = new R_DrawTranslatedColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawTranslatedColumnLow = new R_DrawTranslatedColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawFuzzColumn = new R_DrawFuzzColumn.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawFuzzColumnLow = new R_DrawFuzzColumnLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem, this.BLURRY_MAP);
            this.DrawColumn = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.dcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMasked = new R_DrawColumnBoom.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnMaskedLow = new R_DrawColumnBoomLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.maskedcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnPlayer = this.DrawColumnMasked;
            this.DrawColumnSkies = new R_DrawColumnBoomOpt.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            this.DrawColumnSkiesLow = new R_DrawColumnBoomOptLow.Indexed(this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight(), this.ylookup, this.columnofs, this.skydcvars, (byte[])this.screen, this.DOOM.doomSystem);
            super.R_InitDrawingFunctions();
        }
    }
}

