/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import rr.IMaskedDrawer;
import rr.ISpriteManager;
import rr.IVisSpriteManagement;
import rr.SceneRenderer;
import rr.parallel.MaskedWorker;
import v.scale.VideoScale;

public final class ParallelThings2<T, V>
implements IMaskedDrawer<T, V> {
    MaskedWorker<T, V>[] maskedworkers;
    CyclicBarrier maskedbarrier;
    Executor tp;
    protected final IVisSpriteManagement<V> VIS;
    protected final VideoScale vs;

    public ParallelThings2(VideoScale vs, SceneRenderer<T, V> R) {
        this.VIS = R.getVisSpriteManager();
        this.vs = vs;
    }

    @Override
    public void DrawMasked() {
        this.VIS.SortVisSprites();
        for (int i = 0; i < this.maskedworkers.length; ++i) {
            this.tp.execute(this.maskedworkers[i]);
        }
        try {
            this.maskedbarrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeColumn() {
    }

    @Override
    public void setPspriteScale(int scale) {
        for (int i = 0; i < this.maskedworkers.length; ++i) {
            this.maskedworkers[i].setPspriteScale(scale);
        }
    }

    @Override
    public void setPspriteIscale(int scale) {
        for (int i = 0; i < this.maskedworkers.length; ++i) {
            this.maskedworkers[i].setPspriteIscale(scale);
        }
    }

    @Override
    public void setDetail(int detailshift) {
        for (int i = 0; i < this.maskedworkers.length; ++i) {
            this.maskedworkers[i].setDetail(detailshift);
        }
    }

    @Override
    public void cacheSpriteManager(ISpriteManager SM) {
        for (int i = 0; i < this.maskedworkers.length; ++i) {
            this.maskedworkers[i].cacheSpriteManager(SM);
        }
    }
}

