/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import i.IDoomSystem;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import rr.IDetailAware;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.R_DrawColumnBoom;
import rr.drawfuns.R_DrawColumnBoomLow;
import rr.drawfuns.R_DrawFuzzColumn;
import rr.drawfuns.R_DrawFuzzColumnLow;
import rr.drawfuns.R_DrawTranslatedColumn;
import rr.drawfuns.R_DrawTranslatedColumnLow;
import v.tables.BlurryTable;

public abstract class RenderMaskedExecutor<T, V>
implements Runnable,
IDetailAware {
    protected CyclicBarrier barrier;
    protected ColVars<T, V>[] RMI;
    protected int rmiend;
    protected boolean lowdetail = false;
    protected int start;
    protected int end;
    protected DoomColumnFunction<T, V> colfunchi;
    protected DoomColumnFunction<T, V> colfunclow;
    protected DoomColumnFunction<T, V> fuzzfunchi;
    protected DoomColumnFunction<T, V> fuzzfunclow;
    protected DoomColumnFunction<T, V> transfunchi;
    protected DoomColumnFunction<T, V> transfunclow;
    protected DoomColumnFunction<T, V> colfunc;
    protected final int SCREENWIDTH;
    protected final int SCREENHEIGHT;

    public RenderMaskedExecutor(int SCREENWIDTH, int SCREENHEIGHT, ColVars<T, V>[] RMI, CyclicBarrier barrier) {
        this.RMI = RMI;
        this.barrier = barrier;
        this.SCREENWIDTH = SCREENWIDTH;
        this.SCREENHEIGHT = SCREENHEIGHT;
    }

    public void setRange(int start, int end) {
        this.end = end;
        this.start = start;
    }

    @Override
    public void setDetail(int detailshift) {
        this.lowdetail = detailshift != 0;
    }

    @Override
    public void run() {
        int dc_flags = 0;
        for (int i = 0; i < this.rmiend; ++i) {
            if (this.RMI[i].dc_x < this.start || this.RMI[i].dc_x > this.end) continue;
            dc_flags = this.RMI[i].dc_flags;
            this.colfunc = this.lowdetail ? ((dc_flags & 1) != 0 ? this.fuzzfunclow : ((dc_flags & 2) != 0 ? this.transfunclow : this.colfunclow)) : ((dc_flags & 1) != 0 ? this.fuzzfunchi : ((dc_flags & 2) != 0 ? this.transfunchi : this.colfunchi));
            this.colfunc.invoke(this.RMI[i]);
        }
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public void setRMIEnd(int rmiend) {
        this.rmiend = rmiend;
    }

    public void updateRMI(ColVars<T, V>[] RMI) {
        this.RMI = RMI;
    }

    public static final class TrueColor
    extends RenderMaskedExecutor<byte[], int[]> {
        public TrueColor(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, int[] screen, ColVars<byte[], int[]>[] RMI, CyclicBarrier barrier, IDoomSystem I, BlurryTable BLURRY_MAP) {
            super(SCREENWIDTH, SCREENHEIGHT, RMI, barrier);
            this.colfunc = new R_DrawColumnBoom.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.colfunclow = new R_DrawColumnBoomLow.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.fuzzfunchi = new R_DrawFuzzColumn.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.fuzzfunclow = new R_DrawFuzzColumnLow.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.transfunchi = new R_DrawTranslatedColumn.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.transfunclow = new R_DrawTranslatedColumnLow.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
        }
    }

    public static final class Indexed
    extends RenderMaskedExecutor<byte[], byte[]> {
        public Indexed(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, byte[] screen, ColVars<byte[], byte[]>[] RMI, CyclicBarrier barrier, IDoomSystem I, BlurryTable BLURRY_MAP) {
            super(SCREENWIDTH, SCREENHEIGHT, RMI, barrier);
            this.colfunc = new R_DrawColumnBoom.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.colfunclow = new R_DrawColumnBoomLow.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.fuzzfunchi = new R_DrawFuzzColumn.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.fuzzfunclow = new R_DrawFuzzColumnLow.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.transfunchi = new R_DrawTranslatedColumn.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.transfunclow = new R_DrawTranslatedColumnLow.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
        }
    }

    public static final class HiColor
    extends RenderMaskedExecutor<byte[], short[]> {
        public HiColor(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, short[] screen, ColVars<byte[], short[]>[] RMI, CyclicBarrier barrier, IDoomSystem I, BlurryTable BLURRY_MAP) {
            super(SCREENWIDTH, SCREENHEIGHT, RMI, barrier);
            this.colfunc = new R_DrawColumnBoom.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.colfunclow = new R_DrawColumnBoomLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.fuzzfunchi = new R_DrawFuzzColumn.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.fuzzfunclow = new R_DrawFuzzColumnLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I, BLURRY_MAP);
            this.transfunchi = new R_DrawTranslatedColumn.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
            this.transfunclow = new R_DrawTranslatedColumnLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, I);
        }
    }
}

