/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import data.Tables;
import doom.DoomMain;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import m.fixed_t;
import rr.IDetailAware;
import rr.TextureManager;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.parallel.RenderSegInstruction;
import rr.visplane_t;
import v.tables.LightsAndColors;

public abstract class RenderSegExecutor<T, V>
implements Runnable,
IDetailAware {
    protected int rw_start;
    protected int rw_end;
    protected int rsiend;
    protected final LightsAndColors<V> colormaps;
    protected final TextureManager<T> TexMan;
    protected final CyclicBarrier barrier;
    protected RenderSegInstruction<V>[] RSI;
    protected final long[] xtoviewangle;
    protected final short[] ceilingclip;
    protected final short[] floorclip;
    protected final short[] BLANKFLOORCLIP;
    protected final short[] BLANKCEILINGCLIP;
    protected static final int HEIGHTBITS = 12;
    protected static final int HEIGHTUNIT = 4096;
    protected final int id;
    protected DoomColumnFunction<T, V> colfunchi;
    protected DoomColumnFunction<T, V> colfunclow;
    protected DoomColumnFunction<T, V> colfunc;
    protected ColVars<T, V> dcvars;
    protected final DoomMain<T, V> DOOM;

    public RenderSegExecutor(DoomMain<T, V> DOOM, int id, V screen, TextureManager<T> texman, RenderSegInstruction<V>[] RSI, short[] BLANKCEILINGCLIP, short[] BLANKFLOORCLIP, short[] ceilingclip, short[] floorclip, int[] columnofs, long[] xtoviewangle, int[] ylookup, visplane_t[] visplanes, CyclicBarrier barrier, LightsAndColors<V> colormaps) {
        this.id = id;
        this.TexMan = texman;
        this.RSI = RSI;
        this.barrier = barrier;
        this.ceilingclip = ceilingclip;
        this.floorclip = floorclip;
        this.xtoviewangle = xtoviewangle;
        this.BLANKCEILINGCLIP = BLANKCEILINGCLIP;
        this.BLANKFLOORCLIP = BLANKFLOORCLIP;
        this.colormaps = colormaps;
        this.DOOM = DOOM;
    }

    protected final void ProcessRSI(RenderSegInstruction<V> rsi, int startx, int endx, boolean contained) {
        int pixhighstep = rsi.pixhighstep;
        int pixlowstep = rsi.pixlowstep;
        int bottomstep = rsi.bottomstep;
        int rw_scalestep = rsi.rw_scalestep;
        int topstep = rsi.topstep;
        int texturecolumn = 0;
        int bias = contained ? 0 : startx - rsi.rw_x;
        int rw_scale = rsi.rw_scale + bias * rw_scalestep;
        int topfrac = rsi.topfrac + bias * topstep;
        int bottomfrac = rsi.bottomfrac + bias * bottomstep;
        int pixlow = rsi.pixlow + bias * pixlowstep;
        int pixhigh = rsi.pixhigh + bias * pixhighstep;
        for (int rw_x = startx; rw_x < endx; ++rw_x) {
            int yh;
            int yl = topfrac + 4096 - 1 >> 12;
            if (yl < this.ceilingclip[rw_x] + 1) {
                yl = this.ceilingclip[rw_x] + 1;
            }
            if ((yh = bottomfrac >> 12) >= this.floorclip[rw_x]) {
                yh = this.floorclip[rw_x] - 1;
            }
            if (rsi.segtextured) {
                int angle = Tables.toBAMIndex(rsi.rw_centerangle + (long)((int)this.xtoviewangle[rw_x]));
                texturecolumn = rsi.rw_offset - fixed_t.FixedMul(Tables.finetangent[angle], rsi.rw_distance);
                texturecolumn >>= 16;
                int index = rw_scale >> this.colormaps.lightScaleShift();
                if (index >= this.colormaps.maxLightScale()) {
                    index = this.colormaps.maxLightScale() - 1;
                }
                this.dcvars.dc_colormap = rsi.walllights[index];
                this.dcvars.dc_x = rw_x;
                this.dcvars.dc_iscale = (int)(0xFFFFFFFFL / (long)rw_scale);
            }
            if (rsi.midtexture != 0) {
                this.dcvars.dc_yl = yl;
                this.dcvars.dc_yh = yh;
                this.dcvars.dc_texheight = this.TexMan.getTextureheight(rsi.midtexture) >> 16;
                this.dcvars.dc_texturemid = rsi.rw_midtexturemid;
                this.dcvars.dc_source = this.TexMan.GetCachedColumn(rsi.midtexture, texturecolumn);
                this.dcvars.dc_source_ofs = 0;
                this.colfunc.invoke();
                this.ceilingclip[rw_x] = (short)rsi.viewheight;
                this.floorclip[rw_x] = -1;
            } else {
                int mid;
                if (rsi.toptexture != 0) {
                    mid = pixhigh >> 12;
                    pixhigh += pixhighstep;
                    if (mid >= this.floorclip[rw_x]) {
                        mid = this.floorclip[rw_x] - 1;
                    }
                    if (mid >= yl) {
                        this.dcvars.dc_yl = yl;
                        this.dcvars.dc_yh = mid;
                        this.dcvars.dc_texturemid = rsi.rw_toptexturemid;
                        this.dcvars.dc_texheight = this.TexMan.getTextureheight(rsi.toptexture) >> 16;
                        this.dcvars.dc_source = this.TexMan.GetCachedColumn(rsi.toptexture, texturecolumn);
                        this.colfunc.invoke();
                        this.ceilingclip[rw_x] = (short)mid;
                    } else {
                        this.ceilingclip[rw_x] = (short)(yl - 1);
                    }
                } else if (rsi.markceiling) {
                    this.ceilingclip[rw_x] = (short)(yl - 1);
                }
                if (rsi.bottomtexture != 0) {
                    mid = pixlow + 4096 - 1 >> 12;
                    pixlow += pixlowstep;
                    if (mid <= this.ceilingclip[rw_x]) {
                        mid = this.ceilingclip[rw_x] + 1;
                    }
                    if (mid <= yh) {
                        this.dcvars.dc_yl = mid;
                        this.dcvars.dc_yh = yh;
                        this.dcvars.dc_texturemid = rsi.rw_bottomtexturemid;
                        this.dcvars.dc_texheight = this.TexMan.getTextureheight(rsi.bottomtexture) >> 16;
                        this.dcvars.dc_source = this.TexMan.GetCachedColumn(rsi.bottomtexture, texturecolumn);
                        this.colfunc.invoke();
                        this.floorclip[rw_x] = (short)mid;
                    } else {
                        this.floorclip[rw_x] = (short)(yh + 1);
                    }
                } else if (rsi.markfloor) {
                    this.floorclip[rw_x] = (short)(yh + 1);
                }
            }
            rw_scale += rw_scalestep;
            topfrac += topstep;
            bottomfrac += bottomstep;
        }
    }

    @Override
    public void setDetail(int detailshift) {
        this.colfunc = detailshift == 0 ? this.colfunchi : this.colfunclow;
    }

    public void setScreenRange(int rwstart, int rwend) {
        this.rw_end = rwend;
        this.rw_start = rwstart;
    }

    public void setRSIEnd(int rsiend) {
        this.rsiend = rsiend;
    }

    @Override
    public void run() {
        System.arraycopy(this.BLANKFLOORCLIP, this.rw_start, this.floorclip, this.rw_start, this.rw_end - this.rw_start);
        System.arraycopy(this.BLANKCEILINGCLIP, this.rw_start, this.ceilingclip, this.rw_start, this.rw_end - this.rw_start);
        for (int i = 0; i < this.rsiend; ++i) {
            RenderSegInstruction<V> rsi = this.RSI[i];
            this.dcvars.centery = this.RSI[i].centery;
            boolean contained = rsi.rw_x >= this.rw_start;
            int startx = Math.max(rsi.rw_x, this.rw_start);
            int endx = Math.min(rsi.rw_stopx, this.rw_end);
            if (endx - startx <= 0) continue;
            this.ProcessRSI(rsi, startx, endx, contained);
        }
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public void updateRSI(RenderSegInstruction<V>[] rsi) {
        this.RSI = rsi;
    }

    public static final class Indexed
    extends RenderSegExecutor<byte[], byte[]> {
        public Indexed(DoomMain<byte[], byte[]> DOOM, int id, byte[] screen, TextureManager<byte[]> texman, RenderSegInstruction<byte[]>[] RSI, short[] BLANKCEILINGCLIP, short[] BLANKFLOORCLIP, short[] ceilingclip, short[] floorclip, int[] columnofs, long[] xtoviewangle, int[] ylookup, visplane_t[] visplanes, CyclicBarrier barrier, LightsAndColors<byte[]> colormaps) {
            super(DOOM, id, screen, texman, RSI, BLANKCEILINGCLIP, BLANKFLOORCLIP, ceilingclip, floorclip, columnofs, xtoviewangle, ylookup, visplanes, barrier, colormaps);
            this.dcvars = new ColVars();
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
        }
    }

    public static final class HiColor
    extends RenderSegExecutor<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DOOM, int id, short[] screen, TextureManager<byte[]> texman, RenderSegInstruction<short[]>[] RSI, short[] BLANKCEILINGCLIP, short[] BLANKFLOORCLIP, short[] ceilingclip, short[] floorclip, int[] columnofs, long[] xtoviewangle, int[] ylookup, visplane_t[] visplanes, CyclicBarrier barrier, LightsAndColors<short[]> colormaps) {
            super(DOOM, id, screen, texman, RSI, BLANKCEILINGCLIP, BLANKFLOORCLIP, ceilingclip, floorclip, columnofs, xtoviewangle, ylookup, visplanes, barrier, colormaps);
            this.dcvars = new ColVars();
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
        }
    }

    public static final class TrueColor
    extends RenderSegExecutor<byte[], int[]> {
        public TrueColor(DoomMain<byte[], int[]> DOOM, int id, int[] screen, TextureManager<byte[]> texman, RenderSegInstruction<int[]>[] RSI, short[] BLANKCEILINGCLIP, short[] BLANKFLOORCLIP, short[] ceilingclip, short[] floorclip, int[] columnofs, long[] xtoviewangle, int[] ylookup, visplane_t[] visplanes, CyclicBarrier barrier, LightsAndColors<int[]> colormaps) {
            super(DOOM, id, screen, texman, RSI, BLANKCEILINGCLIP, BLANKFLOORCLIP, ceilingclip, floorclip, columnofs, xtoviewangle, ylookup, visplanes, barrier, colormaps);
            this.dcvars = new ColVars();
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.dcvars, screen, null);
        }
    }
}

