/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import data.Tables;
import doom.DoomMain;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import rr.IDetailAware;
import rr.PlaneDrawer;
import rr.SceneRenderer;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.DoomSpanFunction;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.drawfuns.R_DrawSpanLow;
import rr.drawfuns.R_DrawSpanUnrolled;
import rr.drawfuns.SpanVars;
import rr.visplane_t;

public abstract class VisplaneWorker<T, V>
extends PlaneDrawer<T, V>
implements Runnable,
IDetailAware {
    protected final int id;
    protected final int NUMFLOORTHREADS;
    protected final CyclicBarrier barrier;
    protected int vpw_planeheight;
    protected V[] vpw_planezlight;
    protected int vpw_basexscale;
    protected int vpw_baseyscale;
    protected SpanVars<T, V> vpw_dsvars;
    protected ColVars<T, V> vpw_dcvars;
    protected DoomSpanFunction<T, V> vpw_spanfunc;
    protected DoomColumnFunction<T, V> vpw_skyfunc;
    protected DoomSpanFunction<T, V> vpw_spanfunchi;
    protected DoomSpanFunction<T, V> vpw_spanfunclow;
    protected DoomColumnFunction<T, V> vpw_skyfunchi;
    protected DoomColumnFunction<T, V> vpw_skyfunclow;

    public VisplaneWorker(DoomMain<T, V> DOOM, int id, int SCREENWIDTH, int SCREENHEIGHT, SceneRenderer<T, V> R, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
        super(DOOM, R);
        this.barrier = visplanebarrier;
        this.id = id;
        this.NUMFLOORTHREADS = NUMFLOORTHREADS;
    }

    @Override
    public void setDetail(int detailshift) {
        if (detailshift == 0) {
            this.vpw_spanfunc = this.vpw_spanfunchi;
            this.vpw_skyfunc = this.vpw_skyfunchi;
        } else {
            this.vpw_spanfunc = this.vpw_spanfunclow;
            this.vpw_skyfunc = this.vpw_skyfunclow;
        }
    }

    @Override
    public void run() {
        visplane_t pln = null;
        this.vpw_basexscale = this.vpvars.getBaseXScale();
        this.vpw_baseyscale = this.vpvars.getBaseYScale();
        for (int pl = this.id; pl < this.vpvars.lastvisplane; pl += this.NUMFLOORTHREADS) {
            int x;
            pln = this.vpvars.visplanes[pl];
            if (pln.minx > pln.maxx) continue;
            if (pln.picnum == this.TexMan.getSkyFlatNum()) {
                int skytexture = this.TexMan.getSkyTexture();
                this.vpw_dcvars.viewheight = this.view.height;
                this.vpw_dcvars.centery = this.view.centery;
                this.vpw_dcvars.dc_texheight = this.TexMan.getTextureheight(skytexture) >> 16;
                this.vpw_dcvars.dc_iscale = this.vpvars.getSkyScale() >> this.view.detailshift;
                this.vpw_dcvars.dc_colormap = this.colormap.colormaps[0];
                this.vpw_dcvars.dc_texturemid = this.TexMan.getSkyTextureMid();
                for (x = pln.minx; x <= pln.maxx; ++x) {
                    this.vpw_dcvars.dc_yl = pln.getTop(x);
                    this.vpw_dcvars.dc_yh = pln.getBottom(x);
                    if (this.vpw_dcvars.dc_yl > this.vpw_dcvars.dc_yh) continue;
                    int angle = (int)(Tables.addAngles(this.view.angle, this.view.xtoviewangle[x]) >>> 22);
                    this.vpw_dcvars.dc_x = x;
                    this.vpw_dcvars.dc_source = this.TexMan.GetCachedColumn(this.TexMan.getSkyTexture(), angle);
                    this.vpw_skyfunc.invoke();
                }
                continue;
            }
            this.vpw_dsvars.ds_source = this.TexMan.getSafeFlat(pln.picnum);
            this.vpw_planeheight = Math.abs(pln.height - this.view.z);
            int light = (pln.lightlevel >>> this.colormap.lightSegShift()) + this.colormap.extralight;
            if (light >= this.colormap.lightLevels()) {
                light = this.colormap.lightLevels() - 1;
            }
            if (light < 0) {
                light = 0;
            }
            this.vpw_planezlight = this.colormap.zlight[light];
            pln.setTop(pln.maxx + 1, '\uffff');
            pln.setTop(pln.minx - 1, '\uffff');
            int stop = pln.maxx + 1;
            for (x = pln.minx; x <= stop; ++x) {
                this.MakeSpans(x, pln.getTop(x - 1), pln.getBottom(x - 1), pln.getTop(x), pln.getBottom(x));
            }
        }
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public static final class HiColor
    extends VisplaneWorker<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DOOM, int id, int SCREENWIDTH, int SCREENHEIGHT, SceneRenderer<byte[], short[]> R, int[] columnofs, int[] ylookup, short[] screen, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
            super(DOOM, id, SCREENWIDTH, SCREENHEIGHT, R, visplanebarrier, NUMFLOORTHREADS);
            this.vpw_dsvars = new SpanVars();
            this.vpw_dcvars = new ColVars();
            this.vpw_spanfunc = this.vpw_spanfunchi = new R_DrawSpanUnrolled.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_spanfunclow = new R_DrawSpanLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_skyfunc = this.vpw_skyfunchi = new R_DrawColumnBoomOpt.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, this.vpw_dcvars, screen, this.I);
            this.vpw_skyfunclow = new R_DrawColumnBoomOptLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, this.vpw_dcvars, screen, this.I);
        }
    }
}

