/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import data.Tables;
import doom.DoomMain;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import rr.IDetailAware;
import rr.PlaneDrawer;
import rr.SceneRenderer;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.DoomSpanFunction;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;
import rr.drawfuns.R_DrawSpanLow;
import rr.drawfuns.R_DrawSpanUnrolled;
import rr.drawfuns.SpanVars;
import rr.visplane_t;

public abstract class VisplaneWorker2<T, V>
extends PlaneDrawer<T, V>
implements Runnable,
IDetailAware {
    protected final int id;
    protected final int NUMFLOORTHREADS;
    protected int startvp;
    protected int endvp;
    protected int vpw_planeheight;
    protected V[] vpw_planezlight;
    protected int vpw_basexscale;
    protected int vpw_baseyscale;
    protected final SpanVars<T, V> vpw_dsvars;
    protected final ColVars<T, V> vpw_dcvars;
    protected DoomSpanFunction<T, V> vpw_spanfunc;
    protected DoomColumnFunction<T, V> vpw_skyfunc;
    protected DoomSpanFunction<T, V> vpw_spanfunchi;
    protected DoomSpanFunction<T, V> vpw_spanfunclow;
    protected DoomColumnFunction<T, V> vpw_skyfunchi;
    protected DoomColumnFunction<T, V> vpw_skyfunclow;
    protected visplane_t pln;
    CyclicBarrier barrier;

    public VisplaneWorker2(DoomMain<T, V> DOOM, SceneRenderer<T, V> R, int id, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
        super(DOOM, R);
        this.barrier = visplanebarrier;
        this.id = id;
        this.vpw_dsvars = new SpanVars();
        this.vpw_dcvars = new ColVars();
        this.NUMFLOORTHREADS = NUMFLOORTHREADS;
    }

    @Override
    public void run() {
        this.pln = null;
        this.vpw_basexscale = this.vpvars.getBaseXScale();
        this.vpw_baseyscale = this.vpvars.getBaseYScale();
        this.startvp = this.id * this.view.width / this.NUMFLOORTHREADS;
        this.endvp = (this.id + 1) * this.view.width / this.NUMFLOORTHREADS;
        for (int pl = 0; pl < this.vpvars.lastvisplane; ++pl) {
            int x;
            this.pln = this.vpvars.visplanes[pl];
            if (this.pln.minx > this.endvp || this.pln.maxx < this.startvp || this.pln.minx > this.pln.maxx) continue;
            int minx = Math.max(this.pln.minx, this.startvp);
            int maxx = Math.min(this.pln.maxx, this.endvp);
            if (this.pln.picnum == this.TexMan.getSkyFlatNum()) {
                int skytexture = this.TexMan.getSkyTexture();
                this.vpw_dcvars.viewheight = this.view.height;
                this.vpw_dcvars.centery = this.view.centery;
                this.vpw_dcvars.dc_texheight = this.TexMan.getTextureheight(skytexture) >> 16;
                this.vpw_dcvars.dc_iscale = this.vpvars.getSkyScale() >> this.view.detailshift;
                this.vpw_dcvars.dc_colormap = this.colormap.colormaps[0];
                this.vpw_dcvars.dc_texturemid = this.TexMan.getSkyTextureMid();
                for (x = minx; x <= maxx; ++x) {
                    this.vpw_dcvars.dc_yl = this.pln.getTop(x);
                    this.vpw_dcvars.dc_yh = this.pln.getBottom(x);
                    if (this.vpw_dcvars.dc_yl > this.vpw_dcvars.dc_yh) continue;
                    int angle = (int)(Tables.addAngles(this.view.angle, this.view.xtoviewangle[x]) >>> 22);
                    this.vpw_dcvars.dc_x = x;
                    this.vpw_dcvars.dc_texheight = this.TexMan.getTextureheight(this.TexMan.getSkyTexture()) >> 16;
                    this.vpw_dcvars.dc_source = this.TexMan.GetCachedColumn(this.TexMan.getSkyTexture(), angle);
                    this.vpw_skyfunc.invoke();
                }
                continue;
            }
            this.vpw_dsvars.ds_source = this.TexMan.getSafeFlat(this.pln.picnum);
            this.vpw_planeheight = Math.abs(this.pln.height - this.view.z);
            int light = (this.pln.lightlevel >>> this.colormap.lightSegShift()) + this.colormap.extralight;
            if (light >= this.colormap.lightLevels()) {
                light = this.colormap.lightLevels() - 1;
            }
            if (light < 0) {
                light = 0;
            }
            this.vpw_planezlight = this.colormap.zlight[light];
            char value = this.pln.getTop(maxx + 1);
            if (!this.isMarker(value)) {
                value = (char)(value | 0x8000);
                value = (char)(value & 0x8FFF);
                value = (char)(value | this.id << 12);
            }
            this.pln.setTop(maxx + 1, value);
            value = this.pln.getTop(minx - 1);
            if (!this.isMarker(value)) {
                value = (char)(value | 0x8000);
                value = (char)(value & 0x8FFF);
                value = (char)(value | this.id << 12);
            }
            this.pln.setTop(minx - 1, value);
            int stop = maxx + 1;
            for (x = minx; x <= stop; ++x) {
                this.MakeSpans(x, this.pln.getTop(x - 1), this.pln.getBottom(x - 1), this.pln.getTop(x), this.pln.getBottom(x));
            }
        }
        try {
            this.barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    private boolean isMarker(int t1) {
        return (t1 & 0x8000) != 0;
    }

    private int decodeID(int t1) {
        return (t1 & 0x7000) >> 12;
    }

    private int decodeValue(int t1) {
        return t1 & 0xFFF;
    }

    @Override
    public void setDetail(int detailshift) {
        if (detailshift == 0) {
            this.vpw_spanfunc = this.vpw_spanfunchi;
            this.vpw_skyfunc = this.vpw_skyfunchi;
        } else {
            this.vpw_spanfunc = this.vpw_spanfunclow;
            this.vpw_skyfunc = this.vpw_skyfunclow;
        }
    }

    @Override
    protected final void MakeSpans(int x, int t1, int b1, int t2, int b2) {
        if (this.isMarker(t1) && this.decodeID(t1) != this.id) {
            t1 = this.decodeValue(t1);
        }
        if (this.isMarker(t2) && this.decodeID(t2) != this.id) {
            t2 = this.decodeValue(t2);
        }
        super.MakeSpans(x, t1, b1, t2, b2);
    }

    public static class TrueColor
    extends VisplaneWorker2<byte[], int[]> {
        public TrueColor(DoomMain<byte[], int[]> DOOM, SceneRenderer<byte[], int[]> R, int id, int[] columnofs, int[] ylookup, int[] screen, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
            super(DOOM, R, id, visplanebarrier, NUMFLOORTHREADS);
            this.vpw_spanfunc = this.vpw_spanfunchi = new R_DrawSpanUnrolled.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_spanfunclow = new R_DrawSpanLow.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_skyfunc = this.vpw_skyfunchi = new R_DrawColumnBoomOpt.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
            this.vpw_skyfunclow = new R_DrawColumnBoomOptLow.TrueColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
        }
    }

    public static class Indexed
    extends VisplaneWorker2<byte[], byte[]> {
        public Indexed(DoomMain<byte[], byte[]> DOOM, SceneRenderer<byte[], byte[]> R, int id, int[] columnofs, int[] ylookup, byte[] screen, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
            super(DOOM, R, id, visplanebarrier, NUMFLOORTHREADS);
            this.vpw_spanfunc = this.vpw_spanfunchi = new R_DrawSpanUnrolled.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_spanfunclow = new R_DrawSpanLow.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_skyfunc = this.vpw_skyfunchi = new R_DrawColumnBoomOpt.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
            this.vpw_skyfunclow = new R_DrawColumnBoomOptLow.Indexed(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
        }
    }

    public static class HiColor
    extends VisplaneWorker2<byte[], short[]> {
        public HiColor(DoomMain<byte[], short[]> DOOM, SceneRenderer<byte[], short[]> R, int id, int[] columnofs, int[] ylookup, short[] screen, CyclicBarrier visplanebarrier, int NUMFLOORTHREADS) {
            super(DOOM, R, id, visplanebarrier, NUMFLOORTHREADS);
            this.vpw_spanfunc = this.vpw_spanfunchi = new R_DrawSpanUnrolled.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_spanfunclow = new R_DrawSpanLow.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dsvars, screen, this.I);
            this.vpw_skyfunc = this.vpw_skyfunchi = new R_DrawColumnBoomOpt.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
            this.vpw_skyfunclow = new R_DrawColumnBoomOptLow.HiColor(DOOM.vs.getScreenWidth(), DOOM.vs.getScreenHeight(), ylookup, columnofs, this.vpw_dcvars, screen, this.I);
        }
    }
}

