/*
 * Decompiled with CFR 0.152.
 */
package rr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import rr.column_t;
import utils.C2JUtils;
import w.CacheableDoomObject;
import w.DoomBuffer;

public class patch_t
implements CacheableDoomObject {
    public short width;
    public short height;
    public short leftoffset;
    public short topoffset;
    public int[] columnofs;
    public column_t[] columns;
    public String name;
    private static Hashtable<Integer, column_t> badColumns = new Hashtable();

    public patch_t(String name, int width, int height, int leftoffset, int topoffset) {
        this.name = name;
        this.width = (short)width;
        this.height = (short)height;
        this.leftoffset = (short)leftoffset;
        this.columns = new column_t[width];
    }

    public patch_t() {
    }

    @Override
    public void unpack(ByteBuffer b) throws IOException {
        int i;
        b.position(0);
        b.order(ByteOrder.LITTLE_ENDIAN);
        this.width = b.getShort();
        this.height = b.getShort();
        this.leftoffset = b.getShort();
        this.topoffset = b.getShort();
        this.columnofs = new int[this.width];
        this.columns = new column_t[this.width];
        C2JUtils.initArrayOfObjects(this.columns, column_t.class);
        int[] actualsizes = new int[this.columns.length];
        for (i = 0; i < actualsizes.length - 1; ++i) {
            actualsizes[i] = this.columnofs[i + 1] - this.columnofs[i];
        }
        DoomBuffer.readIntArray(b, this.columnofs, this.columnofs.length);
        for (i = 0; i < this.width; ++i) {
            b.position(this.columnofs[i]);
            try {
                this.columns[i].unpack(b);
                continue;
            }
            catch (Exception e) {
                this.columns[i] = i == 0 ? patch_t.getBadColumn(this.height) : this.columns[i - 1];
            }
        }
    }

    private static column_t getBadColumn(int size) {
        if (badColumns.get(size) == null) {
            column_t tmp = new column_t();
            tmp.data = new byte[size + 5];
            for (int i = 3; i < size + 3; ++i) {
                tmp.data[i] = (byte)(i - 3);
            }
            tmp.data[size + 4] = -1;
            tmp.posts = 1;
            tmp.postofs = new int[]{3};
            tmp.postdeltas = new short[]{0};
            tmp.postlen = new short[]{(short)(size % 256)};
            badColumns.put(size, tmp);
        }
        return badColumns.get(size);
    }
}

