/*
 * Decompiled with CFR 0.152.
 */
package rr;

import m.fixed_t;
import p.Resettable;
import rr.line_t;
import rr.sector_t;
import rr.side_t;
import rr.vertex_t;

public class seg_t
implements Resettable {
    public vertex_t v1;
    public vertex_t v2;
    public int v1x;
    public int v1y;
    public int v2x;
    public int v2y;
    public int offset;
    public long angle;
    public side_t sidedef;
    public line_t linedef;
    public sector_t frontsector;
    public sector_t backsector;
    public boolean miniseg;
    public float length;
    public int iSegID;

    public void assignVertexValues() {
        this.v1x = this.v1.x;
        this.v1y = this.v1.y;
        this.v2x = this.v2.x;
        this.v2y = this.v2.y;
    }

    public static int PointOnSegSide(int x, int y, seg_t line) {
        int lx = line.v1x;
        int ly = line.v1y;
        int ldx = line.v2x - lx;
        int ldy = line.v2y - ly;
        if (ldx == 0) {
            if (x <= lx) {
                return ldy > 0 ? 1 : 0;
            }
            return ldy < 0 ? 1 : 0;
        }
        if (ldy == 0) {
            if (y <= ly) {
                return ldx < 0 ? 1 : 0;
            }
            return ldx > 0 ? 1 : 0;
        }
        int dx = x - lx;
        int dy = y - ly;
        if (((ldy ^ ldx ^ dx ^ dy) & Integer.MIN_VALUE) != 0) {
            if (((ldy ^ dx) & Integer.MIN_VALUE) != 0) {
                return 1;
            }
            return 0;
        }
        int left = fixed_t.FixedMul(ldy >> 16, dx);
        int right = fixed_t.FixedMul(dy, ldx >> 16);
        if (right < left) {
            return 0;
        }
        return 1;
    }

    public int PointOnSegSide(int x, int y) {
        int lx = this.v1x;
        int ly = this.v1y;
        int ldx = this.v2x - lx;
        int ldy = this.v2y - ly;
        if (ldx == 0) {
            if (x <= lx) {
                return ldy > 0 ? 1 : 0;
            }
            return ldy < 0 ? 1 : 0;
        }
        if (ldy == 0) {
            if (y <= ly) {
                return ldx < 0 ? 1 : 0;
            }
            return ldx > 0 ? 1 : 0;
        }
        int dx = x - lx;
        int dy = y - ly;
        if (((ldy ^ ldx ^ dx ^ dy) & Integer.MIN_VALUE) != 0) {
            if (((ldy ^ dx) & Integer.MIN_VALUE) != 0) {
                return 1;
            }
            return 0;
        }
        int left = fixed_t.FixedMul(ldy >> 16, dx);
        int right = fixed_t.FixedMul(dy, ldx >> 16);
        if (right < left) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return String.format("Seg %d\n\tFrontsector: %s\n\tBacksector: %s\n\tVertexes: %x %x %x %x", this.iSegID, this.frontsector, this.backsector, this.v1x, this.v1y, this.v2x, this.v2y);
    }

    @Override
    public void reset() {
        this.v2 = null;
        this.v1 = null;
        this.v2y = 0;
        this.v2x = 0;
        this.v1y = 0;
        this.v1x = 0;
        this.angle = 0L;
        this.backsector = null;
        this.frontsector = null;
        this.iSegID = 0;
        this.linedef = null;
        this.miniseg = false;
        this.offset = 0;
        this.length = 0.0f;
    }
}

