/*
 * Decompiled with CFR 0.152.
 */
package rr;

import utils.C2JUtils;
import v.scale.VideoScale;

public class visplane_t {
    public static final int TOPOFFSET = 1;
    public static final int MIDDLEPADDING = 2;
    public static int BOTTOMOFFSET;
    public static final char SENTINEL = '\u8000';
    public static final char THREADIDSHIFT = '\f';
    public static final char THREADIDCLEAR = '\u8fff';
    public static final char THREADIDBITS = '\u7000';
    public static final char THREADVALUEBITS = '\u0fff';
    public int height;
    public int picnum;
    public int lightlevel;
    public int minx;
    public int maxx;
    char[] data;
    protected static char[] clearvisplane;
    protected int hash;
    protected static StringBuilder sb;
    protected static VideoScale vs;

    public visplane_t() {
        this.data = new char[4 + 2 * vs.getScreenWidth()];
        this.updateHashCode();
    }

    public visplane_t(int height, int picnum, int lightlevel) {
        this.height = height;
        this.picnum = picnum;
        this.lightlevel = lightlevel;
        this.updateHashCode();
        this.data = new char[4 + 2 * vs.getScreenWidth()];
    }

    public void clearTop() {
        System.arraycopy(clearvisplane, 0, this.data, 1, vs.getScreenWidth());
    }

    public void clearBottom() {
        System.arraycopy(clearvisplane, 0, this.data, BOTTOMOFFSET, vs.getScreenWidth());
    }

    public void setTop(int index, char value) {
        this.data[1 + index] = value;
    }

    public char getTop(int index) {
        return this.data[1 + index];
    }

    public void setBottom(int index, char value) {
        this.data[visplane_t.BOTTOMOFFSET + index] = value;
    }

    public int getBottom(int index) {
        return this.data[BOTTOMOFFSET + index];
    }

    public String toString() {
        sb.setLength(0);
        sb.append("Visplane\n");
        sb.append('\t');
        sb.append("Height: ");
        sb.append(this.height);
        sb.append('\t');
        sb.append("Min-Max: ");
        sb.append(this.minx);
        sb.append('-');
        sb.append(this.maxx);
        sb.append('\t');
        sb.append("Picnum: ");
        sb.append(this.picnum);
        sb.append('\t');
        sb.append("Lightlevel: ");
        sb.append(this.lightlevel);
        return sb.toString();
    }

    public void updateHashCode() {
        this.hash = this.height ^ this.picnum ^ this.lightlevel;
    }

    public int hashCode() {
        return this.hash;
    }

    public static int visplaneHash(int height, int picnum, int lightlevel) {
        return height ^ picnum ^ lightlevel;
    }

    public static void setVideoScale(VideoScale vs) {
        visplane_t.vs = vs;
        BOTTOMOFFSET = vs.getScreenWidth() + 1 + 2;
        if (clearvisplane == null || clearvisplane.length < vs.getScreenWidth()) {
            clearvisplane = new char[vs.getScreenWidth()];
            C2JUtils.memset(clearvisplane, '\uffff', clearvisplane.length);
        }
    }

    static {
        sb = new StringBuilder();
    }
}

