/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sounds;
import doom.DoomMain;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import pooling.AudioChunkPool;
import s.AbstractSoundDriver;
import s.AudioChunk;

public class ClassicDoomSoundDriver
extends AbstractSoundDriver {
    protected final Semaphore produce;
    protected final Semaphore consume;
    protected int chunk = 0;
    protected SourceDataLine line = null;
    protected HashMap<Integer, byte[]> cachedSounds = new HashMap();
    protected final int[] channelstep;
    protected final int[] channelstepremainder;
    protected byte[][] channels;
    protected int[] p_channels;
    protected int[] channelsend;
    protected final int[][] channelleftvol_lookup;
    protected final int[][] channelrightvol_lookup;
    protected volatile boolean mixed = false;
    protected MixServer SOUNDSRV;
    protected Thread SOUNDTHREAD;
    private int silence = 0;
    protected StringBuilder sb = new StringBuilder();
    protected final AudioChunk SILENT_CHUNK = new AudioChunk();
    protected final AudioChunkPool audiochunkpool = new AudioChunkPool();

    public ClassicDoomSoundDriver(DoomMain<?, ?> DM, int numChannels) {
        super(DM, numChannels);
        this.channelleftvol_lookup = new int[numChannels][];
        this.channelrightvol_lookup = new int[numChannels][];
        this.channelstep = new int[numChannels];
        this.channelstepremainder = new int[numChannels];
        this.channels = new byte[numChannels][];
        this.p_channels = new int[numChannels];
        this.channelsend = new int[numChannels];
        this.produce = new Semaphore(1);
        this.consume = new Semaphore(1);
        this.produce.drainPermits();
        this.mixbuffer = new byte[4200];
    }

    @Override
    public void UpdateSound() {
        int chan;
        this.mixed = false;
        int sample = 0;
        int leftout = 0;
        int rightout = 2;
        int step = 4;
        int leftend = 1050 * step;
        for (chan = 0; chan < this.numChannels; ++chan) {
            if (this.channels[chan] == null) continue;
            this.mixed = true;
        }
        while (leftout < leftend) {
            int dl = 0;
            int dr = 0;
            for (chan = 0; chan < this.numChannels; ++chan) {
                if (this.channels[chan] == null) continue;
                int channel_pointer = this.p_channels[chan];
                sample = 0xFF & this.channels[chan][channel_pointer];
                dl += this.channelleftvol_lookup[chan][sample];
                dr += this.channelrightvol_lookup[chan][sample];
                int n = chan;
                this.channelstepremainder[n] = this.channelstepremainder[n] + this.channelstep[chan];
                int n2 = chan;
                this.channelstepremainder[n2] = this.channelstepremainder[n2] & 0xFFFF;
                if ((channel_pointer += this.channelstepremainder[chan] >> 16) >= this.channelsend[chan]) {
                    this.channels[chan] = null;
                    channel_pointer = 0;
                }
                this.p_channels[chan] = channel_pointer;
            }
            if (dl > Short.MAX_VALUE) {
                dl = Short.MAX_VALUE;
            } else if (dl < Short.MIN_VALUE) {
                dl = Short.MIN_VALUE;
            }
            this.mixbuffer[leftout] = (byte)((dl & 0xFF00) >>> 8);
            this.mixbuffer[leftout + 1] = (byte)(dl & 0xFF);
            if (dr > Short.MAX_VALUE) {
                dr = Short.MAX_VALUE;
            } else if (dr < Short.MIN_VALUE) {
                dr = Short.MIN_VALUE;
            }
            this.mixbuffer[rightout] = (byte)((dr & 0xFF00) >>> 8);
            this.mixbuffer[rightout + 1] = (byte)(dr & 0xFF);
            leftout += 4;
            rightout += 4;
        }
    }

    @Override
    public void SetChannels(int numChannels) {
        int steptablemid = 128;
        for (int i = 0; i < this.numChannels; ++i) {
            this.channels[i] = null;
        }
        this.generateStepTable(steptablemid);
        this.generateVolumeLUT();
    }

    @Override
    public boolean InitSound() {
        System.out.println("I_InitSound: ");
        AudioFormat format = new AudioFormat(22050.0f, 16, 2, true, true);
        DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, format);
        if (AudioSystem.isLineSupported(info2)) {
            try {
                this.line = AudioSystem.getSourceDataLine(format);
                this.line.open(format, 42000);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.print("Could not play signed 16 data\n");
                return false;
            }
        }
        if (this.line == null) {
            System.err.print(" could not configure audio device\n");
            return false;
        }
        System.err.print(" configured audio device\n");
        this.line.start();
        this.SOUNDSRV = new MixServer(this.line);
        this.SOUNDTHREAD = new Thread(this.SOUNDSRV);
        this.SOUNDTHREAD.start();
        System.err.print("I_InitSound: ");
        super.initSound8();
        System.err.print(" pre-cached all sound data\n");
        this.initMixBuffer();
        System.err.print("I_InitSound: sound module ready\n");
        return true;
    }

    @Override
    protected int addsfx(int sfxid, int volume, int step, int seperation) {
        int rightvol;
        int i;
        int rc = -1;
        int oldest = this.DM.gametic;
        int oldestnum = 0;
        int broken = -1;
        if (sfxid >= sounds.sfxenum_t.sfx_sawup.ordinal() && sfxid <= sounds.sfxenum_t.sfx_sawhit.ordinal() || sfxid == sounds.sfxenum_t.sfx_stnmov.ordinal() || sfxid == sounds.sfxenum_t.sfx_pistol.ordinal()) {
            for (i = 0; i < this.numChannels; ++i) {
                if (this.channels[i] == null || this.channelids[i] != sfxid) continue;
                this.p_channels[i] = 0;
                this.channels[i] = null;
                broken = i;
                break;
            }
        }
        if (broken >= 0) {
            i = broken;
            oldestnum = broken;
        } else {
            for (i = 0; i < this.numChannels && this.channels[i] != null; ++i) {
                if (this.channelstart[i] >= oldest) continue;
                oldestnum = i;
            }
        }
        oldest = this.channelstart[oldestnum];
        int slot = i == this.numChannels ? oldestnum : i;
        this.channels[slot] = sounds.S_sfx[sfxid].data;
        this.p_channels[slot] = 0;
        this.channelsend[slot] = this.lengths[sfxid];
        if (this.handlenums == 0) {
            this.handlenums = (short)100;
        }
        short s = this.handlenums;
        this.handlenums = (short)(s - 1);
        rc = s;
        this.channelhandles[slot] = s;
        this.channelstep[slot] = step;
        this.channelstepremainder[slot] = 0;
        this.channelstart[slot] = this.DM.gametic;
        int leftvol = volume - (volume * ++seperation * seperation >> 16);
        if ((rightvol = volume - (volume * (seperation -= 257) * seperation >> 16)) < 0) {
            rightvol = 0;
        }
        if (rightvol > 127) {
            rightvol = 127;
        }
        if (leftvol < 0) {
            leftvol = 0;
        }
        if (leftvol > 127) {
            leftvol = 127;
        }
        this.channelleftvol_lookup[slot] = this.vol_lookup[leftvol];
        this.channelrightvol_lookup[slot] = this.vol_lookup[rightvol];
        this.channelids[slot] = sfxid;
        return rc;
    }

    @Override
    public void ShutdownSound() {
        boolean done = false;
        this.produce.release();
        while (!done) {
            int i;
            for (i = 0; i < this.numChannels && this.channels[i] == null; ++i) {
            }
            this.UpdateSound();
            this.SubmitSound();
            if (i != this.numChannels) continue;
            done = true;
        }
        this.line.drain();
        this.SOUNDSRV.terminate = true;
        this.produce.release();
        try {
            this.SOUNDTHREAD.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.line.close();
    }

    @Override
    public boolean SoundIsPlaying(int handle) {
        int c = this.getChannelFromHandle(handle);
        return c != -2 && this.channels[c] == null;
    }

    protected int getChannelFromHandle(int handle) {
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channelhandles[i] != handle) continue;
            return i;
        }
        return -2;
    }

    @Override
    public void StopSound(int handle) {
        int hnd = this.getChannelFromHandle(handle);
        if (hnd >= 0) {
            this.channels[hnd] = null;
            this.p_channels[hnd] = 0;
            this.channelhandles[hnd] = -1;
        }
    }

    @Override
    public void SubmitSound() {
        if (this.mixed) {
            this.silence = 0;
            AudioChunk gunk = (AudioChunk)this.audiochunkpool.checkOut();
            gunk.free = false;
            System.arraycopy(this.mixbuffer, 0, gunk.buffer, 0, 4200);
            this.SOUNDSRV.addChunk(gunk);
            ++this.chunk;
            if (this.consume.tryAcquire()) {
                this.produce.release();
            }
        } else {
            ++this.silence;
            if (this.silence > 25) {
                this.line.flush();
                this.silence = 0;
            }
        }
    }

    @Override
    public void UpdateSoundParams(int handle, int vol, int sep, int pitch) {
        int rightvol;
        int chan = this.getChannelFromHandle(handle);
        int leftvol = vol - (vol * sep * sep >> 16);
        if ((rightvol = vol - (vol * (sep -= 257) * sep >> 16)) < 0 || rightvol > 127) {
            this.DM.doomSystem.Error("rightvol out of bounds");
        }
        if (leftvol < 0 || leftvol > 127) {
            this.DM.doomSystem.Error("leftvol out of bounds");
        }
        this.channelleftvol_lookup[chan] = this.vol_lookup[leftvol];
        this.channelrightvol_lookup[chan] = this.vol_lookup[rightvol];
        this.channelstep[chan] = this.steptable[pitch];
        this.channelsend[chan] = this.lengths[this.channelids[chan]];
    }

    public String channelStatus() {
        this.sb.setLength(0);
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channels[i] != null) {
                this.sb.append(i);
                continue;
            }
            this.sb.append('-');
        }
        return this.sb.toString();
    }

    protected class MixServer
    implements Runnable {
        public boolean terminate = false;
        private SourceDataLine auline;
        private ArrayBlockingQueue<AudioChunk> audiochunks = new ArrayBlockingQueue(10);
        public volatile int currstate = 0;

        public MixServer(SourceDataLine line) {
            this.auline = line;
        }

        public void addChunk(AudioChunk chunk) {
            this.audiochunks.offer(chunk);
        }

        @Override
        public void run() {
            while (!this.terminate) {
                try {
                    ClassicDoomSoundDriver.this.produce.acquire();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int chunks = 0;
                int atMost = Math.min(5, this.audiochunks.size());
                while (atMost-- > 0) {
                    AudioChunk chunk = null;
                    try {
                        chunk = this.audiochunks.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.auline.write(chunk.buffer, 0, 4200);
                    ++chunks;
                    chunk.free = true;
                    ClassicDoomSoundDriver.this.audiochunkpool.checkIn(chunk);
                }
                ClassicDoomSoundDriver.this.consume.release();
            }
        }
    }
}

