/*
 * Decompiled with CFR 0.152.
 */
package s;

public class DSP {
    public float resamp(float x, float[] indat, int alim, float fmax, float fsr, int wnwdth) {
        float r_g = 2.0f * fmax / fsr;
        int r_y = 0;
        for (int i = -wnwdth / 2; i < wnwdth / 2; ++i) {
            int j = (int)(x + (float)i);
            float r_w = (float)(0.5 - 0.5 * Math.cos(Math.PI * 2 * (0.5 + (double)(((float)j - x) / (float)wnwdth))));
            float r_a = (float)(Math.PI * 2 * (double)((float)j - x) * (double)fmax / (double)fsr);
            int r_snc = 1;
            if (Math.abs(r_a) > 0.0f) {
                r_snc = (int)(Math.sin(r_a) / (double)r_a);
            }
            if (j < 0 || j >= alim) continue;
            r_y = (int)((float)r_y + r_g * r_w * (float)r_snc * indat[j]);
        }
        return r_y;
    }

    public static double[] wsfiltgen(int nt, double fc, double fsr, double bw, double g) {
        double[] fir = new double[nt];
        for (int i = 1; i < nt; ++i) {
            double a = (double)(i - nt / 2) * 2.0 * Math.PI * bw / fsr;
            double ys = 1.0;
            if (Math.abs(a) > 0.0) {
                ys = Math.sin(a) / a;
            }
            double yg = g * (4.0 * bw / fsr);
            double yw = 0.54 - 0.46 * Math.cos((double)i * 2.0 * Math.PI / (double)nt);
            double yf = Math.cos((double)(i - nt / 2) * 2.0 * Math.PI * fc / fsr);
            fir[i] = yf * yw * yg * ys;
        }
        return fir;
    }

    public static void main(String[] argv) {
        double[] fir = DSP.wsfiltgen(128, 5512.5, 22050.0, 16537.5, 0.5);
        System.out.println(fir);
    }

    public static byte[] crudeResample(byte[] input, int factor) {
        if (input == null || input.length < 1) {
            return null;
        }
        int LEN = input.length;
        byte[] res = new byte[LEN * factor];
        int k = 0;
        res[0] = input[0];
        for (int i = 0; i < LEN; ++i) {
            float start = i == 0 ? 127.0f : (float)(0xFF & input[i]);
            float end = i < LEN - 1 ? (float)(0xFF & input[i + 1]) : 127.0f;
            double slope = (end - start) / (float)factor;
            res[k] = input[i];
            for (int j = 1; j < factor; ++j) {
                byte bval;
                double ratio = (double)j / (double)factor;
                double value = (double)start + slope * ratio;
                res[k + j] = bval = (byte)Math.round(value);
            }
            k += factor;
        }
        return res;
    }

    public static void filter(byte[] input, int samplerate, int cutoff) {
        int i;
        double[] tmp = new double[input.length];
        for (i = 0; i < input.length; ++i) {
            tmp[i] = (double)(0xFF & input[i]) / 255.0;
        }
        DSP.filter(tmp, samplerate, cutoff, tmp.length);
        for (i = 0; i < input.length; ++i) {
            input[i] = (byte)(0xFF & (int)(tmp[i] * 255.0));
        }
    }

    private static void getLPCoefficientsButterworth2Pole(int samplerate, double cutoff, double[] ax, double[] by) {
        double PI = Math.PI;
        double sqrt2 = 1.4142135623730951;
        double QcRaw = 2.0 * PI * cutoff / (double)samplerate;
        double QcWarp = Math.tan(QcRaw);
        double gain = 1.0 / (1.0 + sqrt2 / QcWarp + 2.0 / (QcWarp * QcWarp));
        by[2] = (1.0 - sqrt2 / QcWarp + 2.0 / (QcWarp * QcWarp)) * gain;
        by[1] = (2.0 - 4.0 / (QcWarp * QcWarp)) * gain;
        by[0] = 1.0;
        ax[0] = 1.0 * gain;
        ax[1] = 2.0 * gain;
        ax[2] = 1.0 * gain;
    }

    public static void filter(double[] samples, int smp, double cutoff, int count) {
        double[] ax = new double[3];
        double[] by = new double[3];
        double[] xv = new double[3];
        double[] yv = new double[3];
        DSP.getLPCoefficientsButterworth2Pole(smp, cutoff, ax, by);
        for (int i = 0; i < count; ++i) {
            xv[2] = xv[1];
            xv[1] = xv[0];
            xv[0] = samples[i];
            yv[2] = yv[1];
            yv[1] = yv[0];
            yv[0] = ax[0] * xv[0] + ax[1] * xv[1] + ax[2] * xv[2] - by[1] * yv[0] - by[2] * yv[1];
            samples[i] = yv[0];
        }
    }
}

