/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.ByteArrayInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import s.IMusic;
import s.MusReader;
import s.VolumeScalingReceiver;

public class DavidMusicModule
implements IMusic {
    public static final int CHANGE_VOLUME = 7;
    public static final int CHANGE_VOLUME_FINE = 9;
    Sequencer sequencer;
    VolumeScalingReceiver receiver;
    Transmitter transmitter;
    boolean songloaded;

    @Override
    public void InitMusic() {
        try {
            int x = -1;
            MidiDevice.Info[] info2 = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < info2.length; ++i) {
                MidiDevice mdev = MidiSystem.getMidiDevice(info2[i]);
                if (!(mdev instanceof Sequencer)) continue;
                x = i;
            }
            this.sequencer = x != -1 ? (Sequencer)MidiSystem.getMidiDevice(info2[x]) : MidiSystem.getSequencer(false);
            this.sequencer.open();
            this.receiver = VolumeScalingReceiver.getInstance();
            DavidMusicModule.sendSysexMessage(this.receiver, -16, 126, 127, 9, 1, -9);
            this.transmitter = this.sequencer.getTransmitter();
            this.transmitter.setReceiver(this.receiver);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    private static void sendControlChange(Receiver receiver, int midiChan, int ctrlId, int value) {
        ShortMessage msg = new ShortMessage();
        try {
            msg.setMessage(176, midiChan, ctrlId, value);
        }
        catch (InvalidMidiDataException ex) {
            throw new RuntimeException(ex);
        }
        receiver.send(msg, -1L);
    }

    private static void sendSysexMessage(Receiver receiver, byte ... message) {
        SysexMessage msg = new SysexMessage();
        try {
            msg.setMessage(message, message.length);
        }
        catch (InvalidMidiDataException ex) {
            throw new RuntimeException(ex);
        }
        receiver.send(msg, -1L);
    }

    @Override
    public void ShutdownMusic() {
        this.sequencer.stop();
        this.sequencer.close();
    }

    @Override
    public void SetMusicVolume(int volume) {
        System.out.println("Midi volume set to " + volume);
        this.receiver.setGlobalVolume((float)volume / 127.0f);
    }

    @Override
    public void PauseSong(int handle) {
        if (this.songloaded) {
            this.sequencer.stop();
        }
    }

    @Override
    public void ResumeSong(int handle) {
        if (this.songloaded) {
            System.out.println("Resuming song");
            this.sequencer.start();
        }
    }

    @Override
    public int RegisterSong(byte[] data) {
        try {
            Sequence sequence;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                sequence = MidiSystem.getSequence(bis);
            }
            catch (InvalidMidiDataException ex) {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                sequence = MusReader.getSequence(bis);
            }
            this.sequencer.stop();
            this.sequencer.setSequence(sequence);
            this.songloaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @Override
    public void PlaySong(int handle, boolean looping) {
        if (this.songloaded) {
            for (int midiChan = 0; midiChan < 16; ++midiChan) {
                this.setPitchBendSensitivity(this.receiver, midiChan, 2);
            }
            if (looping) {
                this.sequencer.setLoopCount(-1);
            } else {
                this.sequencer.setLoopCount(0);
            }
            this.sequencer.start();
        }
    }

    private void setPitchBendSensitivity(Receiver receiver, int midiChan, int semitones) {
        this.sendRegParamChange(receiver, midiChan, 0, 0, 2);
    }

    private void sendRegParamChange(Receiver receiver, int midiChan, int paramMsb, int paramLsb, int valMsb) {
        DavidMusicModule.sendControlChange(receiver, midiChan, 101, paramMsb);
        DavidMusicModule.sendControlChange(receiver, midiChan, 100, paramLsb);
        DavidMusicModule.sendControlChange(receiver, midiChan, 6, valMsb);
    }

    @Override
    public void StopSong(int handle) {
        this.sequencer.stop();
    }

    @Override
    public void UnRegisterSong(int handle) {
        this.songloaded = false;
    }
}

