/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sounds;
import doom.DoomMain;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import s.AbstractSoundDriver;
import s.DoomSound;

public class DavidSFXModule
extends AbstractSoundDriver {
    ArrayList<DoomSound> cachedSounds = new ArrayList();
    public final float[] linear2db;
    private SoundWorker[] channels;
    private Thread[] soundThread;
    StringBuilder sb = new StringBuilder();

    public DavidSFXModule(DoomMain<?, ?> DM, int numChannels) {
        super(DM, numChannels);
        this.linear2db = this.computeLinear2DB();
    }

    private float[] computeLinear2DB() {
        float[] tmp = new float[128];
        for (int i = 0; i < 128; ++i) {
            float linear = (float)(10.0 * Math.log10((float)i / 128.0f));
            if ((double)linear < -36.0) {
                linear = -36.0f;
            }
            tmp[i] = linear;
        }
        return tmp;
    }

    @Override
    public boolean InitSound() {
        System.err.println("I_InitSound: ");
        this.initSound16();
        for (int i = 0; i < sounds.S_sfx.length; ++i) {
            DoomSound tmp = new DoomSound(sounds.S_sfx[i], DoomSound.DEFAULT_SAMPLES_FORMAT);
            this.cachedSounds.add(tmp);
        }
        System.err.print(" pre-cached all sound data\n");
        System.err.print("I_InitSound: sound module ready\n");
        return true;
    }

    @Override
    public void UpdateSound() {
    }

    @Override
    public void SubmitSound() {
    }

    @Override
    public void ShutdownSound() {
        int i;
        boolean done = false;
        while (!done) {
            for (i = 0; i < this.numChannels && !this.channels[i].isPlaying(); ++i) {
            }
            if (i != this.numChannels) continue;
            done = true;
        }
        for (i = 0; i < this.numChannels; ++i) {
            this.channels[i].terminate = true;
            this.channels[i].wait.release();
            try {
                this.soundThread[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void SetChannels(int numChannels) {
        this.channels = new SoundWorker[numChannels];
        this.soundThread = new Thread[numChannels];
        for (int i = 0; i < numChannels; ++i) {
            this.channels[i] = new SoundWorker(i);
            this.soundThread[i] = new Thread(this.channels[i]);
            this.soundThread[i].start();
        }
    }

    private final void createDataLineForChannel(int c, int sfxid) {
        if (this.channels[c].auline == null) {
            try {
                DoomSound tmp = this.cachedSounds.get(sfxid);
                DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, DoomSound.DEFAULT_SAMPLES_FORMAT);
                this.channels[c].auline = (SourceDataLine)AudioSystem.getLine(info2);
                this.channels[c].auline.open(tmp.format);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            boolean errors = false;
            if (this.channels[c].auline.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.channels[c].vc = (FloatControl)this.channels[c].auline.getControl(FloatControl.Type.MASTER_GAIN);
            } else {
                System.err.print("MASTER_GAIN, ");
                errors = true;
                if (this.channels[c].auline.isControlSupported(FloatControl.Type.VOLUME)) {
                    this.channels[c].vc = (FloatControl)this.channels[c].auline.getControl(FloatControl.Type.VOLUME);
                } else {
                    System.err.print("VOLUME, ");
                }
            }
            if (this.channels[c].auline.isControlSupported(FloatControl.Type.SAMPLE_RATE)) {
                this.channels[c].pc = (FloatControl)this.channels[c].auline.getControl(FloatControl.Type.SAMPLE_RATE);
            } else {
                errors = true;
                System.err.print("SAMPLE_RATE, ");
            }
            if (this.channels[c].auline.isControlSupported(FloatControl.Type.BALANCE)) {
                this.channels[c].bc = (FloatControl)this.channels[c].auline.getControl(FloatControl.Type.BALANCE);
            } else {
                System.err.print("BALANCE, ");
                errors = true;
                if (this.channels[c].auline.isControlSupported(FloatControl.Type.PAN)) {
                    this.channels[c].bc = (FloatControl)this.channels[c].auline.getControl(FloatControl.Type.PAN);
                } else {
                    System.err.print("PANNING ");
                }
            }
            if (errors) {
                System.err.printf("for channel %d NOT supported!\n", c);
            }
            this.channels[c].auline.start();
        }
    }

    @Override
    protected int addsfx(int sfxid, int volume, int pitch, int seperation) {
        int rightvol;
        int i;
        int rc = -1;
        int oldest = this.DM.gametic;
        int oldestnum = 0;
        if (sfxid == sounds.sfxenum_t.sfx_sawup.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawidl.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawful.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawhit.ordinal() || sfxid == sounds.sfxenum_t.sfx_stnmov.ordinal() || sfxid == sounds.sfxenum_t.sfx_pistol.ordinal()) {
            for (i = 0; i < this.numChannels; ++i) {
                if (!this.channels[i].isPlaying() || this.channelids[i] != sfxid) continue;
                this.channels[i].stopSound();
                break;
            }
        }
        for (i = 0; i < this.numChannels && this.channels[i] != null; ++i) {
            if (this.channelstart[i] >= oldest) continue;
            oldestnum = i;
            oldest = this.channelstart[i];
        }
        int slot = i == this.numChannels ? oldestnum : i;
        this.createDataLineForChannel(slot, sfxid);
        if (this.handlenums == 0) {
            this.handlenums = (short)100;
        }
        short s = this.handlenums;
        this.handlenums = (short)(s - 1);
        rc = s;
        this.channelhandles[slot] = s;
        this.channelstart[slot] = this.DM.gametic;
        int leftvol = volume - (volume * ++seperation * seperation >> 16);
        if ((rightvol = volume - (volume * (seperation -= 257) * seperation >> 16)) < 0 || rightvol > 127) {
            this.DM.doomSystem.Error("rightvol out of bounds");
        }
        if (leftvol < 0 || leftvol > 127) {
            this.DM.doomSystem.Error("leftvol out of bounds");
        }
        this.channelids[slot] = sfxid;
        this.channels[slot].setVolume(volume);
        this.channels[slot].setPanning(seperation + 256);
        this.channels[slot].addSound(this.cachedSounds.get((int)sfxid).data, this.handlenums);
        this.channels[slot].setPitch(pitch);
        return rc;
    }

    @Override
    public void StopSound(int handle) {
        int hnd = this.getChannelFromHandle(handle);
        if (hnd >= 0) {
            this.channels[hnd].stopSound();
        }
    }

    @Override
    public boolean SoundIsPlaying(int handle) {
        return this.getChannelFromHandle(handle) != -2;
    }

    @Override
    public void UpdateSoundParams(int handle, int vol, int sep, int pitch) {
        int i = this.getChannelFromHandle(handle);
        if (i != -2) {
            this.channels[i].setVolume(vol);
            this.channels[i].setPitch(pitch);
            this.channels[i].setPanning(sep);
        }
    }

    private int getChannelFromHandle(int handle) {
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channelhandles[i] != handle) continue;
            return i;
        }
        return -2;
    }

    public String channelStatus() {
        this.sb.setLength(0);
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channels[i].isPlaying()) {
                this.sb.append(i);
                continue;
            }
            this.sb.append('-');
        }
        return this.sb.toString();
    }

    private class SoundWorker
    implements Runnable {
        public Semaphore wait;
        FloatControl vc;
        FloatControl bc;
        FloatControl pc;
        byte[] currentSoundSync;
        byte[] currentSound;
        int id;
        int handle;
        public boolean terminate;
        SourceDataLine auline;

        public SoundWorker(int id) {
            this.id = id;
            this.handle = -1;
            this.wait = new Semaphore(1);
        }

        public void addSound(byte[] ds, int handle) {
            this.handle = handle;
            this.currentSound = ds;
            this.auline.stop();
            this.auline.start();
            this.wait.release();
        }

        public void setVolume(int volume) {
            if (this.vc != null) {
                if (this.vc.getType() == FloatControl.Type.MASTER_GAIN) {
                    float vol = DavidSFXModule.this.linear2db[volume];
                    this.vc.setValue(vol);
                } else if (this.vc.getType() == FloatControl.Type.VOLUME) {
                    float vol = this.vc.getMinimum() + (this.vc.getMaximum() - this.vc.getMinimum()) * (float)volume / 127.0f;
                    this.vc.setValue(vol);
                }
            }
        }

        public void setPanning(int sep) {
            if (this.bc != null) {
                float pan = this.bc.getMinimum() + (this.bc.getMaximum() - this.bc.getMinimum()) * (float)sep / 256.0f;
                this.bc.setValue(pan);
            }
        }

        public void setPitch(int pitch) {
            if (this.pc != null) {
                float pan = (float)((double)this.pc.getValue() * ((double)pitch / 65536.0));
                this.pc.setValue(pan);
            }
        }

        @Override
        public void run() {
            System.err.printf("Sound thread %d started\n", this.id);
            while (!this.terminate) {
                this.currentSoundSync = this.currentSound;
                if (this.currentSoundSync != null) {
                    try {
                        this.auline.write(this.currentSoundSync, 0, this.currentSoundSync.length);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    finally {
                        this.auline.drain();
                    }
                    this.currentSound = null;
                    if (this.handle > 0) {
                        DavidSFXModule.this.channelhandles[this.id] = -1;
                    }
                    this.handle = -1;
                }
                try {
                    this.wait.acquire();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopSound() {
            this.auline.stop();
            this.auline.flush();
            DavidSFXModule.this.channelhandles[this.id] = -1;
            this.handle = -1;
            this.currentSound = null;
            this.auline.start();
        }

        public boolean isPlaying() {
            return this.handle != -1 || this.currentSound != null;
        }
    }
}

