/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DoomIO {
    InputStream is;
    OutputStream os;
    public static Endian writeEndian = Endian.LITTLE;

    public DoomIO(InputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
    }

    public static int toUnsigned(byte signed) {
        int unsigned = signed & 0xFF;
        unsigned = signed >= 0 ? signed : 256 + signed;
        unsigned = (256 + signed) % 256;
        return unsigned;
    }

    public static int fread(byte[] bytes, int size, int count, InputStream file) throws IOException {
        int retour = 0;
        do {
            if (file.read(bytes, retour * size, size) < size) {
                return retour;
            }
            ++retour;
        } while (--count > 0);
        return retour;
    }

    public static int freadint(InputStream file) throws IOException {
        return DoomIO.freadint(file, 2);
    }

    public static int freadint(InputStream file, int nbBytes) throws IOException {
        byte[] bytes = new byte[nbBytes];
        if (DoomIO.fread(bytes, nbBytes, 1, file) < 1) {
            return -1;
        }
        long retour = 0L;
        for (int i = 0; i < nbBytes; ++i) {
            retour += (long)DoomIO.toUnsigned(bytes[i]) * (long)Math.pow(256.0, i);
        }
        if (retour > (long)Math.pow(256.0, nbBytes) / 2L) {
            retour -= (long)Math.pow(256.0, nbBytes);
        }
        return (int)retour;
    }

    public static int fwrite2(byte[] ptr, int offset, int size, Object file) throws IOException {
        DoomIO.fwrite(ptr, offset, size, 1, file);
        return 0;
    }

    public static int fwrite2(byte[] ptr, int size, Object file) throws IOException {
        return DoomIO.fwrite2(ptr, 0, size, file);
    }

    public static int fwrite2(byte[] ptr, Object file) throws IOException {
        return DoomIO.fwrite2(ptr, 0, ptr.length, file);
    }

    public static void fwrite(String bytes, int size, int count, Object file) throws IOException {
        DoomIO.fwrite(DoomIO.toByteArray(bytes), size, count, file);
    }

    public static void fwrite(byte[] bytes, int size, int count, Object file) throws IOException {
        DoomIO.fwrite(bytes, 0, size, count, file);
    }

    public static void fwrite(byte[] bytes, int offset, int size, int count, Object file) throws IOException {
        if (file instanceof OutputStream) {
            ((OutputStream)file).write(bytes, offset, Math.min(bytes.length, size));
            for (int i = bytes.length; i < size; ++i) {
                ((OutputStream)file).write(0);
            }
        }
        if (file instanceof Writer) {
            char[] ch = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                ch[i] = (char)DoomIO.toUnsigned(bytes[i]);
            }
            ((Writer)file).write(ch, offset, size);
        }
    }

    public static byte[] toByteArray(String str) {
        byte[] retour = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            retour[i] = (byte)(str.charAt(i) & 0xFF);
        }
        return retour;
    }

    public static byte[] toByteArray(int str) {
        return DoomIO.toByteArray(str, 2);
    }

    static int byteIdx(int i, int nbBytes) {
        return writeEndian == Endian.BIG ? i : nbBytes - 1 - i;
    }

    public static void copyBytes(byte[] from, byte[] to, int offset) {
        for (byte b : from) {
            to[offset++] = b;
        }
    }

    public static byte[] toByteArray(Long str, int nbBytes) {
        return DoomIO.toByteArray(str.intValue(), nbBytes);
    }

    public static byte[] toByteArray(Short str, int nbBytes) {
        return DoomIO.toByteArray(str.intValue(), nbBytes);
    }

    public static byte[] toByteArray(int[] str, int nbBytes) {
        byte[] bytes = new byte[str.length * nbBytes];
        for (int i = 0; i < str.length; ++i) {
            DoomIO.copyBytes(DoomIO.toByteArray(str[i], nbBytes), bytes, i * nbBytes);
        }
        return bytes;
    }

    public static byte[] toByteArray(Integer str, int nbBytes) {
        Long val = str.longValue();
        if (val < 0L) {
            val = (long)Math.pow(256.0, nbBytes) + val;
        }
        byte[] bytes = new byte[nbBytes];
        long tmp = val;
        for (int i = 0; i < nbBytes - 1; ++i) {
            bytes[DoomIO.byteIdx((int)i, (int)nbBytes)] = (byte)(tmp % 256L);
            tmp /= 256L;
        }
        bytes[DoomIO.byteIdx((int)(nbBytes - 1), (int)nbBytes)] = (byte)tmp;
        return bytes;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return DoomIO.getField(superClass, fieldName);
        }
    }

    public static void linkBA(Object obj, Object fieldName, Object stream, int size) {
        if (stream instanceof OutputStream) {
            try {
                Object val = null;
                if (fieldName instanceof String && (val = DoomIO.getField(obj.getClass(), (String)fieldName).get(obj)) instanceof Enum) {
                    val = ((Enum)val).ordinal();
                }
                if (fieldName instanceof Integer) {
                    val = fieldName;
                }
                Method method = DoomIO.class.getMethod("toByteArray", val.getClass(), Integer.TYPE);
                byte[] bytes = (byte[])method.invoke(null, val, size);
                ((OutputStream)stream).write(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stream instanceof InputStream) {
            try {
                if (fieldName instanceof String) {
                    Field field = obj.getClass().getField((String)fieldName);
                    DoomIO.assigner(obj, field, (InputStream)stream, size);
                }
                if (fieldName instanceof Integer) {
                    ((InputStream)stream).read(new byte[size]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void assigner(Object obj, Field field, InputStream is, int size) throws IOException, IllegalArgumentException, IllegalAccessException {
        Class<?> c = field.getType();
        if (c.isArray()) {
            Object a = field.get(obj);
            int len = Array.getLength(a);
            for (int i = 0; i < len; ++i) {
                int val = DoomIO.freadint(is, size);
                Object o = Array.get(a, i);
                Array.set(a, i, DoomIO.assignValue(val, o, o.getClass()));
            }
            return;
        }
        int val = DoomIO.freadint(is, size);
        Object v = DoomIO.assignValue(val, field.get(obj), field.getType());
        field.set(obj, v);
    }

    public static Object assignValue(int val, Object objToReplace, Class<?> classe) {
        if (classe.isAssignableFrom(Boolean.class) || classe.isAssignableFrom(Boolean.TYPE)) {
            return val != 0;
        }
        ?[] enums = classe.getEnumConstants();
        if (enums != null) {
            return enums[val];
        }
        return val;
    }

    public static String baToString(byte[] bytes) {
        String str = "";
        for (int i = 0; i < bytes.length && bytes[i] != 0; ++i) {
            str = str + (char)bytes[i];
        }
        return str;
    }

    public static int indexOfArray(Object[] a, Object o) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != o) continue;
            return i;
        }
        return -1;
    }

    public static enum Endian {
        BIG,
        LITTLE;

    }
}

