/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import s.DoomIO;
import utils.C2JUtils;

public class DoomToWave {
    static int MEMORYCACHE = 32768;
    RIFFHEAD headr = new RIFFHEAD();
    CHUNK headc = new CHUNK();
    WAVEFMT headf = new WAVEFMT();
    int SIZEOF_WAVEFMT = 24;
    WAVEDATA headw = new WAVEDATA();
    int SIZEOF_WAVEDATA = 8;

    public void SNDsaveSound(InputStream is, OutputStream os) throws IOException {
        int type = DoomIO.freadint(is, 2);
        int speed = DoomIO.freadint(is, 2);
        int datasize = DoomIO.freadint(is, 4);
        if (type != 3) {
            System.out.println("Sound: weird type " + type + ". Extracting anyway.");
        }
        int headsize = 8;
        int size = is.available();
        int phys_size = size;
        if (datasize > phys_size) {
            System.out.println("Sound %s: declared sample size %lu greater than lump size %lu ;");
            System.out.println("Sound %s: truncating to lump size.");
            datasize = phys_size;
        } else if (datasize < phys_size) {
            datasize = phys_size;
        }
        DoomIO.writeEndian = DoomIO.Endian.BIG;
        this.SNDsaveWave(is, os, speed, datasize);
    }

    public byte[] DMX2Wave(byte[] DMXSound2) throws IOException {
        ByteBuffer is = ByteBuffer.wrap(DMXSound2);
        is.order(ByteOrder.LITTLE_ENDIAN);
        int type = 0xFFFF & is.getShort();
        int speed = 0xFFFF & is.getShort();
        int datasize = is.getInt();
        if (type != 3) {
            System.out.println("Sound: weird type " + type + ". Extracting anyway.");
        }
        int headsize = 8;
        int size = is.remaining();
        int phys_size = size;
        if (datasize > phys_size) {
            System.out.println("Sound %s: declared sample size %lu greater than lump size %lu ;");
            System.out.println("Sound %s: truncating to lump size.");
            datasize = phys_size;
        } else if (datasize < phys_size) {
            datasize = phys_size;
        }
        return this.SNDsaveWave(is, speed, datasize);
    }

    protected byte[] SNDsaveWave(ByteBuffer is, int speed, int size) throws IOException {
        int siz;
        byte[] output = new byte[this.headr.size() + this.headf.size() + this.SIZEOF_WAVEDATA + 2 * size];
        ByteBuffer os = ByteBuffer.wrap(output);
        os.order(ByteOrder.LITTLE_ENDIAN);
        os.position(0);
        this.headr.riff = "RIFF".getBytes();
        this.headr.length = siz = 4 + this.SIZEOF_WAVEFMT + this.SIZEOF_WAVEDATA + 2 * size;
        this.headr.wave = C2JUtils.toByteArray("WAVE");
        this.headr.pack(os);
        this.headf.fmt = C2JUtils.toByteArray("fmt ");
        this.headf.fmtsize = this.SIZEOF_WAVEFMT - 8;
        this.headf.tag = 1;
        this.headf.channel = 2;
        this.headf.smplrate = speed;
        this.headf.bytescnd = 2 * speed;
        this.headf.align = 1;
        this.headf.nbits = 8;
        this.headf.pack(os);
        this.headw.data = C2JUtils.toByteArray("data");
        this.headw.datasize = 2 * size;
        this.headw.pack(os);
        for (int i = 0; i < size; ++i) {
            byte tmp = is.get();
            os.put(tmp);
            os.put(tmp);
        }
        return os.array();
    }

    void SNDsaveWave(InputStream is, OutputStream os, int speed, int size) throws IOException {
        int siz;
        int sz = 0;
        this.headr.riff = DoomIO.toByteArray("RIFF");
        this.headr.length = siz = 4 + this.SIZEOF_WAVEFMT + this.SIZEOF_WAVEDATA + size;
        this.headr.wave = DoomIO.toByteArray("WAVE");
        DoomIO.fwrite2(this.headr.riff, os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headr.length, 4), os);
        DoomIO.fwrite2(this.headr.wave, os);
        this.headf.fmt = DoomIO.toByteArray("fmt ");
        this.headf.fmtsize = this.SIZEOF_WAVEFMT - 8;
        this.headf.tag = 1;
        this.headf.channel = 1;
        this.headf.smplrate = speed;
        this.headf.bytescnd = speed;
        this.headf.align = 1;
        this.headf.nbits = 8;
        DoomIO.fwrite2(this.headf.fmt, os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.fmtsize, 4), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.tag, 2), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.channel, 2), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.smplrate, 4), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.bytescnd, 4), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.align, 2), os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headf.nbits, 2), os);
        this.headw.data = DoomIO.toByteArray("data");
        this.headw.datasize = size;
        DoomIO.fwrite2(this.headw.data, os);
        DoomIO.fwrite2(DoomIO.toByteArray(this.headw.datasize, 4), os);
        ByteArrayOutputStream shit = (ByteArrayOutputStream)os;
        byte[] crap = shit.toByteArray();
        byte[] bytes = new byte[MEMORYCACHE];
        for (int wsize = 0; wsize < size; wsize += sz) {
            sz = size - wsize > MEMORYCACHE ? MEMORYCACHE : size - wsize;
            is.read(bytes, 0, sz);
            os.write(bytes, 0, sz);
        }
    }

    static class WAVEDATA {
        byte[] data = new byte[4];
        int datasize;

        WAVEDATA() {
        }

        public void pack(ByteBuffer b) {
            b.put(this.data);
            b.putInt(this.datasize);
        }
    }

    static class WAVEFMT {
        byte[] fmt = new byte[4];
        int fmtsize;
        int tag;
        int channel;
        int smplrate;
        int bytescnd;
        int align;
        int nbits;

        WAVEFMT() {
        }

        public void pack(ByteBuffer b) {
            b.put(this.fmt);
            b.putInt(this.fmtsize);
            b.putChar((char)this.tag);
            b.putChar((char)this.channel);
            b.putInt(this.smplrate);
            b.putInt(this.bytescnd);
            b.putChar((char)this.align);
            b.putChar((char)this.nbits);
        }

        public int size() {
            return 24;
        }
    }

    static class CHUNK {
        byte[] name = new byte[4];
        int size;

        CHUNK() {
        }

        public void pack(ByteBuffer b) {
            b.put(this.name);
            b.putInt(this.size);
        }

        public int size() {
            return 8;
        }
    }

    static class RIFFHEAD {
        byte[] riff = new byte[4];
        int length;
        byte[] wave = new byte[4];

        RIFFHEAD() {
        }

        public void pack(ByteBuffer b) {
            b.put(this.riff);
            b.putInt(this.length);
            b.put(this.wave);
        }

        public int size() {
            return 12;
        }
    }
}

