/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import s.IMusic;

public class FinnwMusicModule
implements IMusic {
    final Lock lock = new ReentrantLock();
    static final long nanosPerTick = 7142857L;
    final List<Channel> channels = new ArrayList<Channel>(15);
    ScheduledExecutorService exec;
    float volume;
    private ScheduledTransmitter currentTransmitter;
    private Receiver receiver;
    private final List<Song> songs = new ArrayList<Song>(1);

    public FinnwMusicModule() {
        for (int midiChan = 0; midiChan < 16; ++midiChan) {
            if (midiChan == 9) continue;
            this.channels.add(new Channel(midiChan));
        }
        this.channels.add(new Channel(9));
    }

    @Override
    public void InitMusic() {
        try {
            this.receiver = FinnwMusicModule.getReceiver();
            EventGroup genMidiEG = new EventGroup(1.0f);
            genMidiEG.generalMidi(1);
            genMidiEG.sendTo(this.receiver);
            FinnwMusicModule.sleepUninterruptibly(100, TimeUnit.MILLISECONDS);
        }
        catch (MidiUnavailableException ex) {
            System.err.println(ex);
            this.receiver = null;
        }
        this.exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryImpl());
    }

    @Override
    public void PauseSong(int handle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void PlaySong(int handle, boolean looping) {
        this.lock.lock();
        try {
            if (this.currentTransmitter != null) {
                this.currentTransmitter.stop();
            }
            this.currentTransmitter = null;
            if (0 <= handle && handle < this.songs.size()) {
                this.prepare(this.receiver);
                Song song = this.songs.get(handle);
                this.currentTransmitter = new ScheduledTransmitter(song.getScoreBuffer(), looping);
                this.currentTransmitter.setReceiver(this.receiver);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int RegisterSong(byte[] data) {
        return this.RegisterSong(ByteBuffer.wrap(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RegisterSong(ByteBuffer data) {
        Song song = new Song(data);
        this.lock.lock();
        try {
            int result = this.songs.indexOf(null);
            if (result >= 0) {
                this.songs.set(result, song);
            } else {
                result = this.songs.size();
                this.songs.add(song);
            }
            int n = result;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void ResumeSong(int handle) {
    }

    @Override
    public void SetMusicVolume(int volume) {
        float fVol = (float)volume * 0.007874016f;
        fVol = Math.max(0.0f, Math.min(fVol, 1.0f));
        this.lock.lock();
        try {
            this.volume = fVol;
            if (this.currentTransmitter != null) {
                this.currentTransmitter.volumeChanged();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void ShutdownMusic() {
        this.exec.shutdown();
    }

    @Override
    public void StopSong(int handle) {
        this.lock.lock();
        try {
            if (this.currentTransmitter != null) {
                this.currentTransmitter.stop();
                this.currentTransmitter = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void UnRegisterSong(int handle) {
        this.lock.lock();
        try {
            if (0 <= handle && handle < this.songs.size()) {
                this.songs.set(handle, null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static boolean hasMusMagic(ByteBuffer magicBuf) {
        return magicBuf.get(0) == 77 && magicBuf.get(1) == 85 && magicBuf.get(2) == 83 && magicBuf.get(3) == 26;
    }

    EventGroup nextEventGroup(ByteBuffer scoreBuffer, boolean looping) {
        boolean last;
        EventGroup result = new EventGroup(this.volume);
        do {
            int descriptor;
            if (!scoreBuffer.hasRemaining()) {
                if (looping) {
                    scoreBuffer.flip();
                } else {
                    return result.emptyToNull();
                }
            }
            last = ((descriptor = scoreBuffer.get() & 0xFF) & 0x80) != 0;
            int eventType = descriptor >> 4 & 7;
            int chanIndex = descriptor & 0xF;
            Channel channel = this.channels.get(chanIndex);
            block0 : switch (eventType) {
                case 0: {
                    int note = scoreBuffer.get() & 0xFF;
                    if ((note & 0x80) != 0) {
                        throw new IllegalArgumentException("Invalid note byte");
                    }
                    FinnwMusicModule.checkChannelExists("note off", channel).noteOff(note, result);
                    break;
                }
                case 1: {
                    boolean hasVelocity;
                    int note = scoreBuffer.get() & 0xFF;
                    boolean bl = hasVelocity = (note & 0x80) != 0;
                    if (hasVelocity) {
                        int velocity = scoreBuffer.get() & 0xFF;
                        if ((velocity & 0x80) != 0) {
                            throw new IllegalArgumentException("Invalid velocity byte");
                        }
                        FinnwMusicModule.checkChannelExists("note on", channel).noteOn(note & 0x7F, velocity, result);
                        break;
                    }
                    FinnwMusicModule.checkChannelExists("note on", channel).noteOn(note, result);
                    break;
                }
                case 2: {
                    int wheelVal = scoreBuffer.get() & 0xFF;
                    FinnwMusicModule.checkChannelExists("pitch bend", channel).pitchBend(wheelVal, result);
                    break;
                }
                case 3: {
                    int sysEvt = scoreBuffer.get() & 0xFF;
                    switch (sysEvt) {
                        case 10: {
                            FinnwMusicModule.checkChannelExists("all sounds off", channel).allSoundsOff(result);
                            break block0;
                        }
                        case 11: {
                            FinnwMusicModule.checkChannelExists("all notes off", channel).allNotesOff(result);
                            break block0;
                        }
                        case 14: {
                            FinnwMusicModule.checkChannelExists("reset all controllers", channel).resetAll(result);
                            break block0;
                        }
                    }
                    String msg = String.format("Invalid system event (%d)", sysEvt);
                    throw new IllegalArgumentException(msg);
                }
                case 4: {
                    int cNum = scoreBuffer.get() & 0xFF;
                    if ((cNum & 0x80) != 0) {
                        throw new IllegalArgumentException("Invalid controller number ");
                    }
                    int cVal = scoreBuffer.get() & 0xFF;
                    if (cNum == 3 && 133 <= cVal && cVal <= 135) {
                        cVal = 127;
                    }
                    if ((cVal & 0x80) != 0) {
                        String msg = String.format("Invalid controller value (%d; cNum=%d)", cVal, cNum);
                        throw new IllegalArgumentException(msg);
                    }
                    switch (cNum) {
                        case 0: {
                            FinnwMusicModule.checkChannelExists("patch change", channel).patchChange(cVal, result);
                            break block0;
                        }
                        case 1: {
                            FinnwMusicModule.checkChannelExists("bank switch", channel);
                            break block0;
                        }
                        case 2: {
                            FinnwMusicModule.checkChannelExists("vibrato change", channel).vibratoChange(cVal, result);
                            break block0;
                        }
                        case 3: {
                            FinnwMusicModule.checkChannelExists("volume", channel).volume(cVal, result);
                            break block0;
                        }
                        case 4: {
                            FinnwMusicModule.checkChannelExists("pan", channel).pan(cVal, result);
                            break block0;
                        }
                        case 5: {
                            FinnwMusicModule.checkChannelExists("expression", channel).expression(cVal, result);
                            break block0;
                        }
                        case 6: {
                            FinnwMusicModule.checkChannelExists("reverb depth", channel).reverbDepth(cVal, result);
                            break block0;
                        }
                        case 7: {
                            FinnwMusicModule.checkChannelExists("chorus depth", channel).chorusDepth(cVal, result);
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("Controller number " + cNum + ": not yet implemented"));
                }
                case 6: {
                    if (looping) {
                        scoreBuffer.flip();
                        break;
                    }
                    return result.emptyToNull();
                }
                default: {
                    String msg = String.format("Unknown event type: last=%5s eventType=%d chanIndex=%d%n", last, eventType, chanIndex);
                    throw new IllegalArgumentException(msg);
                }
            }
        } while (!last);
        int qTics = this.readTime(scoreBuffer);
        result.addDelay(qTics);
        return result;
    }

    private static Receiver getReceiver() throws MidiUnavailableException {
        ArrayList<MidiDevice.Info> dInfos = new ArrayList<MidiDevice.Info>(Arrays.asList(MidiSystem.getMidiDeviceInfo()));
        Iterator it = dInfos.iterator();
        while (it.hasNext()) {
            MidiDevice.Info dInfo = (MidiDevice.Info)it.next();
            MidiDevice dev = MidiSystem.getMidiDevice(dInfo);
            if (dev.getMaxReceivers() != 0) continue;
            it.remove();
        }
        if (dInfos.isEmpty()) {
            return null;
        }
        Collections.sort(dInfos, new MidiDeviceComparator());
        MidiDevice.Info dInfo = (MidiDevice.Info)dInfos.get(0);
        MidiDevice dev = MidiSystem.getMidiDevice(dInfo);
        dev.open();
        return dev.getReceiver();
    }

    private void prepare(Receiver receiver) {
        EventGroup setupEG = new EventGroup(this.volume);
        for (Channel chan : this.channels) {
            chan.allSoundsOff(setupEG);
            chan.resetAll(setupEG);
            chan.pitchBendSensitivity(2, setupEG);
            chan.volume(127, setupEG);
        }
        setupEG.sendTo(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleepUninterruptibly(int timeout, TimeUnit timeUnit) {
        long remaining;
        boolean interrupted = false;
        long now = System.nanoTime();
        long expiry = now + timeUnit.toNanos(timeout);
        while ((remaining = expiry - now) > 0L) {
            try {
                TimeUnit.NANOSECONDS.sleep(remaining);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            finally {
                now = System.nanoTime();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static Channel checkChannelExists(String type, Channel channel) throws IllegalArgumentException {
        if (channel == null) {
            String msg = String.format("Invalid channel for %s message", type);
            throw new IllegalArgumentException(msg);
        }
        return channel;
    }

    private int readTime(ByteBuffer scoreBuffer) {
        boolean last;
        int result = 0;
        do {
            int digit;
            last = ((digit = scoreBuffer.get() & 0xFF) & 0x80) == 0;
            result <<= 7;
            result |= digit & 0x7F;
        } while (!last);
        return result;
    }

    private class Song {
        private final ByteBuffer data;
        private final int scoreLen;
        private final int scoreStart;

        Song(ByteBuffer data) {
            this.data = data.asReadOnlyBuffer();
            this.data.order(ByteOrder.LITTLE_ENDIAN);
            byte[] magic = new byte[4];
            this.data.get(magic);
            ByteBuffer magicBuf = ByteBuffer.wrap(magic);
            if (!FinnwMusicModule.hasMusMagic(magicBuf)) {
                throw new IllegalArgumentException("Expected magic string \"MUS\\x1a\" but found " + Arrays.toString(magic));
            }
            this.scoreLen = this.data.getShort() & 0xFFFF;
            this.scoreStart = this.data.getShort() & 0xFFFF;
        }

        ByteBuffer getScoreBuffer() {
            ByteBuffer scoreBuffer = this.data.duplicate();
            scoreBuffer.position(this.scoreStart);
            scoreBuffer.limit(this.scoreStart + this.scoreLen);
            ByteBuffer slice = scoreBuffer.slice();
            return slice;
        }
    }

    private class ScheduledTransmitter
    implements Transmitter {
        TriggerTask triggerTask;
        private boolean autoShutdown;
        private ScheduledExecutorService exec;
        private ScheduledFuture<?> future;
        private final boolean looping;
        private long nextGroupTime;
        private Receiver receiver;
        private final ByteBuffer scoreBuffer;

        @Override
        public void close() {
            FinnwMusicModule.this.lock.lock();
            try {
                if (this.autoShutdown && this.exec != null) {
                    this.exec.shutdown();
                }
                this.autoShutdown = false;
                this.exec = null;
            }
            finally {
                FinnwMusicModule.this.lock.unlock();
            }
        }

        @Override
        public Receiver getReceiver() {
            return this.receiver;
        }

        @Override
        public void setReceiver(Receiver receiver) {
            EventGroup currentGroup = null;
            FinnwMusicModule.this.lock.lock();
            try {
                if (this.receiver != null) {
                    if (this.future.cancel(false)) {
                        currentGroup = this.triggerTask.eventGroup;
                    }
                } else {
                    this.nextGroupTime = System.nanoTime();
                }
                this.receiver = receiver;
                this.scheduleIfRequired(receiver, currentGroup);
            }
            finally {
                FinnwMusicModule.this.lock.unlock();
            }
        }

        ScheduledTransmitter(ByteBuffer scoreBuffer, boolean looping) {
            this.exec = FinnwMusicModule.this.exec;
            this.looping = looping;
            this.scoreBuffer = scoreBuffer;
        }

        void scheduleIfRequired(Receiver receiver, EventGroup currentGroup) {
            assert (((ReentrantLock)FinnwMusicModule.this.lock).isHeldByCurrentThread());
            if (currentGroup == null) {
                try {
                    currentGroup = FinnwMusicModule.this.nextEventGroup(this.scoreBuffer, this.looping);
                    if (currentGroup != null) {
                        this.triggerTask = new TriggerTask(currentGroup, receiver);
                        long delay = Math.max(0L, this.nextGroupTime - System.nanoTime());
                        this.future = this.exec.schedule(this.triggerTask, delay, TimeUnit.NANOSECONDS);
                        this.nextGroupTime += (long)currentGroup.getDelay() * 7142857L;
                    } else {
                        this.triggerTask = null;
                        this.future = null;
                    }
                }
                catch (RejectedExecutionException delay) {
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        }

        void stop() {
            assert (((ReentrantLock)FinnwMusicModule.this.lock).isHeldByCurrentThread());
            if (this.future != null) {
                this.future.cancel(false);
                try {
                    this.future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                this.future = null;
            }
            EventGroup cleanup = new EventGroup(0.0f);
            for (Channel chan : FinnwMusicModule.this.channels) {
                chan.allNotesOff(cleanup);
            }
            cleanup.sendTo(this.receiver);
        }

        void volumeChanged() {
            assert (((ReentrantLock)FinnwMusicModule.this.lock).isHeldByCurrentThread());
            EventGroup adjust = new EventGroup(FinnwMusicModule.this.volume);
            for (Channel chan : FinnwMusicModule.this.channels) {
                chan.volumeChanged(adjust);
            }
            adjust.sendTo(this.receiver);
        }

        private class TriggerTask
        implements Runnable {
            final EventGroup eventGroup;
            final Receiver receiver;

            @Override
            public void run() {
                boolean shouldSend = false;
                FinnwMusicModule.this.lock.lock();
                try {
                    if (ScheduledTransmitter.this.triggerTask == this) {
                        shouldSend = true;
                        ScheduledTransmitter.this.scheduleIfRequired(this.receiver, null);
                    }
                }
                finally {
                    FinnwMusicModule.this.lock.unlock();
                }
                if (shouldSend) {
                    this.eventGroup.sendTo(this.receiver);
                }
            }

            TriggerTask(EventGroup eventGroup, Receiver receiver) {
                this.eventGroup = eventGroup;
                this.receiver = receiver;
            }
        }
    }

    private static class Channel {
        private int lastVelocity;
        private int lastVolume;
        private final int midiChan;

        Channel(int midiChan) {
            this.midiChan = midiChan;
        }

        void allNotesOff(EventGroup eventGroup) {
            eventGroup.allNotesOff(this.midiChan);
        }

        void allSoundsOff(EventGroup eventGroup) {
            eventGroup.allSoundsOff(this.midiChan);
        }

        void chorusDepth(int depth, EventGroup eventGroup) {
            eventGroup.chorusDepth(this.midiChan, depth);
        }

        void expression(int expr, EventGroup eventGroup) {
            eventGroup.expression(this.midiChan, expr);
        }

        void noteOff(int note, EventGroup eventGroup) {
            eventGroup.noteOff(this.midiChan, note);
        }

        void noteOn(int note, EventGroup eventGroup) {
            eventGroup.noteOn(this.midiChan, note, this.lastVelocity);
        }

        void noteOn(int note, int velocity, EventGroup eventGroup) {
            this.lastVelocity = velocity;
            this.noteOn(note, eventGroup);
        }

        void pan(int pan, EventGroup eventGroup) {
            eventGroup.pan(this.midiChan, pan);
        }

        void patchChange(int patchId, EventGroup eventGroup) {
            eventGroup.patchChange(this.midiChan, patchId);
        }

        void pitchBend(int wheelVal, EventGroup eventGroup) {
            eventGroup.pitchBend(this.midiChan, wheelVal);
        }

        void pitchBendSensitivity(int semitones, EventGroup eventGroup) {
            eventGroup.pitchBendSensitivity(this.midiChan, semitones);
        }

        void resetAll(EventGroup eventGroup) {
            eventGroup.resetAllControllern(this.midiChan);
        }

        void reverbDepth(int depth, EventGroup eventGroup) {
            eventGroup.reverbDepth(this.midiChan, depth);
        }

        void vibratoChange(int depth, EventGroup eventGroup) {
            eventGroup.vibratoChange(this.midiChan, depth);
        }

        void volume(int vol, EventGroup eventGroup) {
            eventGroup.volume(this.midiChan, vol);
            this.lastVolume = vol;
        }

        void volumeChanged(EventGroup eventGroup) {
            eventGroup.volume(this.midiChan, this.lastVolume);
        }
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        private static final AtomicInteger NEXT_ID = new AtomicInteger(1);

        ThreadFactoryImpl() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, String.format("FinnwMusicModule-%d", NEXT_ID.getAndIncrement()));
            thread.setPriority(9);
            return thread;
        }
    }

    static class MidiDeviceComparator
    implements Comparator<MidiDevice.Info> {
        MidiDeviceComparator() {
        }

        @Override
        public int compare(MidiDevice.Info o1, MidiDevice.Info o2) {
            float score2;
            float score1 = this.score(o1);
            if (score1 < (score2 = this.score(o2))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            return 0;
        }

        private float score(MidiDevice.Info info2) {
            String lcName = info2.getName().toLowerCase(Locale.ENGLISH);
            float result = 0.0f;
            if (lcName.contains("mapper")) {
                result += 100.0f;
            } else if (lcName.contains("synth")) {
                result += 50.0f;
                if (lcName.contains("java")) {
                    result -= 20.0f;
                }
                if (lcName.contains("microsoft")) {
                    result -= 7.0f;
                }
            }
            return result;
        }
    }

    static class EventGroup {
        private static final int CHM_ALL_NOTES_OFF = 123;
        private static final int CHM_ALL_SOUND_OFF = 120;
        private static final int CTRL_CHORUS_DEPTH = 93;
        private static final int CTRL_EXPRESSION_POT = 11;
        private static final int CTRL_PAN = 10;
        private static final int RPM_PITCH_BEND_SENSITIVITY = 0;
        private static final int RPL_PITCH_BEND_SENSITIVITY = 0;
        private static final int CHM_RESET_ALL = 121;
        private static final int CTRL_REVERB_DEPTH = 91;
        private static final int CTRL_MODULATION_POT = 1;
        private static final int CTRL_VOLUME = 7;
        private int delay;
        private final List<MidiMessage> messages = new ArrayList<MidiMessage>();
        private final float volScale;

        EventGroup(float volScale) {
            this.volScale = volScale;
        }

        void addDelay(int tics) {
            this.delay += tics;
        }

        void allNotesOff(int midiChan) {
            this.addControlChange(midiChan, 123, 0);
        }

        void allSoundsOff(int midiChan) {
            this.addControlChange(midiChan, 120, 0);
        }

        long appendTo(Sequence sequence, int trackNum, long pos) {
            Track track = sequence.getTracks()[trackNum];
            for (MidiMessage msg : this.messages) {
                track.add(new MidiEvent(msg, pos));
            }
            return pos + (long)(this.delay * 3);
        }

        long appendTo(Track track, long pos, int scale) {
            for (MidiMessage msg : this.messages) {
                track.add(new MidiEvent(msg, pos));
            }
            return pos + (long)(this.delay * scale);
        }

        void chorusDepth(int midiChan, int depth) {
            this.addControlChange(midiChan, 93, depth);
        }

        void generalMidi(int mode) {
            this.addSysExMessage(240, 126, 127, 9, (byte)mode, -9);
        }

        EventGroup emptyToNull() {
            if (this.messages.isEmpty()) {
                return null;
            }
            return this;
        }

        void expression(int midiChan, int expr) {
            this.addControlChange(midiChan, 11, expr);
        }

        int getDelay() {
            return this.delay;
        }

        void noteOn(int midiChan, int note, int velocity) {
            this.addShortMessage(midiChan, 144, note, velocity);
        }

        void noteOff(int midiChan, int note) {
            this.addShortMessage(midiChan, 128, note, 0);
        }

        void pan(int midiChan, int pan) {
            this.addControlChange(midiChan, 10, pan);
        }

        void patchChange(int midiChan, int patchId) {
            this.addShortMessage(midiChan, 192, patchId, 0);
        }

        void pitchBend(int midiChan, int wheelVal) {
            int pb14 = wheelVal * 64;
            this.addShortMessage(midiChan, 224, pb14 % 128, pb14 / 128);
        }

        void pitchBendSensitivity(int midiChan, int semitones) {
            this.addRegParamChange(midiChan, 0, 0, semitones);
        }

        void resetAllControllern(int midiChan) {
            this.addControlChange(midiChan, 121, 0);
        }

        void reverbDepth(int midiChan, int depth) {
            this.addControlChange(midiChan, 91, depth);
        }

        void sendTo(Receiver receiver) {
            for (MidiMessage msg : this.messages) {
                receiver.send(msg, -1L);
            }
        }

        void vibratoChange(int midiChan, int depth) {
            this.addControlChange(midiChan, 1, depth);
        }

        void volume(int midiChan, int vol) {
            vol = Math.round((float)vol * this.volScale);
            this.addControlChange(midiChan, 7, vol);
        }

        private void addControlChange(int midiChan, int ctrlId, int ctrlVal) {
            this.addShortMessage(midiChan, 176, ctrlId, ctrlVal);
        }

        private void addRegParamChange(int midiChan, int paramMsb, int paramLsb, int valMsb) {
            this.addControlChange(midiChan, 101, paramMsb);
            this.addControlChange(midiChan, 100, paramLsb);
            this.addControlChange(midiChan, 6, valMsb);
        }

        private void addShortMessage(int midiChan, int cmd, int data1, int data2) {
            try {
                ShortMessage msg = new ShortMessage();
                msg.setMessage(cmd, midiChan, data1, data2);
                this.messages.add(msg);
            }
            catch (InvalidMidiDataException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void addSysExMessage(int status, byte ... data) {
            try {
                SysexMessage msg = new SysexMessage();
                msg.setMessage(status, data, data.length);
                this.messages.add(msg);
            }
            catch (InvalidMidiDataException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

