/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import s.DoomIO;

public class QMusToMid {
    public static final int NOTMUSFILE = 1;
    public static final int COMUSFILE = 2;
    public static final int COTMPFILE = 3;
    public static final int CWMIDFILE = 4;
    public static final int MUSFILECOR = 5;
    public static final int TOOMCHAN = 6;
    public static final int MEMALLOC = 7;
    public static final String MUSMAGIC = "MUS\u001a";
    public static final String MIDIMAGIC = "MThd\u0000\u0000\u0000\u0006\u0000\u0001";
    public static final String TRACKMAGIC1 = "\u0000\u00ff\u0003\u001d";
    public static final String TRACKMAGIC2 = "\u0000\u00ff/\u0000";
    public static final String TRACKMAGIC3 = "\u0000\u00ff\u0002\u0016";
    public static final String TRACKMAGIC4 = "\u0000\u00ffY\u0002\u0000\u0000";
    public static final String TRACKMAGIC5 = "\u0000\u00ffQ\u0003\t\u00a3\u001a";
    public static final String TRACKMAGIC6 = "\u0000\u00ff/\u0000";
    public static final int EOF = -1;
    long TRACKBUFFERSIZE = 65536L;

    void TWriteByte(int MIDItrack, byte byte_, Track[] track) {
        long pos = track[MIDItrack].current;
        if (pos < this.TRACKBUFFERSIZE) {
            track[MIDItrack].data[(int)pos] = byte_;
        } else {
            System.out.println("ERROR : Track buffer full.\nIncrease the track buffer size (option -size).\n");
            System.exit(1);
        }
        ++track[MIDItrack].current;
    }

    void TWriteVarLen(int tracknum, long value, Track[] track) {
        long buffer = value & 0x7FL;
        while ((value >>= 7) != 0L) {
            buffer <<= 8;
            buffer |= 0x80L;
            buffer += value & 0x7FL;
        }
        while (true) {
            this.TWriteByte(tracknum, (byte)buffer, track);
            if ((buffer & 0x80L) == 0L) break;
            buffer >>= 8;
        }
    }

    int ReadMUSheader(MUSheader MUSh, InputStream file) {
        try {
            if (DoomIO.fread(MUSh.ID, 4, 1, file) != 1) {
                return 2;
            }
            MUSh.ScoreLength = DoomIO.freadint(file);
            if (MUSh.ScoreLength == -1) {
                return 2;
            }
            MUSh.ScoreStart = DoomIO.freadint(file);
            if (MUSh.ScoreStart == -1) {
                return 2;
            }
            MUSh.channels = DoomIO.freadint(file);
            if (MUSh.channels == -1) {
                return 2;
            }
            MUSh.SecChannels = DoomIO.freadint(file);
            if (MUSh.SecChannels == -1) {
                return 2;
            }
            MUSh.InstrCnt = DoomIO.freadint(file);
            if (MUSh.InstrCnt == -1) {
                return 2;
            }
            MUSh.dummy = DoomIO.freadint(file);
            if (MUSh.dummy == -1) {
                return 2;
            }
            MUSh.instruments = new int[MUSh.InstrCnt];
            for (int i = 0; i < MUSh.InstrCnt; ++i) {
                MUSh.instruments[i] = DoomIO.freadint(file);
                if (MUSh.instruments[i] != -1) continue;
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    int WriteMIDheader(int ntrks, int division, Object file) {
        try {
            DoomIO.fwrite(MIDIMAGIC, 10, 1, file);
            DoomIO.fwrite2(DoomIO.toByteArray(ntrks), 2, file);
            DoomIO.fwrite2(DoomIO.toByteArray(division), 2, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    byte last(int e) {
        return (byte)(e & 0x80);
    }

    byte event_type(int e) {
        return (byte)((e & 0x7F) >> 4);
    }

    byte channel(int e) {
        return (byte)(e & 0xF);
    }

    void TWriteString(char tracknum, String string, int length, Track[] track) {
        for (int i = 0; i < length; ++i) {
            this.TWriteByte(tracknum, (byte)string.charAt(i), track);
        }
    }

    void WriteTrack(int tracknum, Object file, Track[] track) {
        try {
            long size = track[tracknum].current + 4L;
            DoomIO.fwrite("MTrk", 4, 1, file);
            if (tracknum == 0) {
                size += 33L;
            }
            DoomIO.fwrite2(DoomIO.toByteArray((int)size, 4), 4, file);
            if (tracknum == 0) {
                DoomIO.fwrite("\u0000\u00ff\u0003\u001dQuick MUS->MID ! by S.Bacquet", 33, 1, file);
            }
            int quot = (int)(track[tracknum].current / 4096L);
            int rem = (int)(track[tracknum].current - (long)(quot * 4096));
            DoomIO.fwrite(track[tracknum].data, (int)track[tracknum].current, 1, file);
            DoomIO.fwrite("\u0000\u00ff/\u0000", 4, 1, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void WriteFirstTrack(Object file) {
        try {
            byte[] size = DoomIO.toByteArray(43, 4);
            DoomIO.fwrite("MTrk", 4, 1, file);
            DoomIO.fwrite2(size, 4, file);
            DoomIO.fwrite(TRACKMAGIC3, 4, 1, file);
            DoomIO.fwrite("QMUS2MID (C) S.Bacquet", 22, 1, file);
            DoomIO.fwrite(TRACKMAGIC4, 6, 1, file);
            DoomIO.fwrite(TRACKMAGIC5, 7, 1, file);
            DoomIO.fwrite("\u0000\u00ff/\u0000", 4, 1, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    long ReadTime(InputStream file) throws IOException {
        int byte_;
        long time = 0L;
        do {
            if ((byte_ = this.getc(file)) == -1) continue;
            time = (time << 7) + (long)(byte_ & 0x7F);
        } while (byte_ != -1 && (byte_ & 0x80) != 0);
        return time;
    }

    byte FirstChannelAvailable(byte[] MUS2MIDchannel) {
        byte old15 = MUS2MIDchannel[15];
        byte max = -1;
        MUS2MIDchannel[15] = -1;
        for (int i = 0; i < 16; ++i) {
            if (MUS2MIDchannel[i] <= max) continue;
            max = MUS2MIDchannel[i];
        }
        MUS2MIDchannel[15] = old15;
        return max == 8 ? (byte)10 : (byte)(max + 1);
    }

    int getc(InputStream is) throws IOException {
        return is.read();
    }

    int qmus2mid(InputStream mus, Object mid, boolean nodisplay, int division, int BufferSize, boolean nocomp) throws IOException {
        int i;
        Track[] track = new Track[16];
        for (int i2 = 0; i2 < track.length; ++i2) {
            track[i2] = new Track();
        }
        int TrackCnt = 0;
        MUSheader MUSh = new MUSheader();
        long TotalTime = 0L;
        long n = 0L;
        byte[] MUS2MIDcontrol = new byte[]{0, 0, 1, 7, 10, 11, 91, 93, 64, 67, 120, 123, 126, 127, 121};
        byte[] MIDIchan2track = new byte[16];
        byte[] MUS2MIDchannel = new byte[16];
        boolean ouch = false;
        DoomIO.writeEndian = DoomIO.Endian.LITTLE;
        int r = this.ReadMUSheader(MUSh, mus);
        if (r != 0) {
            return r;
        }
        if (!nodisplay) {
            System.out.println(mus + " (" + mus.available() + "  bytes) contains " + MUSh.channels + " melodic channel" + (MUSh.channels >= 2 ? "s" : "") + "\n");
        }
        if (MUSh.channels > 15) {
            return 6;
        }
        for (i = 0; i < 16; ++i) {
            MUS2MIDchannel[i] = -1;
            track[i].current = 0L;
            track[i].vel = (byte)64;
            track[i].DeltaTime = 0L;
            track[i].LastEvent = 0;
            track[i].data = null;
        }
        if (BufferSize != 0) {
            this.TRACKBUFFERSIZE = (long)BufferSize << 10;
            if (!nodisplay) {
                System.out.println("Track buffer size set to " + BufferSize + " KB.\n");
            }
        }
        if (!nodisplay) {
            System.out.println("Converting...");
        }
        int event = this.getc(mus);
        byte et = this.event_type(event);
        byte MUSchannel = this.channel(event);
        while (et != 6 && mus.available() > 0 && event != -1) {
            byte MIDItrack;
            int MIDIchannel;
            if (MUS2MIDchannel[MUSchannel] == -1) {
                MUS2MIDchannel[MUSchannel] = MUSchannel == 15 ? 9 : (int)this.FirstChannelAvailable(MUS2MIDchannel);
                MIDIchannel = MUS2MIDchannel[MUSchannel];
                MIDItrack = MIDIchan2track[MIDIchannel] = (byte)TrackCnt++;
                track[MIDItrack].data = new byte[(int)this.TRACKBUFFERSIZE];
                if (track[MIDItrack].data == null) {
                    return 7;
                }
            } else {
                MIDIchannel = MUS2MIDchannel[MUSchannel];
                MIDItrack = MIDIchan2track[MIDIchannel];
            }
            this.TWriteVarLen(MIDItrack, track[MIDItrack].DeltaTime, track);
            track[MIDItrack].DeltaTime = 0L;
            switch (et) {
                case 0: {
                    byte NewEvent = (byte)(0x90 | MIDIchannel);
                    if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                        this.TWriteByte(MIDItrack, NewEvent, track);
                        track[MIDItrack].LastEvent = NewEvent;
                    } else {
                        ++n;
                    }
                    int data = this.getc(mus);
                    this.TWriteByte(MIDItrack, (byte)data, track);
                    this.TWriteByte(MIDItrack, (byte)0, track);
                    break;
                }
                case 1: {
                    byte NewEvent = (byte)(0x90 | MIDIchannel);
                    if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                        this.TWriteByte(MIDItrack, NewEvent, track);
                        track[MIDItrack].LastEvent = NewEvent;
                    } else {
                        ++n;
                    }
                    int data = this.getc(mus);
                    this.TWriteByte(MIDItrack, (byte)(data & 0x7F), track);
                    if ((data & 0x80) != 0) {
                        track[MIDItrack].vel = (byte)this.getc(mus);
                    }
                    this.TWriteByte(MIDItrack, track[MIDItrack].vel, track);
                    break;
                }
                case 2: {
                    byte NewEvent = (byte)(0xE0 | MIDIchannel);
                    if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                        this.TWriteByte(MIDItrack, NewEvent, track);
                        track[MIDItrack].LastEvent = NewEvent;
                    } else {
                        ++n;
                    }
                    int data = this.getc(mus);
                    this.TWriteByte(MIDItrack, (byte)((data & 1) << 6), track);
                    this.TWriteByte(MIDItrack, (byte)(data >> 1), track);
                    break;
                }
                case 3: {
                    byte NewEvent = (byte)(0xB0 | MIDIchannel);
                    if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                        this.TWriteByte(MIDItrack, NewEvent, track);
                        track[MIDItrack].LastEvent = NewEvent;
                    } else {
                        ++n;
                    }
                    int data = this.getc(mus);
                    this.TWriteByte(MIDItrack, MUS2MIDcontrol[data], track);
                    if (data == 12) {
                        this.TWriteByte(MIDItrack, (byte)(MUSh.channels + 1), track);
                        break;
                    }
                    this.TWriteByte(MIDItrack, (byte)0, track);
                    break;
                }
                case 4: {
                    byte NewEvent;
                    int data = this.getc(mus);
                    if (data != 0) {
                        NewEvent = (byte)(0xB0 | MIDIchannel);
                        if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                            this.TWriteByte(MIDItrack, NewEvent, track);
                            track[MIDItrack].LastEvent = NewEvent;
                        } else {
                            ++n;
                        }
                        this.TWriteByte(MIDItrack, MUS2MIDcontrol[data], track);
                    } else {
                        NewEvent = (byte)(0xC0 | MIDIchannel);
                        if (NewEvent != track[MIDItrack].LastEvent || nocomp) {
                            this.TWriteByte(MIDItrack, NewEvent, track);
                            track[MIDItrack].LastEvent = NewEvent;
                        } else {
                            ++n;
                        }
                    }
                    data = this.getc(mus);
                    this.TWriteByte(MIDItrack, (byte)data, track);
                    break;
                }
                case 5: 
                case 7: {
                    return 5;
                }
            }
            if (this.last(event) != 0) {
                long DeltaTime = this.ReadTime(mus);
                TotalTime += DeltaTime;
                for (i = 0; i < TrackCnt; ++i) {
                    track[i].DeltaTime += DeltaTime;
                }
            }
            if ((event = this.getc(mus)) != -1) {
                et = this.event_type(event);
                MUSchannel = this.channel(event);
                continue;
            }
            ouch = true;
        }
        if (!nodisplay) {
            System.out.println("done !\n");
        }
        if (ouch) {
            System.out.println("WARNING : There are bytes missing at the end of " + mus + ".\n          The end of the MIDI file might not fit the original one.\n");
        }
        if (division == 0) {
            division = 89;
        } else if (!nodisplay) {
            System.out.println("Ticks per quarter note set to " + division + ".\n");
        }
        if (!nodisplay) {
            long min;
            long time;
            if (division != 89) {
                time = TotalTime / 140L;
                min = time / 60L;
                char c = (char)(time - min * 60L);
            }
            time = TotalTime * 89L / (long)(140 * division);
            min = time / 60L;
            char sec = (char)(time - min * 60L);
            if (division != 89) {
                System.out.println("                    MID file");
            } else {
                System.out.println("Playing time: " + min + "min " + sec + "sec");
            }
        }
        if (!nodisplay) {
            System.out.println("Writing...");
        }
        this.WriteMIDheader(TrackCnt + 1, division, mid);
        this.WriteFirstTrack(mid);
        for (i = 0; i < TrackCnt; ++i) {
            this.WriteTrack(i, mid, track);
        }
        if (!nodisplay) {
            System.out.println("done !\n");
        }
        if (!nodisplay && !nocomp) {
            System.out.println("Compression : %u%%.\n");
        }
        return 0;
    }

    int convert(String mus, String mid, boolean nodisplay, int div, int size, boolean nocomp, Ptr<Integer> ow) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(mid)));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(mid)));
        char[] buffer = new char[30];
        return this.convert(is, os, nodisplay, div, size, nocomp, ow);
    }

    int convert(InputStream mus, Object mid, boolean nodisplay, int div, int size, boolean nocomp, Ptr<Integer> ow) throws IOException {
        int error = this.qmus2mid(mus, mid, nodisplay, div, size, nocomp);
        if (error != 0) {
            System.out.println("ERROR : ");
            switch (error) {
                case 1: {
                    System.out.println("%s is not a MUS file.\n");
                    break;
                }
                case 2: {
                    System.out.println("Can't open %s for read.\n");
                    break;
                }
                case 3: {
                    System.out.println("Can't open temp file.\n");
                    break;
                }
                case 4: {
                    System.out.println("Can't write %s (?).\n");
                    break;
                }
                case 5: {
                    System.out.println("%s is corrupted.\n");
                    break;
                }
                case 6: {
                    System.out.println("%s contains more than 16 channels.\n");
                    break;
                }
                case 7: {
                    System.out.println("Not enough memory.\n");
                    break;
                }
            }
            return 4;
        }
        if (!nodisplay) {
            System.out.println(mus + " converted successfully.\n");
        }
        return 0;
    }

    void PrintHeader() {
    }

    void PrintSyntax() {
    }

    int main(int argc, char[] argv) {
        boolean div = false;
        boolean ow = true;
        boolean nocomp = false;
        boolean size = false;
        boolean nodisplay = false;
        if (!nodisplay) {
            this.PrintHeader();
        }
        return 0;
    }

    public static class Track {
        long current;
        byte vel;
        long DeltaTime;
        byte LastEvent;
        byte[] data;
    }

    public static class MUSheader {
        byte[] ID = new byte[4];
        int ScoreLength;
        int ScoreStart;
        int channels;
        int SecChannels;
        int InstrCnt;
        int dummy;
        int[] instruments;
    }

    public static class Ptr<a> {
        a val;

        public Ptr(a val) {
            this.val = val;
        }

        public a get() {
            return this.val;
        }

        public void set(a newval) {
            this.val = newval;
        }
    }
}

