/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;

public class VolumeScalingReceiver
implements Receiver {
    private final int[] channelVolume = new int[16];
    private float globalVolume;
    private final Receiver synthReceiver;

    public static VolumeScalingReceiver getInstance() {
        try {
            ArrayList<MidiDevice.Info> dInfos = new ArrayList<MidiDevice.Info>(Arrays.asList(MidiSystem.getMidiDeviceInfo()));
            Iterator it = dInfos.iterator();
            while (it.hasNext()) {
                MidiDevice.Info dInfo = (MidiDevice.Info)it.next();
                MidiDevice dev = MidiSystem.getMidiDevice(dInfo);
                if (dev.getMaxReceivers() != 0) continue;
                it.remove();
            }
            if (dInfos.isEmpty()) {
                return null;
            }
            Collections.sort(dInfos, new MidiDeviceComparator());
            MidiDevice.Info dInfo = (MidiDevice.Info)dInfos.get(0);
            MidiDevice dev = MidiSystem.getMidiDevice(dInfo);
            dev.open();
            return new VolumeScalingReceiver(dev.getReceiver());
        }
        catch (MidiUnavailableException ex) {
            return null;
        }
    }

    public VolumeScalingReceiver(Receiver delegate) {
        this.synthReceiver = delegate;
        Arrays.fill(this.channelVolume, 127);
    }

    @Override
    public void close() {
        this.synthReceiver.close();
    }

    public synchronized void setGlobalVolume(float globalVolume) {
        this.globalVolume = globalVolume;
        for (int chan = 0; chan < 16; ++chan) {
            int volScaled = Math.round((float)this.channelVolume[chan] * globalVolume);
            this.sendVolumeChange(chan, volScaled, -1L);
        }
    }

    @Override
    public synchronized void send(MidiMessage message, long timeStamp) {
        int chan = this.getVolumeChangeChannel(message);
        if (chan < 0) {
            this.synthReceiver.send(message, timeStamp);
        } else {
            int newVolUnscaled;
            this.channelVolume[chan] = newVolUnscaled = message.getMessage()[2];
            int newVolScaled = Math.round((float)newVolUnscaled * this.globalVolume);
            this.sendVolumeChange(chan, newVolScaled, timeStamp);
        }
    }

    private void sendVolumeChange(int chan, int newVolScaled, long timeStamp) {
        newVolScaled = Math.max(0, Math.min(newVolScaled, 127));
        ShortMessage message = new ShortMessage();
        try {
            message.setMessage(0xB0 | chan & 0xF, 7, newVolScaled);
            this.synthReceiver.send(message, timeStamp);
        }
        catch (InvalidMidiDataException ex) {
            System.err.println(ex);
        }
    }

    private int getVolumeChangeChannel(MidiMessage message) {
        byte[] mBytes;
        if (message.getLength() >= 3 && -80 <= (mBytes = message.getMessage())[0] && mBytes[0] < -64 && mBytes[1] == 7) {
            return mBytes[0] & 0xF;
        }
        return -1;
    }

    static class MidiDeviceComparator
    implements Comparator<MidiDevice.Info> {
        MidiDeviceComparator() {
        }

        @Override
        public int compare(MidiDevice.Info o1, MidiDevice.Info o2) {
            float score2;
            float score1 = this.score(o1);
            if (score1 < (score2 = this.score(o2))) {
                return 1;
            }
            if (score1 > score2) {
                return -1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private float score(MidiDevice.Info info2) {
            String lcName = info2.getName().toLowerCase(Locale.ENGLISH);
            float result = 0.0f;
            try {
                dev.open();
                try (MidiDevice dev = MidiSystem.getMidiDevice(info2);){
                    if (dev instanceof Sequencer) {
                        float f = Float.NEGATIVE_INFINITY;
                        return f;
                    }
                    if (lcName.contains("mapper")) {
                        result += 100.0f;
                    } else if (dev instanceof Synthesizer) {
                        result += 50.0f;
                        if (lcName.contains("java")) {
                            result = ((Synthesizer)dev).getDefaultSoundbank() != null ? (result -= 10.0f) : (result -= 500.0f);
                        }
                        if (lcName.contains("microsoft")) {
                            result -= 7.0f;
                        }
                    }
                    float f = result;
                    return f;
                }
            }
            catch (MidiUnavailableException ex) {
                return Float.NEGATIVE_INFINITY;
            }
        }
    }
}

