/*
 * Decompiled with CFR 0.152.
 */
package savegame;

import data.info;
import doom.DoomMain;
import doom.player_t;
import doom.thinker_t;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import m.Settings;
import mochadoom.Engine;
import mochadoom.Loggers;
import p.Actions.ActionsLights;
import p.ActiveStates;
import p.ThinkerList;
import p.ceiling_t;
import p.floormove_t;
import p.mobj_t;
import p.plat_t;
import p.strobe_t;
import p.vldoor_t;
import rr.line_t;
import rr.sector_t;
import rr.side_t;
import savegame.IDoomSaveGame;
import savegame.IDoomSaveGameHeader;
import savegame.VanillaDSGHeader;
import utils.C2JUtils;

public class VanillaDSG<T, V>
implements IDoomSaveGame {
    VanillaDSGHeader header;
    final DoomMain<T, V> DOOM;
    private DataInputStream f;
    private DataOutputStream fo;
    private int maxsize;
    List<mobj_t> TL = new ArrayList<mobj_t>();
    final HashMap<Integer, mobj_t> pointindex = new HashMap();

    public VanillaDSG(DoomMain<T, V> DOOM) {
        this.DOOM = DOOM;
    }

    @Override
    public void setThinkerList(ThinkerList li) {
    }

    @Override
    public IDoomSaveGameHeader getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(IDoomSaveGameHeader header) {
        this.header = (VanillaDSGHeader)header;
    }

    @Override
    public boolean doLoad(DataInputStream f) {
        try {
            this.f = f;
            this.maxsize = f.available();
            System.out.println("Max size " + this.maxsize);
            this.header = new VanillaDSGHeader();
            this.header.read(f);
            this.UnArchivePlayers();
            this.UnArchiveWorld();
            this.UnArchiveThinkers();
            this.UnArchiveSpecials();
            byte terminator = f.readByte();
            return terminator == 29;
        }
        catch (IOException e) {
            Loggers.getLogger(VanillaDSG.class.getName()).log(Level.WARNING, e, () -> String.format("Error while loading savegame! Cause: %s", e.getMessage()));
            return false;
        }
    }

    protected void UnArchivePlayers() throws IOException {
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i]) continue;
            this.PADSAVEP(this.f, this.maxsize);
            this.DOOM.players[i].read(this.f);
            this.DOOM.players[i].mo = null;
            this.DOOM.players[i].message = null;
            this.DOOM.players[i].attacker = null;
            for (int j = 0; j < player_t.NUMPSPRITES; ++j) {
                if (!C2JUtils.eval(this.DOOM.players[i].psprites[j].state)) continue;
                this.DOOM.players[i].psprites[j].state = info.states[this.DOOM.players[i].psprites[j].readstate];
            }
        }
    }

    protected void ArchivePlayers() throws IOException {
        for (int i = 0; i < 4; ++i) {
            if (!this.DOOM.playeringame[i]) continue;
            this.PADSAVEP(this.fo);
            this.DOOM.players[i].write(this.fo);
        }
    }

    protected void ArchiveWorld() throws IOException {
        int i;
        ByteBuffer buffer = ByteBuffer.allocate(this.DOOM.levelLoader.numsectors * 14);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.deAdaptSectors();
        for (i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
            sector_t sec = this.DOOM.levelLoader.sectors[i];
            sec.pack(buffer);
        }
        this.adaptSectors();
        this.fo.write(buffer.array(), 0, buffer.position());
        buffer = ByteBuffer.allocate(this.DOOM.levelLoader.numlines * 26);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        for (i = 0; i < this.DOOM.levelLoader.numlines; ++i) {
            line_t li = this.DOOM.levelLoader.lines[i];
            li.pack(buffer);
            for (int j = 0; j < 2; ++j) {
                if (li.sidenum[j] == '\uffff') continue;
                side_t si = this.DOOM.levelLoader.sides[li.sidenum[j]];
                si.pack(buffer);
            }
        }
        int write = buffer.position();
        this.fo.write(buffer.array(), 0, write);
    }

    protected final void UnArchiveWorld() throws IOException {
        int i;
        for (i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
            sector_t sec = this.DOOM.levelLoader.sectors[i];
            sec.read(this.f);
            sec.specialdata = null;
            sec.soundtarget = null;
        }
        this.adaptSectors();
        for (i = 0; i < this.DOOM.levelLoader.numlines; ++i) {
            line_t li = this.DOOM.levelLoader.lines[i];
            li.read(this.f);
            for (int j = 0; j < 2; ++j) {
                if (li.sidenum[j] == '\uffff') continue;
                side_t si = this.DOOM.levelLoader.sides[li.sidenum[j]];
                si.read(this.f);
            }
        }
    }

    protected void adaptSectors() {
        switch (this.DOOM.getGameMode()) {
            case registered: 
            case shareware: {
                for (int i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
                    sector_t sec = this.DOOM.levelLoader.sectors[i];
                    sec.floorpic = sec.floorpic <= 54 ? (short)(sec.floorpic - 1) : (short)(sec.floorpic - 3);
                    sec.ceilingpic = sec.ceilingpic <= 54 ? (short)(sec.ceilingpic - 1) : (short)(sec.ceilingpic - 3);
                }
                break;
            }
            case commercial: 
            case pack_plut: 
            case pack_tnt: {
                for (int i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
                    sector_t sec = this.DOOM.levelLoader.sectors[i];
                    sec.floorpic = sec.floorpic <= 54 ? (short)(sec.floorpic - 1) : (sec.floorpic <= 99 ? (short)(sec.floorpic - 3) : (short)(sec.floorpic - 5));
                    sec.ceilingpic = sec.ceilingpic <= 54 ? (short)(sec.ceilingpic - 1) : (sec.ceilingpic <= 99 ? (short)(sec.ceilingpic - 3) : (short)(sec.ceilingpic - 5));
                }
                break;
            }
        }
    }

    protected void deAdaptSectors() {
        switch (this.DOOM.getGameMode()) {
            case registered: 
            case shareware: {
                for (int i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
                    sector_t sec = this.DOOM.levelLoader.sectors[i];
                    sec.floorpic = sec.floorpic < 54 ? (short)(sec.floorpic + 1) : (short)(sec.floorpic + 3);
                    sec.ceilingpic = sec.ceilingpic < 54 ? (short)(sec.ceilingpic + 1) : (short)(sec.ceilingpic + 3);
                }
                break;
            }
            case commercial: 
            case pack_plut: 
            case pack_tnt: {
                for (int i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
                    sector_t sec = this.DOOM.levelLoader.sectors[i];
                    sec.floorpic = sec.floorpic < 54 ? (short)(sec.floorpic + 1) : (sec.floorpic < 99 ? (short)(sec.floorpic + 3) : (short)(sec.floorpic + 5));
                    sec.ceilingpic = sec.ceilingpic < 54 ? (short)(sec.ceilingpic + 1) : (sec.ceilingpic < 99 ? (short)(sec.ceilingpic + 3) : (short)(sec.ceilingpic + 5));
                }
                break;
            }
        }
    }

    protected void ArchiveThinkers() throws IOException {
        thinker_t th = this.DOOM.actions.getThinkerCap().next;
        while (th != this.DOOM.actions.getThinkerCap()) {
            if (th.thinkerFunction != null && th.thinkerFunction == ActiveStates.P_MobjThinker) {
                this.fo.writeByte(thinkerclass_t.tc_mobj.ordinal());
                this.PADSAVEP(this.fo);
                mobj_t mobj = (mobj_t)th;
                mobj.write(this.fo);
            }
            th = th.next;
        }
        this.fo.writeByte(thinkerclass_t.tc_end.ordinal());
    }

    protected void UnArchiveThinkers() throws IOException {
        int id = 0;
        thinker_t currentthinker = this.DOOM.actions.getThinkerCap().next;
        while (currentthinker != null && currentthinker != this.DOOM.actions.getThinkerCap()) {
            thinker_t next = currentthinker.next;
            if (currentthinker.thinkerFunction == ActiveStates.P_MobjThinker) {
                this.DOOM.actions.RemoveMobj((mobj_t)currentthinker);
            }
            currentthinker = next;
        }
        this.DOOM.actions.InitThinkers();
        boolean end = false;
        block5: while (!end) {
            int tmp = this.f.readUnsignedByte();
            thinkerclass_t tclass = thinkerclass_t.values()[tmp];
            switch (tclass) {
                case tc_end: {
                    end = true;
                    continue block5;
                }
                case tc_mobj: {
                    this.PADSAVEP(this.f, this.maxsize);
                    mobj_t mobj = mobj_t.createOn(this.DOOM);
                    mobj.read(this.f);
                    mobj.id = ++id;
                    this.TL.add(mobj);
                    mobj.mobj_state = info.states[mobj.stateid];
                    mobj.target = null;
                    if (mobj.playerid != 0) {
                        mobj.player = this.DOOM.players[mobj.playerid - 1];
                        mobj.player.mo = mobj;
                    }
                    this.DOOM.levelLoader.SetThingPosition(mobj);
                    mobj.info = info.mobjinfo[mobj.type.ordinal()];
                    mobj.floorz = mobj.subsector.sector.floorheight;
                    mobj.ceilingz = mobj.subsector.sector.ceilingheight;
                    mobj.thinkerFunction = ActiveStates.P_MobjThinker;
                    this.DOOM.actions.AddThinker(mobj);
                    continue block5;
                }
            }
            this.DOOM.doomSystem.Error("Unknown tclass %d in savegame", new Object[]{tclass});
        }
        if (Engine.getConfig().equals(Settings.reconstruct_savegame_pointers, Boolean.TRUE)) {
            this.reconstructPointers();
            this.rewirePointers();
        }
    }

    protected void reconstructPointers() {
        int i;
        int player = 0;
        for (mobj_t th : this.TL) {
            if (th.player == null) continue;
            player = th.id;
            this.pointindex.put(th.player.p_mobj, th);
        }
        if (player == 0) {
            Loggers.getLogger(VanillaDSG.class.getName()).log(Level.WARNING, "Player not found, cannot reconstruct pointers!");
            return;
        }
        for (i = player - 1; i < this.TL.size() - 1; ++i) {
            int curr = this.TL.get((int)i).nextid;
            this.pointindex.put(curr, this.TL.get(i + 1));
        }
        for (i = player - 1; i > 0; --i) {
            int curr = this.TL.get((int)i).previd;
            this.pointindex.put(curr, this.TL.get(i - 1));
        }
    }

    protected void rewirePointers() {
        this.TL.forEach(th -> {
            if (th.p_target != 0) {
                th.target = this.pointindex.get(th.p_target);
                th.tracer = this.pointindex.get(th.p_tracer);
            }
        });
    }

    protected void ArchiveSpecials() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        thinker_t th = this.DOOM.actions.getThinkerCap().next;
        while (th != this.DOOM.actions.getThinkerCap()) {
            ceiling_t ceiling;
            if (buffer.position() > 0) {
                this.fo.write(buffer.array(), 0, buffer.position());
            }
            buffer.position(0);
            if (th.thinkerFunction == null) {
                int i;
                for (i = 0; !(i >= this.DOOM.actions.getMaxCeilings() || th instanceof ceiling_t && this.DOOM.actions.getActiveCeilings()[i] == (ceiling_t)th); ++i) {
                }
                if (i < 30) {
                    this.fo.writeByte(specials_e.tc_ceiling.ordinal());
                    this.PADSAVEP(this.fo);
                    ceiling = (ceiling_t)th;
                    ceiling.sectorid = ceiling.sector.id;
                    ceiling.pack(buffer);
                }
            } else if (th.thinkerFunction == ActiveStates.T_MoveCeiling) {
                this.fo.writeByte(specials_e.tc_ceiling.ordinal());
                this.PADSAVEP(this.fo);
                ceiling = (ceiling_t)th;
                ceiling.sectorid = ceiling.sector.id;
                ceiling.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_VerticalDoor) {
                this.fo.writeByte(specials_e.tc_door.ordinal());
                this.PADSAVEP(this.fo);
                vldoor_t door = (vldoor_t)th;
                door.sectorid = door.sector.id;
                door.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_MoveFloor) {
                this.fo.writeByte(specials_e.tc_floor.ordinal());
                this.PADSAVEP(this.fo);
                floormove_t floor = (floormove_t)th;
                floor.sectorid = floor.sector.id;
                floor.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_PlatRaise) {
                this.fo.writeByte(specials_e.tc_plat.ordinal());
                this.PADSAVEP(this.fo);
                plat_t plat = (plat_t)th;
                plat.sectorid = plat.sector.id;
                plat.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_LightFlash) {
                this.fo.writeByte(specials_e.tc_flash.ordinal());
                this.PADSAVEP(this.fo);
                ActionsLights.lightflash_t flash = (ActionsLights.lightflash_t)th;
                flash.sectorid = flash.sector.id;
                flash.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_StrobeFlash) {
                this.fo.writeByte(specials_e.tc_strobe.ordinal());
                this.PADSAVEP(this.fo);
                strobe_t strobe = (strobe_t)th;
                strobe.sectorid = strobe.sector.id;
                strobe.pack(buffer);
            } else if (th.thinkerFunction == ActiveStates.T_Glow) {
                this.fo.writeByte(specials_e.tc_glow.ordinal());
                this.PADSAVEP(this.fo);
                ActionsLights.glow_t glow = (ActionsLights.glow_t)th;
                glow.sectorid = glow.sector.id;
                glow.pack(buffer);
            }
            th = th.next;
        }
        if (buffer.position() > 0) {
            this.fo.write(buffer.array(), 0, buffer.position());
        }
        this.fo.writeByte((byte)specials_e.tc_endspecials.ordinal());
    }

    protected void UnArchiveSpecials() throws IOException {
        this.DOOM.actions.ClearPlatsBeforeLoading();
        this.DOOM.actions.ClearCeilingsBeforeLoading();
        block10: while (true) {
            int tmp = this.f.readUnsignedByte();
            specials_e tclass = specials_e.values()[tmp];
            switch (tclass) {
                case tc_endspecials: {
                    return;
                }
                case tc_ceiling: {
                    this.PADSAVEP(this.f, this.maxsize);
                    ceiling_t ceiling = new ceiling_t();
                    ceiling.read(this.f);
                    ceiling.sector = this.DOOM.levelLoader.sectors[ceiling.sectorid];
                    ceiling.sector.specialdata = ceiling;
                    if (ceiling.functionid != 0) {
                        ceiling.thinkerFunction = ActiveStates.T_MoveCeiling;
                    }
                    this.DOOM.actions.AddThinker(ceiling);
                    this.DOOM.actions.AddActiveCeiling(ceiling);
                    continue block10;
                }
                case tc_door: {
                    this.PADSAVEP(this.f, this.maxsize);
                    vldoor_t door = new vldoor_t();
                    door.read(this.f);
                    door.sector = this.DOOM.levelLoader.sectors[door.sectorid];
                    door.sector.specialdata = door;
                    door.thinkerFunction = ActiveStates.T_VerticalDoor;
                    this.DOOM.actions.AddThinker(door);
                    continue block10;
                }
                case tc_floor: {
                    this.PADSAVEP(this.f, this.maxsize);
                    floormove_t floor = new floormove_t();
                    floor.read(this.f);
                    floor.sector = this.DOOM.levelLoader.sectors[floor.sectorid];
                    floor.sector.specialdata = floor;
                    floor.thinkerFunction = ActiveStates.T_MoveFloor;
                    this.DOOM.actions.AddThinker(floor);
                    continue block10;
                }
                case tc_plat: {
                    this.PADSAVEP(this.f, this.maxsize);
                    plat_t plat = new plat_t();
                    plat.read(this.f);
                    plat.sector = this.DOOM.levelLoader.sectors[plat.sectorid];
                    plat.sector.specialdata = plat;
                    if (plat.functionid != 0) {
                        plat.thinkerFunction = ActiveStates.T_PlatRaise;
                    }
                    this.DOOM.actions.AddThinker(plat);
                    this.DOOM.actions.AddActivePlat(plat);
                    continue block10;
                }
                case tc_flash: {
                    this.PADSAVEP(this.f, this.maxsize);
                    ActionsLights.lightflash_t flash = new ActionsLights.lightflash_t();
                    flash.read(this.f);
                    flash.sector = this.DOOM.levelLoader.sectors[flash.sectorid];
                    flash.thinkerFunction = ActiveStates.T_LightFlash;
                    this.DOOM.actions.AddThinker(flash);
                    continue block10;
                }
                case tc_strobe: {
                    this.PADSAVEP(this.f, this.maxsize);
                    strobe_t strobe = new strobe_t();
                    strobe.read(this.f);
                    strobe.sector = this.DOOM.levelLoader.sectors[strobe.sectorid];
                    strobe.thinkerFunction = ActiveStates.T_StrobeFlash;
                    this.DOOM.actions.AddThinker(strobe);
                    continue block10;
                }
                case tc_glow: {
                    this.PADSAVEP(this.f, this.maxsize);
                    ActionsLights.glow_t glow = new ActionsLights.glow_t();
                    glow.read(this.f);
                    glow.sector = this.DOOM.levelLoader.sectors[glow.sectorid];
                    glow.thinkerFunction = ActiveStates.T_Glow;
                    this.DOOM.actions.AddThinker(glow);
                    continue block10;
                }
            }
            this.DOOM.doomSystem.Error("P_UnarchiveSpecials:Unknown tclass %d in savegame", tmp);
        }
    }

    protected final int PADSAVEP(int save_p) {
        return save_p + (4 - (save_p & 3) & 3);
    }

    protected final long PADSAVEP(DataInputStream f, int maxsize) throws IOException {
        long save_p = maxsize - f.available();
        int padding = 4 - ((int)save_p & 3) & 3;
        f.skip(padding);
        return padding;
    }

    protected final long PADSAVEP(DataOutputStream f) throws IOException {
        long save_p = f.size();
        int padding = 4 - ((int)save_p & 3) & 3;
        for (int i = 0; i < padding; ++i) {
            f.write(0);
        }
        return padding;
    }

    @Override
    public boolean doSave(DataOutputStream f) {
        try {
            this.fo = f;
            this.header.write(f);
            this.ArchivePlayers();
            this.ArchiveWorld();
            this.ArchiveThinkers();
            this.ArchiveSpecials();
            f.write(29);
        }
        catch (IOException e) {
            Loggers.getLogger(VanillaDSG.class.getName()).log(Level.WARNING, e, () -> String.format("Error while saving savegame! Cause: %s", e.getMessage()));
            return false;
        }
        return true;
    }

    protected static enum specials_e {
        tc_ceiling,
        tc_door,
        tc_floor,
        tc_plat,
        tc_flash,
        tc_strobe,
        tc_glow,
        tc_endspecials;

    }

    protected static enum thinkerclass_t {
        tc_end,
        tc_mobj;

    }
}

