/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public enum BinarySearch {


    public static <T, E extends Comparable<? super E>> int find(List<? extends T> list, Function<? super T, ? extends E> converter, E key) {
        return BinarySearch.find(list, converter, 0, list.size(), key);
    }

    public static <T, E extends Comparable<? super E>> int find(T[] array, Function<? super T, ? extends E> converter, E key) {
        return BinarySearch.find(array, converter, 0, array.length, key);
    }

    public static <T, E> int find(List<? extends T> list, Function<? super T, ? extends E> converter, Comparator<? super E> comparator, E key) {
        return BinarySearch.find(list, converter, comparator, 0, list.size(), key);
    }

    public static <T, E> int find(T[] array, Function<? super T, ? extends E> converter, Comparator<? super E> comparator, E key) {
        return BinarySearch.find(array, converter, comparator, 0, array.length, key);
    }

    public static <T> int findByInt(List<? extends T> list, ToIntFunction<? super T> converter, int key) {
        return BinarySearch.findByInt(list, converter, 0, list.size(), key);
    }

    public static <T> int findByInt(T[] array, ToIntFunction<? super T> converter, int key) {
        return BinarySearch.findByInt(array, converter, 0, array.length, key);
    }

    public static <T> int findByInt(List<? extends T> list, ToIntFunction<? super T> converter, IntBinaryOperator comparator, int key) {
        return BinarySearch.findByInt(list, converter, comparator, 0, list.size(), key);
    }

    public static <T> int findByInt(T[] array, ToIntFunction<? super T> converter, IntBinaryOperator comparator, int key) {
        return BinarySearch.findByInt(array, converter, comparator, 0, array.length, key);
    }

    public static <T> int findByLong(List<? extends T> list, ToLongFunction<? super T> converter, long key) {
        return BinarySearch.findByLong(list, converter, 0, list.size(), key);
    }

    public static <T> int findByLong(T[] array, ToLongFunction<? super T> converter, long key) {
        return BinarySearch.findByLong(array, converter, 0, array.length, key);
    }

    public static <T> int findByLong(List<? extends T> list, ToLongFunction<? super T> converter, LongComparator comparator, long key) {
        return BinarySearch.findByLong(list, converter, comparator, 0, list.size(), key);
    }

    public static <T> int findByLong(T[] array, ToLongFunction<? super T> converter, LongComparator comparator, long key) {
        return BinarySearch.findByLong(array, converter, comparator, 0, array.length, key);
    }

    public static <T> int findByDouble(List<? extends T> list, ToDoubleFunction<? super T> converter, double key) {
        return BinarySearch.findByDouble(list, converter, 0, list.size(), key);
    }

    public static <T> int findByDouble(T[] array, ToDoubleFunction<? super T> converter, double key) {
        return BinarySearch.findByDouble(array, converter, 0, array.length, key);
    }

    public static <T> int findByDouble(List<? extends T> list, ToDoubleFunction<? super T> converter, DoubleComparator comparator, double key) {
        return BinarySearch.findByDouble(list, converter, comparator, 0, list.size(), key);
    }

    public static <T> int findByDouble(T[] array, ToDoubleFunction<? super T> converter, DoubleComparator comparator, double key) {
        return BinarySearch.findByDouble(array, converter, comparator, 0, array.length, key);
    }

    public static <T, E extends Comparable<? super E>> int find(List<? extends T> list, Function<? super T, ? extends E> converter, int from, int to, E key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> ((Comparable)converter.apply((Object)getter.apply(i))).compareTo(key), from, to);
    }

    public static <T, E extends Comparable<? super E>> int find(T[] array, Function<? super T, ? extends E> converter, int from, int to, E key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> ((Comparable)converter.apply(array[i])).compareTo(key), from, to);
    }

    public static <T, E> int find(List<? extends T> list, Function<? super T, ? extends E> converter, Comparator<? super E> comparator, int from, int to, E key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> comparator.compare((Object)converter.apply((Object)getter.apply(i)), (Object)key), from, to);
    }

    public static <T, E> int find(T[] array, Function<? super T, ? extends E> converter, Comparator<? super E> comparator, int from, int to, E key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> comparator.compare((Object)converter.apply(array[i]), (Object)key), from, to);
    }

    public static <T> int findByInt(List<? extends T> list, ToIntFunction<? super T> converter, int from, int to, int key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByInt((int i) -> converter.applyAsInt((Object)getter.apply(i)), from, to, key);
    }

    public static <T> int findByInt(T[] array, ToIntFunction<? super T> converter, int from, int to, int key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByInt((int i) -> converter.applyAsInt(array[i]), from, to, key);
    }

    public static <T> int findByInt(List<? extends T> list, ToIntFunction<? super T> converter, IntBinaryOperator comparator, int from, int to, int key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> comparator.applyAsInt(converter.applyAsInt((Object)getter.apply(i)), key), from, to);
    }

    public static <T> int findByInt(T[] array, ToIntFunction<? super T> converter, IntBinaryOperator comparator, int from, int to, int key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> comparator.applyAsInt(converter.applyAsInt(array[i]), key), from, to);
    }

    public static <T> int findByLong(List<? extends T> list, ToLongFunction<? super T> converter, int from, int to, long key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByLong((int i) -> converter.applyAsLong((Object)getter.apply(i)), from, to, key);
    }

    public static <T> int findByLong(T[] array, ToLongFunction<? super T> converter, int from, int to, long key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByLong((int i) -> converter.applyAsLong(array[i]), from, to, key);
    }

    public static <T> int findByLong(List<? extends T> list, ToLongFunction<? super T> converter, LongComparator comparator, int from, int to, long key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> comparator.compareAsLong(converter.applyAsLong((Object)getter.apply(i)), key), from, to);
    }

    public static <T> int findByLong(T[] array, ToLongFunction<? super T> converter, LongComparator comparator, int from, int to, long key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> comparator.compareAsLong(converter.applyAsLong(array[i]), key), from, to);
    }

    public static <T> int findByDouble(List<? extends T> list, ToDoubleFunction<? super T> converter, int from, int to, double key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByDouble((int i) -> converter.applyAsDouble((Object)getter.apply(i)), from, to, key);
    }

    public static <T> int findByDouble(T[] array, ToDoubleFunction<? super T> converter, int from, int to, double key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByDouble((int i) -> converter.applyAsDouble(array[i]), from, to, key);
    }

    public static <T> int findByDouble(List<? extends T> list, ToDoubleFunction<? super T> converter, DoubleComparator comparator, int from, int to, double key) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> comparator.compareAsDouble(converter.applyAsDouble((Object)getter.apply(i)), key), from, to);
    }

    public static <T> int findByDouble(T[] array, ToDoubleFunction<? super T> converter, DoubleComparator comparator, int from, int to, double key) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> comparator.compareAsDouble(converter.applyAsDouble(array[i]), key), from, to);
    }

    public static <E extends Comparable<? super E>> int find(IntFunction<? extends E> getter, int from, int to, E key) {
        return BinarySearch.findByIndex(i -> ((Comparable)getter.apply(i)).compareTo(key), from, to);
    }

    public static <E> int find(IntFunction<? extends E> getter, Comparator<? super E> comparator, int from, int to, E key) {
        return BinarySearch.findByIndex(i -> comparator.compare((Object)getter.apply(i), (Object)key), from, to);
    }

    public static int findByInt(IntUnaryOperator getter, int from, int to, int key) {
        return BinarySearch.findByInt(getter, Integer::compare, from, to, key);
    }

    public static int findByInt(IntUnaryOperator getter, IntBinaryOperator comparator, int from, int to, int key) {
        return BinarySearch.findByIndex(i -> comparator.applyAsInt(getter.applyAsInt(i), key), from, to);
    }

    public static int findByLong(LongGetter getter, int from, int to, long key) {
        return BinarySearch.findByLong(getter, Long::compare, from, to, key);
    }

    public static int findByLong(LongGetter getter, LongComparator comparator, int from, int to, long key) {
        return BinarySearch.findByIndex(i -> comparator.compareAsLong(getter.getAsLong(i), key), from, to);
    }

    public static int findByDouble(DoubleGetter getter, int from, int to, double key) {
        return BinarySearch.findByDouble(getter, Double::compare, from, to, key);
    }

    public static int findByDouble(DoubleGetter getter, DoubleComparator comparator, int from, int to, double key) {
        return BinarySearch.findByIndex(i -> comparator.compareAsDouble(getter.getAsDouble(i), key), from, to);
    }

    public static <T> int findByMatch(T[] array, ToIntFunction<? super T> matcher) {
        return BinarySearch.findByMatch(array, matcher, 0, array.length);
    }

    public static <T> int findByMatch(List<? extends T> list, ToIntFunction<? super T> matcher) {
        return BinarySearch.findByMatch(list, matcher, 0, list.size());
    }

    public static <T> int findByMatch(T[] array, ToIntFunction<? super T> matcher, int from, int to) {
        BinarySearch.rangeCheck(array.length, from, to);
        return BinarySearch.findByIndex(i -> matcher.applyAsInt(array[i]), from, to);
    }

    public static <T> int findByMatch(List<? extends T> list, ToIntFunction<? super T> matcher, int from, int to) {
        IntFunction getter = BinarySearch.listGetter(list);
        return BinarySearch.findByIndex(i -> matcher.applyAsInt((Object)getter.apply(i)), from, to);
    }

    public static int findByIndex(IntUnaryOperator comparator, int from, int to) {
        int low = from;
        int high = to - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = comparator.applyAsInt(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static <T> T get(ListIterator<? extends T> i, int index) {
        T obj = null;
        int pos = i.nextIndex();
        if (pos <= index) {
            do {
                obj = i.next();
            } while (pos++ < index);
        } else {
            do {
                obj = i.previous();
            } while (--pos > index);
        }
        return obj;
    }

    private static <T, L extends List<? extends T>> IntFunction<? extends T> listGetter(L list) {
        if (list instanceof RandomAccess) {
            return list::get;
        }
        ListIterator it = list.listIterator();
        return i -> BinarySearch.get(it, i);
    }

    @FunctionalInterface
    public static interface DoubleGetter {
        public double getAsDouble(int var1);
    }

    @FunctionalInterface
    public static interface LongGetter {
        public long getAsLong(int var1);
    }

    @FunctionalInterface
    public static interface DoubleComparator {
        public int compareAsDouble(double var1, double var3);
    }

    @FunctionalInterface
    public static interface LongComparator {
        public int compareAsLong(long var1, long var3);
    }
}

