/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Optional;
import utils.C2JUtils;

public enum QuoteType {
    SINGLE('\''),
    DOUBLE('\"');

    public final char quoteChar;

    private QuoteType(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    public boolean isQuoted(String s) {
        return C2JUtils.isQuoted(s, this.quoteChar);
    }

    public String unQuote(String s) {
        return C2JUtils.unquote(s, this.quoteChar);
    }

    public static Optional<QuoteType> getQuoteType(String stringSource) {
        if (stringSource.length() > 2) {
            for (QuoteType type : QuoteType.values()) {
                if (!type.isQuoted(stringSource)) continue;
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }
}

