/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ResourceIO {
    private final Path file;
    private final Charset charset = Charset.forName("US-ASCII");

    public ResourceIO(File file) {
        this.file = file.toPath();
    }

    public ResourceIO(Path file) {
        this.file = file;
    }

    public ResourceIO(String path) {
        this.file = FileSystems.getDefault().getPath(path, new String[0]);
    }

    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readLines(Consumer<String> lineConsumer) {
        if (!Files.exists(this.file, new LinkOption[0])) return false;
        try (BufferedReader reader = Files.newBufferedReader(this.file, this.charset);){
            String line;
            while ((line = reader.readLine()) != null) {
                lineConsumer.accept(line);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeLines(Supplier<String> lineSupplier, OpenOption ... options) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, this.charset, options);){
            String line;
            while ((line = lineSupplier.get()) != null) {
                writer.write(line, 0, line.length());
                writer.newLine();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
            return false;
        }
    }

    public String getFileame() {
        return this.file.toString();
    }
}

