/*
 * Decompiled with CFR 0.152.
 */
package v;

import f.Wiper;
import java.awt.Image;
import java.awt.Rectangle;
import m.IRandom;
import m.Settings;
import mochadoom.Engine;
import rr.patch_t;
import v.graphics.Horizontal;
import v.graphics.Plotter;
import v.graphics.Relocation;
import v.renderers.DoomScreen;
import v.scale.VideoScale;
import v.tables.BlurryTable;

public interface DoomGraphicSystem<T, V> {
    public static final int V_NOSCALESTART = 65536;
    public static final int V_SCALESTART = 131072;
    public static final int V_SCALEPATCH = 262144;
    public static final int V_NOSCALEPATCH = 524288;
    public static final int V_WHITEMAP = 0x100000;
    public static final int V_FLIPPEDPATCH = 0x200000;
    public static final int V_TRANSLUCENTPATCH = 0x400000;
    public static final int V_PREDIVIDE = 0x800000;
    public static final int V_SCALEOFFSET = 0x1000000;
    public static final int V_NOSCALEOFFSET = 0x2000000;
    public static final int V_SAFESCALE = 0x4000000;

    public V getScreen(DoomScreen var1);

    public int getScalingX();

    public int getScalingY();

    public int getScreenWidth();

    public int getScreenHeight();

    public void screenCopy(V var1, V var2, Relocation var3);

    public void screenCopy(DoomScreen var1, DoomScreen var2);

    public void setUsegamma(int var1);

    public int getUsegamma();

    public void setPalette(int var1);

    public int getPalette();

    public int getBaseColor(byte var1);

    public int getBaseColor(int var1);

    public int point(int var1, int var2);

    public int point(int var1, int var2, int var3);

    public void drawLine(Plotter<?> var1, int var2, int var3);

    public void DrawPatch(DoomScreen var1, patch_t var2, int var3, int var4, int ... var5);

    public void DrawPatchCentered(DoomScreen var1, patch_t var2, int var3, int ... var4);

    public void DrawPatchCenteredScaled(DoomScreen var1, patch_t var2, VideoScale var3, int var4, int ... var5);

    public void DrawPatchScaled(DoomScreen var1, patch_t var2, VideoScale var3, int var4, int var5, int ... var6);

    public void DrawPatchColScaled(DoomScreen var1, patch_t var2, VideoScale var3, int var4, int var5);

    public void CopyRect(DoomScreen var1, Rectangle var2, DoomScreen var3);

    public void CopyRect(DoomScreen var1, Rectangle var2, DoomScreen var3, int var4);

    public void FillRect(DoomScreen var1, Rectangle var2, V var3, Horizontal var4);

    public void FillRect(DoomScreen var1, Rectangle var2, V var3, int var4);

    public void FillRect(DoomScreen var1, Rectangle var2, int var3);

    public void FillRect(DoomScreen var1, Rectangle var2, byte var3);

    public V convertPalettedBlock(byte ... var1);

    public V ScaleBlock(V var1, VideoScale var2, int var3, int var4);

    public void TileScreen(DoomScreen var1, V var2, Rectangle var3);

    public void TileScreenArea(DoomScreen var1, Rectangle var2, V var3, Rectangle var4);

    public void DrawBlock(DoomScreen var1, V var2, Rectangle var3, int var4);

    public Image getScreenImage();

    public boolean writeScreenShot(String var1, DoomScreen var2);

    public V[] getColorMap();

    default public Plotter<V> createPlotter(DoomScreen screen) {
        switch (Engine.getConfig().getValue(Settings.automap_plotter_style, Plotter.Style.class)) {
            case Thick: {
                return new Plotter.Thick<V>(this.getScreen(screen), this.getScreenWidth(), this.getScreenHeight());
            }
            case Deep: {
                return new Plotter.Deep<V>(this.getScreen(screen), this.getScreenWidth(), this.getScreenHeight());
            }
        }
        return new Plotter.Thin<V>(this.getScreen(screen), this.getScreenWidth());
    }

    public Wiper createWiper(IRandom var1);

    public BlurryTable getBlurryTable();

    default public void forcePalette() {
    }
}

