/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import v.tables.ColorTint;

public interface Colors {
    default public int getAlpha(int argb8888) {
        return argb8888 >>> 24 & 0xFF;
    }

    default public int getRed(int rgb888) {
        return (0xFF0000 & rgb888) >> 16;
    }

    default public int getRed5(int rgb555) {
        return rgb555 >> 10 & 0x1F;
    }

    default public int getGreen(int rgb888) {
        return (0xFF00 & rgb888) >> 8;
    }

    default public int getGreen5(int rgb555) {
        return rgb555 >> 5 & 0x1F;
    }

    default public int getBlue(int rgb888) {
        return 0xFF & rgb888;
    }

    default public int getBlue5(int rgb555) {
        return rgb555 & 0x1F;
    }

    default public int[] getARGB8888(int argb8888, int[] container) {
        container[0] = this.getAlpha(argb8888);
        container[1] = this.getRed(argb8888);
        container[2] = this.getGreen(argb8888);
        container[3] = this.getBlue(argb8888);
        return container;
    }

    default public int[] getRGB888(int rgb888, int[] container) {
        container[0] = this.getRed(rgb888);
        container[1] = this.getGreen(rgb888);
        container[2] = this.getBlue(rgb888);
        return container;
    }

    default public int[] getRGB555(int rgb555, int[] container) {
        container[0] = this.getRed5(rgb555);
        container[1] = this.getGreen5(rgb555);
        container[2] = this.getBlue5(rgb555);
        return container;
    }

    default public int toRGB888(int r, int g, int b) {
        return -16777216 + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    default public int toARGB8888(int a, int r, int g, int b) {
        return ((a & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    default public short toRGB555(int r, int g, int b) {
        return (short)(((r & 0x1F) << 10) + ((g & 0x1F) << 5) + (b & 0x1F));
    }

    default public int[] tintRGB888(ColorTint tint, int[] rgbInput, int[] rgbOutput) {
        rgbOutput[0] = tint.tintRed8(rgbInput[0]);
        rgbOutput[1] = tint.tintGreen8(rgbInput[1]);
        rgbOutput[2] = tint.tintBlue8(rgbInput[2]);
        return rgbOutput;
    }

    default public int[] tintRGB555(ColorTint tint, int[] rgbInput, int[] rgbOutput) {
        rgbOutput[0] = tint.tintRed5(rgbInput[0]);
        rgbOutput[1] = tint.tintGreen5(rgbInput[1]);
        rgbOutput[2] = tint.tintBlue5(rgbInput[2]);
        return rgbOutput;
    }

    default public double sigmoid(double r) {
        return 1.0 / (1.0 + Math.pow(Math.E, -1.0 * r));
    }

    default public int sigmoidGradient(int component1, int component2, float ratio) {
        return (int)(ratio * (float)component1 + (1.0f - ratio) * (float)component2);
    }

    default public int CompareColors888(int rgb888_1, int rgb888_2) {
        long distance = this.ColorDistance888(rgb888_1, rgb888_2);
        return distance > 0L ? 1 : (distance < 0L ? -1 : 0);
    }

    default public long ColorDistance888(int rgb888_1, int rgb888_2) {
        int r1 = this.getRed(rgb888_1);
        int g1 = this.getGreen(rgb888_1);
        int b1 = this.getBlue(rgb888_1);
        int r2 = this.getRed(rgb888_2);
        int g2 = this.getGreen(rgb888_2);
        int b2 = this.getBlue(rgb888_2);
        long dr = r1 - r2;
        long dg = g1 - g2;
        long db = b1 - b2;
        return dr * dr + dg * dg + db * db;
    }

    default public int CompareColorsHSV888(int rgb888_1, int rgb888_2) {
        long distance = this.ColorDistanceHSV888(rgb888_1, rgb888_2);
        return distance > 0L ? 1 : (distance < 0L ? -1 : 0);
    }

    default public long ColorDistanceHSV888(int rgb888_1, int rgb888_2) {
        int r1 = (int)(0.21 * (double)this.getRed(rgb888_1));
        int g1 = (int)(0.72 * (double)this.getGreen(rgb888_1));
        int b1 = (int)(0.07 * (double)this.getBlue(rgb888_1));
        int r2 = (int)(0.21 * (double)this.getRed(rgb888_2));
        int g2 = (int)(0.72 * (double)this.getGreen(rgb888_2));
        int b2 = (int)(0.07 * (double)this.getBlue(rgb888_2));
        long dr = r1 - r2;
        long dg = g1 - g2;
        long db = b1 - b2;
        return dr * dr + dg * dg + db * db;
    }

    default public int CompareColors555(short rgb555_1, short rgb555_2) {
        long distance = this.ColorDistance555(rgb555_1, rgb555_2);
        return distance > 0L ? 1 : (distance < 0L ? -1 : 0);
    }

    default public long ColorDistance555(short rgb1, short rgb2) {
        int r1 = this.getRed5(rgb1);
        int g1 = this.getGreen5(rgb1);
        int b1 = this.getBlue5(rgb1);
        int r2 = this.getRed5(rgb2);
        int g2 = this.getGreen5(rgb2);
        int b2 = this.getBlue5(rgb2);
        long dr = r1 - r2;
        long dg = g1 - g2;
        long db = b1 - b2;
        return dr * dr + dg * dg + db * db;
    }

    default public int CompareColorsHSV555(short rgb555_1, short rgb555_2) {
        long distance = this.ColorDistanceHSV555(rgb555_1, rgb555_2);
        return distance > 0L ? 1 : (distance < 0L ? -1 : 0);
    }

    default public long ColorDistanceHSV555(short rgb555_1, int rgb555_2) {
        int r1 = (int)(0.21 * (double)this.getRed5(rgb555_1));
        int g1 = (int)(0.72 * (double)this.getGreen5(rgb555_1));
        int b1 = (int)(0.07 * (double)this.getBlue5(rgb555_1));
        int r2 = (int)(0.21 * (double)this.getRed5(rgb555_2));
        int g2 = (int)(0.72 * (double)this.getGreen5(rgb555_2));
        int b2 = (int)(0.07 * (double)this.getBlue5(rgb555_2));
        long dr = r1 - r2;
        long dg = g1 - g2;
        long db = b1 - b2;
        return dr * dr + dg * dg + db * db;
    }

    default public float[] ColorRatio(int[] rgb1, int[] rgb2, float[] out) {
        for (int i = 0; i < 3; ++i) {
            out[i] = rgb2[i] > 0 ? (float)rgb1[i] / (float)rgb2[i] : 1.0f;
        }
        return out;
    }

    default public int rgb555to888(short rgb555) {
        int ri = (0x7C00 & rgb555) >> 7;
        int gi = (0x3E0 & rgb555) >> 2;
        int bi = (0x1F & rgb555) << 3;
        int bits = (ri & 0xE0) >> 5;
        ri += bits;
        bits = (gi & 0xE0) >> 5;
        gi += bits;
        bits = (bi & 0xE0) >> 5;
        return this.toRGB888(ri, gi, bi += bits);
    }

    default public short argb8888to555(int argb8888) {
        int ri = (0xFF010000 & argb8888) >> 19;
        int gi = (0xFF00 & argb8888) >> 11;
        int bi = (0xFF & argb8888) >> 3;
        return this.toRGB555(ri, gi, bi);
    }

    default public short rgb888to555(int r, int g, int b) {
        return this.toRGB555(r >> 3, g >> 3, b >> 3);
    }

    default public int BestColor(int r, int g, int b, int[] palette, int rangel, int rangeh) {
        long bestdistortion = ((long)r * (long)r + (long)g * (long)g + (long)b * (long)b) * 2L;
        int bestcolor = 0;
        for (int i = rangel; i <= rangeh; ++i) {
            long db;
            long dg;
            long dr = r - this.getRed(palette[i]);
            long distortion = dr * dr + (dg = (long)(g - this.getGreen(palette[i]))) * dg + (db = (long)(b - this.getBlue(palette[i]))) * db;
            if (distortion >= bestdistortion) continue;
            if (distortion == 0L) {
                return i;
            }
            bestdistortion = distortion;
            bestcolor = i;
        }
        return bestcolor;
    }
}

