/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import utils.C2JUtils;
import v.graphics.ColorTransform;
import v.graphics.Wipers;

public interface Melt
extends ColorTransform {
    default public boolean initMeltScaled(Wipers.WiperImpl<?, ?> wiper) {
        return this.initMelt(wiper, true);
    }

    default public boolean initMelt(Wipers.WiperImpl<?, ?> wiper) {
        return this.initMelt(wiper, false);
    }

    default public boolean initMelt(Wipers.WiperImpl<?, ?> wiper, boolean scaled) {
        C2JUtils.memcpy(wiper.wipeStartScr, wiper.wipeScr, wiper.screenWidth * wiper.screenHeight);
        this.setupColumnPositions(wiper, scaled);
        return false;
    }

    default public void setupColumnPositions(Wipers.WiperImpl<?, ?> wiper, boolean scaled) {
        int lim = scaled ? wiper.screenWidth / wiper.dupy : wiper.screenWidth;
        wiper.y = new int[lim];
        wiper.y[0] = -(wiper.random.M_Random() % 16);
        for (int i = 1; i < lim; ++i) {
            int r = wiper.random.M_Random() % 3 - 1;
            wiper.y[i] = wiper.y[i - 1] + r;
            if (wiper.y[i] > 0) {
                wiper.y[i] = 0;
                continue;
            }
            if (wiper.y[i] != -16) continue;
            wiper.y[i] = -15;
        }
    }

    default public void toScreen(Class<?> bufType, Object src, Object dest, int width, int dy, int ps, int pd) {
        if (bufType == int[].class) {
            int[] to = (int[])src;
            int[] from = (int[])dest;
            for (int i = 0; i < dy; ++i) {
                int iWidth = width * i;
                to[pd + iWidth] = from[ps + iWidth];
            }
        } else if (bufType == short[].class) {
            short[] to = (short[])src;
            short[] from = (short[])dest;
            for (int i = 0; i < dy; ++i) {
                int iWidth = width * i;
                to[pd + iWidth] = from[ps + iWidth];
            }
        } else if (bufType == byte[].class) {
            byte[] to = (byte[])src;
            byte[] from = (byte[])dest;
            for (int i = 0; i < dy; ++i) {
                int iWidth = width * i;
                to[pd + iWidth] = from[ps + iWidth];
            }
        } else {
            throw new UnsupportedOperationException("Do not have support for: " + bufType);
        }
    }

    default public void toScreenScaled(Wipers.WiperImpl<?, ?> wiper, Object from, int dy, int ps, int pd) {
        for (int i = 0; i < dy; ++i) {
            int iWidth = wiper.screenWidth * i;
            System.arraycopy(from, ps + iWidth, wiper.wipeScr, pd + iWidth, wiper.dupy);
        }
    }

    default public boolean doMeltScaled(Wipers.WiperImpl<?, ?> wiper) {
        return this.doMelt(wiper, true);
    }

    default public boolean doMelt(Wipers.WiperImpl<?, ?> wiper) {
        return this.doMelt(wiper, false);
    }

    default public boolean doMelt(Wipers.WiperImpl<?, ?> wiper, boolean scaled) {
        int lim = scaled ? wiper.screenWidth / wiper.dupy : wiper.screenWidth;
        boolean done = true;
        while (wiper.ticks-- > 0) {
            for (int i = 0; i < lim; ++i) {
                int dy;
                if (wiper.y[i] < 0) {
                    int n = i;
                    wiper.y[n] = wiper.y[n] + 1;
                    done = false;
                    continue;
                }
                if (wiper.y[i] >= wiper.screenHeight) continue;
                int n = wiper.y[i] < wiper.scaled_16 ? wiper.y[i] + (scaled ? wiper.dupy : 1) : (dy = wiper.scaled_8);
                if (wiper.y[i] + dy >= wiper.screenHeight) {
                    dy = wiper.screenHeight - wiper.y[i];
                }
                int pd = wiper.y[i] * wiper.screenWidth + (scaled ? i * wiper.dupx : i);
                if (scaled) {
                    this.toScreenScaled(wiper, wiper.wipeEndScr, dy, pd, pd);
                } else {
                    this.toScreen(wiper.bufferType, wiper.wipeScr, wiper.wipeEndScr, wiper.screenWidth, dy, pd, pd);
                }
                int n2 = i;
                wiper.y[n2] = wiper.y[n2] + dy;
                pd += dy * wiper.screenWidth;
                if (scaled) {
                    this.toScreenScaled(wiper, wiper.wipeStartScr, wiper.screenHeight - wiper.y[i], i * wiper.dupy, pd);
                } else {
                    this.toScreen(wiper.bufferType, wiper.wipeScr, wiper.wipeStartScr, wiper.screenWidth, wiper.screenHeight - wiper.y[i], i, pd);
                }
                done = false;
            }
        }
        return done;
    }

    default public boolean exitMelt(Wipers.WiperImpl<?, ?> wiper) {
        wiper.y = null;
        wiper.ticks = 0;
        return false;
    }
}

