/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.awt.image.IndexColorModel;
import v.graphics.Lights;
import v.tables.GammaTables;

public interface Palettes
extends Lights {
    public static final int PAL_NUM_COLORS = 256;
    public static final int PAL_NUM_STRIDES = 3;
    public static final int NUM_PALETTES = 14;

    public void setUsegamma(int var1);

    public int getUsegamma();

    public void setPalette(int var1);

    public int getPalette();

    public int getBaseColor(byte var1);

    default public int getBaseColor(int color) {
        return this.getBaseColor((byte)color);
    }

    default public int paletteToRGB888(byte[] pal, int index) {
        return this.toRGB888(pal[index], pal[index + 1], pal[index + 2]);
    }

    default public short paletteToRGB555(byte[] pal, int index) {
        return this.rgb888to555(pal[index], pal[index + 1], pal[index + 2]);
    }

    default public int[] getPaletteRGB888(byte[] pal, int index, int[] container) {
        container[0] = pal[index] & 0xFF;
        container[1] = pal[index + 1] & 0xFF;
        container[2] = pal[index + 2] & 0xFF;
        return container;
    }

    default public void ColorShiftPalette(byte[] inpal, byte[] outpal, int r, int g, int b, int shift, int steps) {
        int in_p = 0;
        int out_p = 0;
        for (int i = 0; i < 256; ++i) {
            int dr = r - inpal[in_p + 0];
            int dg = g - inpal[in_p + 1];
            int db = b - inpal[in_p + 2];
            outpal[out_p + 0] = (byte)(inpal[in_p + 0] + dr * shift / steps);
            outpal[out_p + 1] = (byte)(inpal[in_p + 1] + dg * shift / steps);
            outpal[out_p + 2] = (byte)(inpal[in_p + 2] + db * shift / steps);
            in_p += 3;
            out_p += 3;
        }
    }

    default public int[] paletteTrueColor(byte[] pal) {
        int[] pal888 = new int[256];
        for (int x = 0; x < 256; ++x) {
            pal888[x] = this.paletteToRGB888(pal, x * 3);
        }
        return pal888;
    }

    default public short[] paletteHiColor(byte[] pal) {
        short[] pal555 = new short[256];
        for (int x = 0; x < 256; ++x) {
            pal555[x] = this.paletteToRGB555(pal, x * 3);
        }
        return pal555;
    }

    default public IndexColorModel[][] cmapIndexed(IndexColorModel[][] icms, byte[] pal) {
        int colorsXstride = 768;
        for (int i = 0; i < icms[0].length; ++i) {
            icms[0][i] = this.createIndexColorModel(pal, i * 768);
        }
        byte[] tmpcmap = new byte[768];
        for (int j = 1; j < GammaTables.LUT.length; ++j) {
            for (int i = 0; i < 14; ++i) {
                for (int k = 0; k < 256; ++k) {
                    int iXcolorsXstride_plus_StrideXk = i * 768 + 3 * k;
                    tmpcmap[3 * k] = (byte)GammaTables.LUT[j][0xFF & pal[iXcolorsXstride_plus_StrideXk]];
                    tmpcmap[3 * k + 1] = (byte)GammaTables.LUT[j][0xFF & pal[1 + iXcolorsXstride_plus_StrideXk]];
                    tmpcmap[3 * k + 2] = (byte)GammaTables.LUT[j][0xFF & pal[2 + iXcolorsXstride_plus_StrideXk]];
                }
                icms[j][i] = this.createIndexColorModel(tmpcmap, 0);
            }
        }
        return icms;
    }

    default public IndexColorModel createIndexColorModel(byte[] cmap, int start) {
        return new IndexColorModel(8, 256, cmap, start, false);
    }
}

