/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.util.logging.Level;
import mochadoom.Loggers;
import rr.patch_t;
import utils.C2JUtils;
import v.graphics.Columns;
import v.graphics.Horizontal;
import v.graphics.Screens;
import v.scale.VideoScale;

public interface Patches<V, E extends Enum<E>>
extends Columns<V, E> {
    default public void DrawPatch(E screen, patch_t patch, int x, int y, int ... flags) {
        this.DrawPatchScaled(screen, patch, null, x, y, flags);
    }

    default public void DrawPatchCentered(E screen, patch_t patch, int y, int ... flags) {
        this.DrawPatchCenteredScaled(screen, patch, null, y, flags);
    }

    default public void DrawPatchCenteredScaled(E screen, patch_t patch, VideoScale vs, int y, int ... flags) {
        int dupx;
        int dupy;
        int flagsV;
        int n = flagsV = flags.length > 0 ? flags[0] : 0;
        if (vs != null) {
            if (C2JUtils.flags(flagsV, 0x4000000)) {
                dupx = dupy = vs.getSafeScaling();
            } else {
                dupx = vs.getScalingX();
                dupy = vs.getScalingY();
            }
        } else {
            dupy = 1;
            dupx = 1;
        }
        boolean predevide = C2JUtils.flags(flagsV, 0x800000);
        boolean scaleOffset = !C2JUtils.flags(flagsV, 0x2000000) || C2JUtils.flags(flagsV, 0x1000000);
        boolean scaleStart = !C2JUtils.flags(flagsV, 65536) || C2JUtils.flags(flagsV, 131072);
        boolean noScalePatch = C2JUtils.flags(flagsV, 524288) && !C2JUtils.flags(flagsV, 262144);
        boolean flip = C2JUtils.flags(flagsV, 0x200000);
        int halfWidth = noScalePatch ? patch.width / 2 : patch.width * dupx / 2;
        int x = this.getScreenWidth() / 2 - halfWidth - (scaleOffset ? patch.leftoffset * dupx : patch.leftoffset);
        y = this.applyScaling(y, patch.topoffset, dupy, predevide, scaleOffset, scaleStart);
        if (noScalePatch) {
            dupy = 1;
            dupx = 1;
        }
        try {
            this.doRangeCheck(x, y, patch, dupx, dupy);
            this.DrawPatchColumns(this.getScreen(screen), patch, x, y, dupx, dupy, flip);
        }
        catch (Screens.BadRangeException ex) {
            this.printDebugPatchInfo(patch, x, y, predevide, scaleOffset, scaleStart, dupx, dupy);
        }
    }

    default public void printDebugPatchInfo(patch_t patch, int x, int y, boolean predevide, boolean scaleOffset, boolean scaleStart, int dupx, int dupy) {
        Loggers.getLogger(Patches.class.getName()).log(Level.INFO, () -> String.format("V_DrawPatch: bad patch (ignored)\nPatch %s at %d, %d exceeds LFB\n\tpredevide: %s\n\tscaleOffset: %s\n\tscaleStart: %s\n\tdupx: %s, dupy: %s\n\tleftoffset: %s\n\ttopoffset: %s\n", patch.name, x, y, predevide, scaleOffset, scaleStart, dupx, dupy, patch.leftoffset, patch.topoffset));
    }

    default public void DrawPatchScaled(E screen, patch_t patch, VideoScale vs, int x, int y, int ... flags) {
        int dupx;
        int dupy;
        int flagsV;
        int n = flagsV = flags.length > 0 ? flags[0] : 0;
        if (vs != null) {
            if (C2JUtils.flags(flagsV, 0x4000000)) {
                dupx = dupy = vs.getSafeScaling();
            } else {
                dupx = vs.getScalingX();
                dupy = vs.getScalingY();
            }
        } else {
            dupy = 1;
            dupx = 1;
        }
        boolean predevide = C2JUtils.flags(flagsV, 0x800000);
        boolean scaleOffset = !C2JUtils.flags(flagsV, 0x2000000) || C2JUtils.flags(flagsV, 0x1000000);
        boolean scaleStart = !C2JUtils.flags(flagsV, 65536) || C2JUtils.flags(flagsV, 131072);
        boolean noScalePatch = C2JUtils.flags(flagsV, 524288) && !C2JUtils.flags(flagsV, 262144);
        boolean flip = C2JUtils.flags(flagsV, 0x200000);
        x = this.applyScaling(x, patch.leftoffset, dupx, predevide, scaleOffset, scaleStart);
        y = this.applyScaling(y, patch.topoffset, dupy, predevide, scaleOffset, scaleStart);
        if (noScalePatch) {
            dupy = 1;
            dupx = 1;
        }
        try {
            this.doRangeCheck(x, y, patch, dupx, dupy);
            this.DrawPatchColumns(this.getScreen(screen), patch, x, y, dupx, dupy, flip);
        }
        catch (Screens.BadRangeException ex) {
            this.printDebugPatchInfo(patch, x, y, predevide, scaleOffset, scaleStart, dupx, dupy);
        }
    }

    default public void DrawPatchColScaled(E screen, patch_t patch, VideoScale vs, int x, int col) {
        int dupx = vs.getScalingX();
        int dupy = vs.getScalingY();
        x -= patch.leftoffset;
        this.DrawColumn(this.getScreen(screen), patch.columns[col], new Horizontal(this.point(x *= dupx, 0), dupx), this.convertPalettedBlock(patch.columns[col].data), this.getScreenWidth(), dupy);
    }

    default public int applyScaling(int c, int offset, int dup, boolean predevide, boolean scaleOffset, boolean scaleStart) {
        if (predevide) {
            c /= this.getScalingX();
        }
        if (scaleStart) {
            c *= dup;
        }
        return c -= scaleOffset ? offset * dup : offset;
    }
}

