/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.lang.reflect.Array;
import java.util.Objects;
import utils.GenericCopy;
import v.graphics.Direction;

public interface Plotter<V> {
    default public Plotter<V> setColorSource(V colorSource) {
        return this.setColorSource(colorSource, 0);
    }

    public Plotter<V> setColorSource(V var1, int var2);

    public Plotter<V> setPosition(int var1, int var2);

    public Plotter<V> setThickness(int var1, int var2);

    public Plotter<V> plot();

    public Plotter<V> shiftX(int var1);

    public Plotter<V> shiftY(int var1);

    public int getX();

    public int getY();

    default public Plotter<V> shift(int shiftX, int shiftY) {
        return this.shiftX(shiftX).shiftY(shiftY);
    }

    public static int getThickness(int dupX) {
        return Math.max(dupX >> 1, 1);
    }

    public static class Deep<V>
    extends Thick<V> {
        protected Direction direction;

        public Deep(V screen, int width, int height) {
            super(screen, width, height);
        }

        @Override
        public Plotter<V> setPosition(int x, int y) {
            this.direction = Direction.CENTER;
            return super.setPosition(x, y);
        }

        @Override
        public Plotter<V> shiftX(int shift) {
            this.direction = this.direction.rotationHor(shift);
            return super.shiftX(shift);
        }

        @Override
        public Plotter<V> shiftY(int shift) {
            this.direction = this.direction.rotationVert(shift);
            return super.shiftY(shift);
        }

        @Override
        public Plotter<V> shift(int shiftX, int shiftY) {
            this.direction = this.direction.rotation(shiftX, shiftY);
            return super.shift(shiftX, shiftY);
        }

        @Override
        public Plotter<V> plot() {
            if (this.xThick <= 1 || this.yThick <= 1) {
                return super.plot();
            }
            int modThickX = this.xThick;
            int modThickY = this.yThick;
            if (!this.direction.hasTop && !this.direction.hasBottom) {
                modThickX >>= 1;
            }
            if (!this.direction.hasLeft && !this.direction.hasRight) {
                modThickY >>= 1;
            }
            return this.plotThick(modThickX, modThickY);
        }
    }

    public static class Thick<V>
    extends Abstract<V> {
        protected final int height;
        protected int xThick;
        protected int yThick;

        public Thick(V screen, int width, int height) {
            super(screen, width);
            this.height = height;
            this.xThick = 1;
            this.yThick = 1;
        }

        @Override
        public Plotter<V> setThickness(int dupX, int dupY) {
            this.xThick = dupX;
            this.yThick = dupY;
            return this;
        }

        @Override
        public Plotter<V> plot() {
            if (this.xThick == 0 || this.yThick == 0) {
                GenericCopy.memcpy(this.colorSource, 0, this.screen, this.point, 1);
                return this;
            }
            return this.plotThick(this.xThick, this.yThick);
        }

        protected Plotter<V> plotThick(int modThickX, int modThickY) {
            int rows = this.y < modThickY ? this.y : (this.height < this.y + modThickY ? this.height - this.y : modThickY);
            int spaceLeft = this.x < modThickX ? 0 : modThickX;
            int spaceRight = this.rowShift < this.x + modThickX ? this.rowShift - this.x : modThickX;
            for (int row = -rows; row < rows; ++row) {
                GenericCopy.memset(this.screen, this.point - spaceLeft + this.rowShift * row, spaceLeft + spaceRight, this.colorSource, 0, 1);
            }
            return this;
        }
    }

    public static class Thin<V>
    extends Abstract<V> {
        public Thin(V screen, int rowShift) {
            super(screen, rowShift);
        }

        @Override
        public Plotter<V> plot() {
            GenericCopy.memcpy(this.colorSource, 0, this.screen, this.point, 1);
            return this;
        }
    }

    public static abstract class Abstract<V>
    implements Plotter<V> {
        protected final V screen;
        protected final int rowShift;
        protected Style style;
        protected V colorSource;
        protected int point;
        protected int x;
        protected int y;

        Abstract(V screen, int rowShift) {
            this.screen = screen;
            this.rowShift = rowShift;
        }

        @Override
        public Plotter<V> setColorSource(V colorSource, int colorPos) {
            Objects.requireNonNull(colorSource);
            this.colorSource = Array.newInstance(colorSource.getClass().getComponentType(), 1);
            GenericCopy.memcpy(colorSource, colorPos, this.colorSource, 0, 1);
            return this;
        }

        @Override
        public Plotter<V> setThickness(int dupX, int dupY) {
            return this;
        }

        @Override
        public Plotter<V> setPosition(int x, int y) {
            this.point = y * this.rowShift + x;
            this.x = x;
            this.y = y;
            return this;
        }

        @Override
        public Plotter<V> shiftX(int shift) {
            this.point += shift;
            this.x += shift;
            return this;
        }

        @Override
        public Plotter<V> shiftY(int shift) {
            if (shift > 0) {
                this.point += this.rowShift;
                ++this.y;
            } else {
                this.point -= this.rowShift;
                --this.y;
            }
            return this;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }
    }

    public static enum Style {
        Thin,
        Thick,
        Deep;

    }
}

