/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.renderers.SoftwareIndexedVideoRenderer;

class BufferedRenderer
extends SoftwareIndexedVideoRenderer {
    private final WritableRaster[] rasters = new WritableRaster[SCREENS_COUNT];

    BufferedRenderer(RendererFactory.WithWadLoader<byte[], byte[]> rf) {
        super(rf);
        for (DoomScreen s : DoomScreen.values()) {
            int index = s.ordinal();
            DataBufferByte db = (DataBufferByte)this.newBuffer(s);
            this.rasters[index] = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, new int[]{0}, new Point(0, 0));
        }
        this.forcePalette();
    }

    @Override
    public final void forcePalette() {
        this.currentscreen = new BufferedImage(this.cmaps[this.usegamma][this.usepalette], this.rasters[DoomScreen.FG.ordinal()], true, null);
    }
}

